/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.headfootdesigner;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.form.Cell;
import com.kingdee.bos.ctrl.kdf.form.Column;
import com.kingdee.bos.ctrl.kdf.form.Container;
import com.kingdee.bos.ctrl.kdf.form.Data;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.form.Panel;
import com.kingdee.bos.ctrl.kdf.form.Row;
import com.kingdee.bos.ctrl.kdf.form.Table;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.util.Iterator;
import java.util.ListIterator;
import org.jdom2.Element;

public class HeadFootParser {
    private static int panelID = 0;
    private static int constantID = 0;
    private static int variantID = 0;
    private static int tableID = 0;
    private static int pageID = 0;
    private static final String AUTHOR_MARK = "_HF";
    private static final double dta = (double)KDToolkit.getCurrentDpi() / 72.0 * 3.0 * 1.5;

    public static HeadFootModel parseHeadFootPage2Model(Page page) {
        if (page != null) {
            Object pageChild;
            HeadFootModel model = new HeadFootModel();
            Iterator pageChildren = page.iterator();
            if (pageChildren.hasNext() && (pageChild = pageChildren.next()) instanceof Table) {
                Table mutilRowTable = (Table)pageChild;
                Iterator mutilRowTableChildren = mutilRowTable.iterator();
                while (mutilRowTableChildren.hasNext()) {
                    Object mutilRowTableChild = mutilRowTableChildren.next();
                    if (mutilRowTableChild instanceof Table) {
                        Table mutilColTable = (Table)mutilRowTableChild;
                        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)mutilColTable.getStyles());
                        Element designedTable = (Element)mutilColTable.getUserObject();
                        String text = designedTable.getAttributeValue("segmentsText");
                        model.addRow(text, sa);
                        continue;
                    }
                    return null;
                }
                return model;
            }
        }
        return null;
    }

    public static Page parseModel2HeadFootPage(HeadFootModel model) {
        if (model != null) {
            Page newPage = new Page();
            newPage.setId("page" + pageID++ + AUTHOR_MARK);
            newPage.getIdTable().put(newPage.getId(), newPage);
            Table multiRowTable = new Table();
            multiRowTable.setId("table" + tableID++ + AUTHOR_MARK);
            multiRowTable.setUserAlias(multiRowTable.getId());
            newPage.addChild(multiRowTable);
            multiRowTable.setParent(newPage);
            newPage.getIdTable().put(multiRowTable.getId(), multiRowTable);
            multiRowTable.getCols().add(new Column());
            multiRowTable.getLeft().setOriginString("[" + newPage.getId() + ".left]");
            multiRowTable.getRight().setOriginString("[" + newPage.getId() + ".right]");
            multiRowTable.getTop().setOriginString("[" + newPage.getId() + ".top]");
            multiRowTable.getBottom().setOriginString("[" + newPage.getId() + ".bottom]");
            multiRowTable.getLeft().setString(multiRowTable.getLeft().getOriginString());
            multiRowTable.getRight().setString(multiRowTable.getRight().getOriginString());
            multiRowTable.getTop().setString(multiRowTable.getTop().getOriginString());
            multiRowTable.getBottom().setString(multiRowTable.getBottom().getOriginString());
            Element designedNode = HeadFootParser.translateDesignedNode(multiRowTable, newPage.getId(), "0", "0", "0", "0", false);
            designedNode.setAttribute("layout", "widthAuto");
            multiRowTable.setUserObject(designedNode);
            int pageHeight = 0;
            ListIterator mo = model.getRows();
            while (mo.hasNext()) {
                Object item = mo.next();
                if (!(item instanceof HeadFootRow)) continue;
                HeadFootRow aRow = (HeadFootRow)item;
                Table table = HeadFootParser.parseRow2Table(aRow, newPage, multiRowTable);
                Element designedTable = new Element("DesignedTable", KDFXmlReader.NS_FORM);
                designedTable.setAttribute("segmentsText", aRow.getText());
                table.setUserObject(designedTable);
                table.setStyles((ShareStyleAttributes)aRow.getSA());
                int rowHeight = (int)((double)aRow.getSA().getFontSize() * dta);
                pageHeight += rowHeight;
                Row tableRow = new Row();
                tableRow.getHeight().setString(String.valueOf(rowHeight));
                tableRow.getHeight().setOriginString(String.valueOf(rowHeight));
                multiRowTable.getRows().add(tableRow);
                multiRowTable.setLayoutMode(1);
                int rowNo = multiRowTable.getRows().size();
                table.getLeft().setOriginString("1");
                table.getRight().setOriginString("1");
                table.getTop().setOriginString(String.valueOf(rowNo));
                table.getBottom().setOriginString(String.valueOf(rowNo));
                table.getLeft().setString(table.getLeft().getOriginString());
                table.getRight().setString(table.getRight().getOriginString());
                table.getTop().setString(table.getTop().getOriginString());
                table.getBottom().setString(table.getBottom().getOriginString());
            }
            newPage.getTop().setString("0");
            newPage.getBottom().setString(String.valueOf(pageHeight));
            newPage.getTop().setOriginString(newPage.getTop().getString());
            newPage.getBottom().setOriginString(newPage.getBottom().getString());
            Element designedPage = new Element("DesignedPage", KDFXmlReader.NS_FORM);
            designedPage.setAttribute("objHeight", String.valueOf(pageHeight));
            newPage.setUserObject(designedPage);
            return newPage;
        }
        return null;
    }

    static void updatePageID(Page page, String id) {
        Object obj = page.getIdTable().remove(page.getId());
        page.setId(id);
        page.getIdTable().put(id, obj);
        Table tbl = (Table)page.iterator().next();
        tbl.getLeft().setOriginString("[" + id + ".left]");
        tbl.getRight().setOriginString("[" + id + ".right]");
        tbl.getBottom().setOriginString("[" + id + ".bottom]");
        tbl.getTop().setOriginString("[" + id + ".top]");
        tbl.getLeft().setString("[" + id + ".left]");
        tbl.getRight().setString("[" + id + ".right]");
        tbl.getBottom().setString("[" + id + ".bottom]");
        tbl.getTop().setString("[" + id + ".top]");
    }

    private static Table parseRow2Table(HeadFootRow row, Page page, Table parent) {
        Table multiColTable = new Table();
        multiColTable.setId("table" + tableID++ + AUTHOR_MARK);
        multiColTable.setUserAlias(multiColTable.getId());
        multiColTable.getRows().add(new Row());
        parent.addChild(multiColTable);
        multiColTable.setParent(parent);
        page.getIdTable().put(multiColTable.getId(), multiColTable);
        String text = row.getText();
        String[] segments = text.split("&\\|");
        for (int i = 0; i < segments.length; ++i) {
            StyleAttributes sa = Styles.getSA((StyleAttributes)row.getSA());
            if (segments.length > 1) {
                if (i == 0) {
                    sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
                } else if (i == segments.length - 1) {
                    sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                }
            }
            Panel panel = HeadFootParser.parseSegment2Panel(segments[i], (ShareStyleAttributes)sa, page, multiColTable);
            panel.getLeft().setOriginString(String.valueOf(i + 1));
            panel.getRight().setOriginString(String.valueOf(i + 1));
            panel.getTop().setOriginString("1");
            panel.getBottom().setOriginString("1");
            panel.getLeft().setString(panel.getLeft().getOriginString());
            panel.getRight().setString(panel.getRight().getOriginString());
            panel.getTop().setString(panel.getTop().getOriginString());
            panel.getBottom().setString(panel.getBottom().getOriginString());
        }
        return multiColTable;
    }

    private static Panel parseSegment2Panel(String segment, ShareStyleAttributes ssa, Page page, Table parent) {
        Panel panel = new Panel();
        panel.setId("panel" + panelID++ + AUTHOR_MARK);
        panel.setUserAlias(panel.getId());
        parent.getCols().add(new Column());
        parent.addChild(panel);
        panel.setParent(parent);
        page.getIdTable().put(panel.getId(), panel);
        Cell fixedText = new Cell("constant");
        fixedText.setId("constant" + constantID++ + AUTHOR_MARK);
        fixedText.setUserAlias(fixedText.getId());
        page.getIdTable().put(fixedText.getId(), fixedText);
        Data data = new Data();
        fixedText.setData(data);
        String[] strings = segment.split("&\\[");
        data.setFormat(strings[0]);
        fixedText.setPriority(0);
        fixedText.getLeft().setOriginString("[" + panel.getId() + ".left]");
        fixedText.getRight().setOriginString("[" + panel.getId() + ".right]");
        fixedText.getTop().setOriginString("[" + panel.getId() + ".top]");
        fixedText.getBottom().setOriginString("[" + panel.getId() + ".bottom]");
        fixedText.getLeft().setString(fixedText.getLeft().getOriginString());
        fixedText.getRight().setString(fixedText.getRight().getOriginString());
        fixedText.getTop().setString(fixedText.getTop().getOriginString());
        fixedText.getBottom().setString(fixedText.getBottom().getOriginString());
        fixedText.setStyles(ssa);
        Element designed = HeadFootParser.translateDesignedNode(fixedText, panel.getId(), "0", "0", "0", "0", false);
        fixedText.setUserObject(designed);
        for (int i = 1; i < strings.length; ++i) {
            Cell variant = new Cell("variant");
            variant.setId("variant" + variantID++ + AUTHOR_MARK);
            variant.setUserAlias(variant.getId());
            panel.addChild(variant);
            variant.setParent(panel);
            page.getIdTable().put(variant.getId(), variant);
            data = new Data();
            int varEnd = strings[i].indexOf("]");
            String varStr = "";
            String otherStr = "";
            if (varEnd == -1) {
                varStr = strings[i];
            } else {
                varStr = strings[i].substring(0, varEnd);
                otherStr = strings[i].substring(varEnd + 1);
            }
            data.setFormat(varStr);
            variant.setData(data);
            variant.setPriority(1);
            if (i == 1) {
                String firstStr = strings[0].replaceAll("\"", "\\\"");
                variant.setPostSteps("$SETOBJVALUE(\"" + fixedText.getId() + "\", \"value\", $CONCAT(\"" + firstStr + "\",$TOSTRING($GETOUTPUTVALUE(\"text\"))));");
            } else {
                variant.setPostSteps("$SETOBJVALUE(\"" + fixedText.getId() + "\", \"value\", $CONCAT($TOSTRING($GETOBJVALUE(\"" + fixedText.getId() + "\", \"text\") ), $TOSTRING($GETOUTPUTVALUE(\"text\"))));");
            }
            if (StringUtil.equalsIgnoreCase((String)varStr, (String)"date")) {
                variant.setDataFormat("\"%c{yyyy-MM-dd" + otherStr + "}t\"");
            } else {
                variant.setDataFormat("\"%c{@" + otherStr + "}s\"");
            }
            variant.getLeft().setOriginString("[" + panel.getId() + ".left]");
            variant.getRight().setOriginString("[" + panel.getId() + ".left]+1");
            variant.getTop().setOriginString("[" + panel.getId() + ".top]");
            variant.getBottom().setOriginString("[" + panel.getId() + ".top]+1");
            variant.getLeft().setString(variant.getLeft().getOriginString());
            variant.getRight().setString(variant.getRight().getOriginString());
            variant.getTop().setString(variant.getTop().getOriginString());
            variant.getBottom().setString(variant.getBottom().getOriginString());
            designed = HeadFootParser.translateDesignedNode(variant, panel.getId(), "0", "1", "0", "1", true);
            variant.setUserObject(designed);
        }
        panel.addChild(fixedText);
        fixedText.setParent(panel);
        return panel;
    }

    private static Element translateDesignedNode(Object obj, String parentId, String left, String right, String top, String bottom, boolean isAbsolute) {
        String tagName = "DesignedCell";
        if (obj instanceof Panel) {
            tagName = "DesignedPanel";
        } else if (obj instanceof Table) {
            tagName = "DesignedTable";
        }
        Element node = new Element(tagName, KDFXmlReader.NS_FORM);
        node.setAttribute("locked", "false");
        node.setAttribute("leftLocationType", "relative");
        node.setAttribute("leftRelativeObjID", parentId);
        node.setAttribute("leftRelativeBorder", "left");
        node.setAttribute("leftRelativeOffset", left);
        node.setAttribute("rightLocationType", "relative");
        if (isAbsolute) {
            node.setAttribute("rightRelativeObjID", ((Container)obj).getId());
            node.setAttribute("rightRelativeBorder", "left");
        } else {
            node.setAttribute("rightRelativeObjID", parentId);
            node.setAttribute("rightRelativeBorder", "right");
        }
        node.setAttribute("rightRelativeOffset", right);
        node.setAttribute("topLocationType", "relative");
        node.setAttribute("topRelativeObjID", parentId);
        node.setAttribute("topRelativeBorder", "top");
        node.setAttribute("topRelativeOffset", top);
        node.setAttribute("bottomLocationType", "relative");
        if (isAbsolute) {
            node.setAttribute("bottomRelativeObjID", ((Container)obj).getId());
            node.setAttribute("bottomRelativeBorder", "top");
        } else {
            node.setAttribute("bottomRelativeObjID", parentId);
            node.setAttribute("bottomRelativeBorder", "bottom");
        }
        node.setAttribute("bottomRelativeOffset", bottom);
        return node;
    }
}

