/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.printprovider.dialogs;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.printprovider.IExSetup;
import com.kingdee.bos.ctrl.kdf.printprovider.KDPrintService;
import com.kingdee.bos.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.bos.ctrl.kdf.printprovider.PrinterNotFoundException;
import com.kingdee.bos.ctrl.kdf.printprovider.dialogs.BasicPrintSetupPaneBuilder;
import com.kingdee.bos.ctrl.kdf.printprovider.dialogs.IExSetupConfigurator;
import com.kingdee.bos.ctrl.kdf.printprovider.resources.Resources;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jdom2.Element;

public class ExSetupManager {
    private Hashtable paneClsNames = new Hashtable();
    private KDTree configTree;
    private PrinterAttrManager attrmgr;
    private BasicPrintSetupPaneBuilder panebuilder;
    private Hashtable userPanes = new Hashtable();
    Hashtable panesCache = new Hashtable();
    ArrayList userSetups = new ArrayList();
    ArrayList exSetups = new ArrayList();
    private boolean isApproved = false;

    public ExSetupManager(PrinterAttrManager attrmgr) {
        this.attrmgr = attrmgr;
    }

    public ExSetupManager(KDPrintService service, PrinterAttrManager attrmgr) {
        this.attrmgr = attrmgr;
    }

    public void addSetupPane(String title, JPanel setupPane) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)title);
        this.userPanes.put(node, setupPane);
    }

    public void addExsetup(IExSetup exSetup) {
        this.addSetupPane(exSetup.getName(), exSetup.getPanel());
        this.userSetups.add(exSetup);
        this.exConfig(exSetup);
    }

    void addExsetup2(IExSetup exSetup) {
        this.userSetups.add(exSetup);
        this.exConfig(exSetup);
    }

    public void installExConfigurator(IExSetupConfigurator configurator) {
        this.exSetups.add(configurator);
    }

    public void uninstallExConfigurator(IExSetupConfigurator configurator) {
        configurator.unconfig();
        this.exSetups.remove(configurator);
    }

    protected void exConfig(IExSetup exSetup) {
        int size = this.exSetups.size();
        for (int i = 0; i < size; ++i) {
            IExSetupConfigurator config = (IExSetupConfigurator)this.exSetups.get(i);
            if (!StringUtil.equalsIgnoreCase((String)exSetup.getName(), (String)config.getTargetName())) continue;
            config.config(exSetup);
        }
    }

    public void onApprove() {
        Iterator itr = this.userSetups.iterator();
        while (itr.hasNext()) {
            ((IExSetup)itr.next()).commit();
        }
    }

    public void clearUserPanel() {
        this.userPanes.clear();
        this.panesCache.clear();
    }

    public void preBuildTree(Element xmlnode) {
        this.paneClsNames.clear();
        DefaultKingdeeTreeNode root = this.buildTree(xmlnode);
        this.configTree = new KDTree((ITreeNode)root);
        this.configTree.setShowCheckBox(false);
    }

    private static String LOCAL_STR(String key) {
        return LanguageManager.getLangMessage((String)key, Resources.class, (String)key);
    }

    private DefaultKingdeeTreeNode buildTree(Element xmlnode) {
        String name = xmlnode.getAttribute("name").getValue();
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)ExSetupManager.LOCAL_STR(name));
        List children = xmlnode.getChildren("confNode");
        if (children != null) {
            for (Element next : children) {
                if (!next.getName().equalsIgnoreCase("confNode")) continue;
                node.add((MutableTreeNode)this.buildTree(next));
            }
        }
        if (xmlnode.getName().equalsIgnoreCase("confNode")) {
            this.paneClsNames.put(node, xmlnode.getText());
        }
        return node;
    }

    public KDTree getConfTree() {
        return this.configTree;
    }

    public void setConfTree(KDTree tree) {
        this.configTree = tree;
    }

    public String getClsNameOfNode(TreeNode tn) {
        return (String)this.paneClsNames.get(tn);
    }

    public BasicPrintSetupPaneBuilder getPanebuilder() throws PrinterNotFoundException {
        if (this.panebuilder == null) {
            this.panebuilder = new BasicPrintSetupPaneBuilder(this.attrmgr);
        }
        return this.panebuilder;
    }

    public void clearPaneBuilder() {
        if (this.panebuilder != null) {
            this.panebuilder.dispose();
        }
        this.panebuilder = null;
    }

    public PrinterAttrManager getAttrmgr() {
        return this.attrmgr;
    }

    public Hashtable getUserPanes() {
        return this.userPanes;
    }

    public IExSetup getExSetup(String name) {
        IExSetup[] es = new IExSetup[this.userSetups.size()];
        es = this.userSetups.toArray(es);
        for (int i = 0; i < es.length; ++i) {
            if (!name.equals(es[i].getName())) continue;
            return es[i];
        }
        return null;
    }

    public boolean isApproved() {
        return this.isApproved;
    }

    public void setApproved(boolean b) {
        this.isApproved = b;
    }

    public Hashtable getPanesCache() {
        return this.panesCache;
    }

    public void udpate() {
        if (this.panebuilder != null) {
            this.panebuilder.update();
        }
    }
}

