/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.read;

import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.kdf.read.Parameter;

public class Parser {
    private int _col;
    private int _row;
    private int _currentTokenLength;
    private int _currentTokenPos;
    private int _formulaLength;
    private String formula;
    private ObjectArray parameters;
    private int pos;

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public ObjectArray getParameters() {
        return this.parameters;
    }

    public void setParameters(ObjectArray parameters) {
        this.parameters = parameters;
    }

    public void parse(String formula) {
        this.init(formula);
        while (this.pos < this._formulaLength) {
            this._currentTokenPos = this.pos;
            this._currentTokenLength = 1;
            if (!this.isSheet(this.pos) && this.isCell(this.pos)) {
                this.parameters.append((Object)new Parameter(this._currentTokenPos, this._currentTokenLength, formula.substring(this._currentTokenPos, this._currentTokenPos + this._currentTokenLength)));
            }
            ++this.pos;
        }
    }

    private void init(String formula) {
        this.formula = formula;
        this._formulaLength = formula.length();
        this.parameters = new ObjectArray();
    }

    private boolean isSheet(int pos) {
        char ch = this.getChar(pos);
        if (Character.isJavaIdentifierStart(ch)) {
            while (this.isFunctionChar(this.getChar(++pos))) {
            }
            this._currentTokenLength = pos - this._currentTokenPos;
            while (Character.isWhitespace(ch = this.getChar(pos))) {
                ++pos;
            }
            if (ch == '!') {
                this.pos = pos;
                return true;
            }
        }
        return false;
    }

    private boolean isFunctionChar(char ch) {
        return false;
    }

    private final boolean isCell(int pos) {
        if ((pos = this.judgeA1Column(pos)) < 0) {
            return false;
        }
        if ((pos = this.judgeA1Row(pos)) < 0) {
            return false;
        }
        char ch = this.getChar(pos);
        if (ch != '\u0000' && (Character.isJavaIdentifierPart(ch) || ch == '!')) {
            return false;
        }
        this._currentTokenLength = pos - this._currentTokenPos;
        this.pos = pos;
        --this._row;
        --this._col;
        return true;
    }

    private int judgeA1Row(int pos) {
        char ch = this.getChar(pos);
        if (ch == '$') {
            ch = this.getChar(++pos);
        }
        this._row = 0;
        while (Character.isDigit(ch)) {
            this._row = this._row * 10 + (ch - 48);
            ch = this.getChar(++pos);
        }
        if (this._row == 0 || this._row > 0x100000) {
            return -1;
        }
        return pos;
    }

    private int judgeA1Column(int pos) {
        char ch = this.getChar(pos);
        if (ch == '$') {
            ch = this.getChar(++pos);
        }
        this._col = 0;
        while (Character.isLetter(ch)) {
            this._col = this._col * 26 + (Character.toUpperCase(ch) - 65 + 1);
            ch = this.getChar(++pos);
        }
        if (this._col == 0 || this._col > 16384) {
            return -1;
        }
        return pos;
    }

    private char getChar(int pos) {
        return pos < this._formulaLength ? this.formula.charAt(pos) : (char)'\u0000';
    }
}

