/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.server;

import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.server.FormBuilder;
import com.kingdee.bos.ctrl.kdf.server.FormContext;
import com.kingdee.bos.ctrl.kdf.server.FormPageInfo;
import com.kingdee.bos.ctrl.kdf.server.IForm;
import com.kingdee.bos.ctrl.kdf.server.IFormOutput;
import com.kingdee.bos.ctrl.kdf.server.IServerPluginParam;
import com.kingdee.bos.ctrl.kdf.server.IVariantDataListener;
import com.kingdee.bos.ctrl.kdf.server.SerialNumber;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;

class LocalFormVisitor
implements IForm,
IFormOutput {
    private transient FormPageInfo formPageInfo;
    private transient byte[] kdf;
    private transient InputStream kdfStream;
    private transient FormContext context;
    private transient int kdfID = SerialNumber.getInstance().getSerial();
    private transient IServerPluginParam[] plugins;
    private transient IVariantDataListener vdataListener;
    private transient Object userFuncObj;
    private transient HashMap reportParams;

    LocalFormVisitor() {
    }

    @Override
    public void setPageInfo(FormPageInfo info) {
        this.formPageInfo = info;
    }

    @Override
    public void setKDF(byte[] kdf) {
        this.kdf = kdf;
    }

    @Override
    public void setKDF(InputStream kdf) {
        this.kdfStream = kdf;
    }

    @Override
    public void makeForm() {
        this.context = FormContext.getInstance(this.kdfID);
        KDFXmlReader reader = this.kdfStream != null ? new KDFXmlReader(this.kdfStream) : new KDFXmlReader(new ByteArrayInputStream(this.kdf));
        FormBuilder formBuilder = new FormBuilder(this.kdfID);
        formBuilder.setCallBack(this);
        formBuilder.setVariantDataListener(this.vdataListener);
        formBuilder.setUserFunctionProvider(this.userFuncObj);
        formBuilder.setReportParams(this.reportParams);
        Object[] rt = formBuilder.prepareForm(reader, this.plugins);
        if (rt != null && this.plugins != null) {
            for (int i = 0; i < rt.length; ++i) {
                if (this.plugins[i] == null) continue;
                this.plugins[i].notify(rt[i]);
            }
        }
        formBuilder.makeForm(this.formPageInfo, reader, this.plugins);
        FormContext.close(this.context.getID());
    }

    @Override
    public void endOutput() {
        if (this.context != null) {
            this.context.endFormOutput();
        }
    }

    @Override
    public void obtainPage(int pageIndex, Page page) {
        if (this.context != null) {
            this.context.obtainNewPage(pageIndex, page);
        }
    }

    @Override
    public int getKDFID() {
        return this.kdfID;
    }

    @Override
    public void setPlugins(IServerPluginParam[] plugins) {
        this.plugins = plugins;
    }

    @Override
    public void cancelJob(Thread worker) {
        if (worker != null) {
            worker.interrupt();
        }
    }

    @Override
    public void setVariantDataListener(IVariantDataListener listener) {
        this.vdataListener = listener;
    }

    @Override
    public void setReportParams(HashMap params) {
        this.reportParams = params;
    }

    @Override
    public void setUserFunctionProvider(Object obj) {
        this.userFuncObj = obj;
    }
}

