/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.file;

import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlException;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;
import org.xml.sax.InputSource;

public class KDFXmlReader {
    public static final Namespace NS_COMMON = Namespace.getNamespace((String)"c", (String)"http://www.kingdee.com/Common");
    public static final Namespace NS_TABLE = Namespace.getNamespace((String)"t", (String)"http://www.kingdee.com/Table");
    public static final Namespace NS_FORM = Namespace.getNamespace((String)"f", (String)"http://www.kingdee.com/Form");
    public static final String SAX_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected InputSource source;
    protected Document doc;
    protected Element root;
    protected String encode;
    protected HashMap styleNodeBuf;

    protected KDFXmlReader() {
        String strTime = new Date().toString();
        String initSource = "<?xml version=\"1.0\" encoding=\"UNICODE\"?><DocRoot xmlns:c=\"http://www.kingdee.com/Common\" xmlns:f=\"http://www.kingdee.com/Form\" xmlns:t=\"http://www.kingdee.com/Table\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" version=\"0.0\"><DocInfo><c:Author>null</c:Author><c:Created>" + strTime + "</c:Created><c:Company>kingdee.com</c:Company><c:LastModified>" + strTime + "</c:LastModified></DocInfo><DataSources/><DataObjects/><Styles/></DocRoot>";
        this.source = new InputSource(new StringReader(initSource));
    }

    public KDFXmlReader(InputStream byteStream) {
        this.source = new InputSource(byteStream);
        this.bufStyleNodes();
    }

    public KDFXmlReader(Reader charStream) {
        this.source = new InputSource(charStream);
        this.bufStyleNodes();
    }

    public KDFXmlReader(String fileName) throws KDFXmlException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            this.source = new InputSource(fis);
        }
        catch (FileNotFoundException err) {
            try {
                throw new KDFXmlException("File [" + fileName + "] loading failed", err, fileName);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
        this.bufStyleNodes();
    }

    public final Document getDoc() {
        if (this.doc != null) {
            return this.doc;
        }
        try {
            SAXBuilder builder = new SAXBuilder(SAX_PARSER_NAME, false);
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(JDOMFactory.class.getClassLoader());
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                this.doc = builder.build(this.source);
            }
            catch (JDOMException je) {
                throw je;
            }
            finally {
                try {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
                catch (SecurityException securityException) {}
            }
        }
        catch (JDOMException err) {
            throw new AssertionError((Object)("Error on analysis XML file, info: " + err.getMessage()));
        }
        catch (IOException err) {
            throw new AssertionError((Object)"Failed loading file");
        }
        return this.doc;
    }

    public final Element getRoot() {
        if (this.root == null) {
            this.root = this.getDoc().getRootElement();
        }
        return this.root;
    }

    public final Element getDocInfoNode() {
        Element nodeDocInfo = this.getRoot().getChild("DocInfo", this.getRoot().getNamespace());
        if (null == nodeDocInfo) {
            nodeDocInfo = new Element("DocInfo", this.getRoot().getNamespace());
            this.getRoot().addContent((Content)nodeDocInfo);
        }
        return nodeDocInfo;
    }

    public final String getVersion() {
        return this.getRoot().getAttributeValue("version");
    }

    public final String[] getAuthors() {
        Element docInfoNode = this.getDocInfoNode();
        List listAuthors = docInfoNode.getChildren("Author", NS_COMMON);
        if (null == listAuthors || listAuthors.size() < 1) {
            return new String[0];
        }
        String[] authors = new String[listAuthors.size()];
        for (int i = 0; i < authors.length; ++i) {
            authors[i] = ((Element)listAuthors.get(i)).getTextTrim();
        }
        return authors;
    }

    public final String getCompany() {
        Element docInfoNode = this.getDocInfoNode();
        return docInfoNode.getChildText("Company", NS_COMMON);
    }

    public final String getCreatedTime() {
        Element docInfoNode = this.getDocInfoNode();
        return docInfoNode.getChildTextNormalize("Created", NS_COMMON);
    }

    public final String getLastModified() {
        Element docInfoNode = this.getDocInfoNode();
        return docInfoNode.getChildText("LastModified", NS_COMMON);
    }

    public final Element getDBConnectionsNode() {
        Element nodeDBS = this.getRoot().getChild("DBConnections", this.getRoot().getNamespace());
        if (null == nodeDBS) {
            nodeDBS = new Element("DBConnections", this.getRoot().getNamespace());
            this.getRoot().addContent((Content)nodeDBS);
        }
        return nodeDBS;
    }

    public final List getDBConnectionNodes() {
        return this.getDBConnectionsNode().getChildren();
    }

    public final Element getDataSourcesNode() {
        Element nodeDS = this.getRoot().getChild("DataSources", this.getRoot().getNamespace());
        if (null == nodeDS) {
            nodeDS = new Element("DataSources", this.getRoot().getNamespace());
            this.getRoot().addContent((Content)nodeDS);
        }
        return nodeDS;
    }

    public final List getDataSourceNodes() {
        return this.getDataSourcesNode().getChildren();
    }

    public final Element getStylesNode() {
        Element nodeStyles = this.getRoot().getChild("Styles", this.getRoot().getNamespace());
        if (null == nodeStyles) {
            nodeStyles = new Element("Styles", this.getRoot().getNamespace());
            this.getRoot().addContent((Content)nodeStyles);
        }
        return nodeStyles;
    }

    public final List getStyleNodes() {
        return this.getStylesNode().getChildren();
    }

    public final Element getParamsNode() {
        Element nodeParams = this.getRoot().getChild("Params", this.getRoot().getNamespace());
        if (null == nodeParams) {
            nodeParams = new Element("Params", this.getRoot().getNamespace());
            this.getRoot().addContent((Content)nodeParams);
        }
        return nodeParams;
    }

    public final List getParamNodes() {
        return this.getParamsNode().getChildren();
    }

    public final Element getPageSetupNode() {
        return this.getPrintInfoNode().getChild("PageSetup", NS_COMMON);
    }

    public final Element getPrintInfoNode() {
        Element nodePrinter = this.getRoot().getChild("PrintInfo", this.getRoot().getNamespace());
        if (null == nodePrinter) {
            nodePrinter = new Element("PrintInfo", this.getRoot().getNamespace());
            this.getRoot().addContent((Content)nodePrinter);
        }
        return nodePrinter;
    }

    public final Element getHeadersNode() {
        Element nodeHeaders = this.getRoot().getChild("Headers", this.getRoot().getNamespace());
        if (null == nodeHeaders) {
            nodeHeaders = new Element("Headers", this.getRoot().getNamespace());
            this.getRoot().addContent((Content)nodeHeaders);
        }
        return nodeHeaders;
    }

    public final List getHeaderNodes() {
        return this.getHeadersNode().getChildren();
    }

    public final Element getFootersNode() {
        Element nodeFooters = this.getRoot().getChild("Footers", this.getRoot().getNamespace());
        if (null == nodeFooters) {
            nodeFooters = new Element("Footers", this.getRoot().getNamespace());
            this.getRoot().addContent((Content)nodeFooters);
        }
        return nodeFooters;
    }

    public final List getFooterNodes() {
        return this.getFootersNode().getChildren();
    }

    public final List getFormNodes() {
        return this.getRoot().getChildren("Form", this.getRoot().getNamespace());
    }

    public final Element getFormNodeByID(String id) {
        Element formNode = null;
        try {
            String xpath = "//Form[@id=\"" + id + "\"]";
            XPath formPath = XPath.newInstance((String)xpath);
            formNode = (Element)formPath.selectSingleNode((Object)this.getRoot());
        }
        catch (JDOMException err) {
            err.printStackTrace();
        }
        return formNode;
    }

    public final List getTableNodes() {
        return this.getRoot().getChildren("Table", this.getRoot().getNamespace());
    }

    public final Element getTableNodeByID(String id) {
        Element tableNode = null;
        try {
            String xpath = "//Table[@id=\"" + id + "\"]";
            XPath tablePath = XPath.newInstance((String)xpath);
            tableNode = (Element)tablePath.selectSingleNode((Object)this.getRoot());
        }
        catch (JDOMException err) {
            err.printStackTrace();
        }
        return tableNode;
    }

    public final Element getStyleNodeByID(String id) {
        return (Element)this.styleNodeBuf.get(id);
    }

    private final void bufStyleNodes() {
        StyleParser.upgrade((Element)this.getRoot().getChild("Styles", this.getRoot().getNamespace()));
        this.styleNodeBuf = new HashMap();
        List listStyleNodes = this.getStyleNodes();
        for (Element node : listStyleNodes) {
            String strID = node.getAttributeValue("id");
            this.styleNodeBuf.put(strID, node);
        }
    }

    public final HashMap getStyleNodeBuf() {
        return this.styleNodeBuf;
    }

    public final Element getNodeByPath(String xpath) throws KDFException {
        Element node;
        try {
            XPath nodePath = XPath.newInstance((String)xpath);
            node = (Element)nodePath.selectSingleNode((Object)this.getRoot());
        }
        catch (JDOMException err) {
            throw new KDFException("Error on find XPATH [" + xpath + "]: " + err.getMessage());
        }
        catch (Exception err) {
            throw new KDFException("Abnormal error: " + err.getMessage());
        }
        return node;
    }

    public static final String readNodeSource(Element node) {
        if (null == node) {
            return "";
        }
        XMLOutputter outter = new XMLOutputter();
        return outter.outputString(node);
    }

    public static final String readNodeContentSource(Element node) {
        if (null == node) {
            return "";
        }
        XMLOutputter outter = new XMLOutputter();
        return outter.outputString(node.getContent());
    }

    public Element getUserObjectsNode() {
        return this.getRoot().getChild("UserObjects", this.getRoot().getNamespace());
    }

    public final Element getDataObjectsNode() {
        Element node = this.getRoot().getChild("DataObjects", this.getRoot().getNamespace());
        if (null == node) {
            node = new Element("DataObjects", this.getRoot().getNamespace());
            this.getRoot().addContent((Content)node);
        }
        return node;
    }

    public final List getDataObjectNodes() {
        return this.getDataObjectsNode().getChildren();
    }

    public Element getElement(String name) {
        return this.getRoot().getChild(name, this.getRoot().getNamespace());
    }
}

