/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.print;

import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.bos.ctrl.kdf.util.print.BasicGridPageArea;
import com.kingdee.bos.ctrl.kdf.util.print.IAreaPainter;
import com.kingdee.bos.ctrl.kdf.util.print.IContentBlock;
import com.kingdee.bos.ctrl.kdf.util.print.IContentGrid;
import com.kingdee.bos.ctrl.kdf.util.print.IGridPageArea;
import com.kingdee.bos.ctrl.kdf.util.print.IPageArea;
import com.kingdee.bos.ctrl.kdf.util.render.BorderRenderW;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Border;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class BasicGridAreaPainter
implements IAreaPainter {
    public static final int GRID_LINE_WIDTH = 1;
    public static final int CELL_HORIZON_MARGIN = 3;
    public static final int CELL_VERTICAL_MARGIN = 0;
    public static final String ERR_MSG_ARGUMENT = "A BasicGridAreaPainter object can't paint other types' page area.";
    protected IBasicRender render;
    protected BorderRenderW borderRender;
    protected Graphics2D g2d;
    private Line2D.Double line = new Line2D.Double();
    private int sectTop;
    private int sectBottom;
    private int sectLeft;
    private int sectRight;
    private StyleAttributes bordersa = Styles.getEmptySA();

    public BasicGridAreaPainter() {
    }

    public BasicGridAreaPainter(Graphics g) {
        this.g2d = (Graphics2D)g;
    }

    @Override
    public void paintPageArea(IPageArea page, Graphics g, Shape clipArea) {
        if (!(page instanceof IGridPageArea)) {
            throw new IllegalArgumentException(ERR_MSG_ARGUMENT);
        }
        this.paintPageArea((IGridPageArea)page, g, clipArea);
    }

    void paintPageArea(IGridPageArea area, Graphics g, Shape clip) {
        this.g2d = (Graphics2D)g;
        this.paintPageArea(area, clip);
    }

    void paintPageArea(IGridPageArea area, Shape clip) {
        BasicGridPageArea.PageSect sect;
        IContentGrid grid;
        if (area.getArea().getWidth() <= 0.0 || area.getArea().getHeight() <= 0.0) {
            return;
        }
        assert (this.g2d != null);
        if (clip == null) {
            clip = new Rectangle2D.Double(0.0, 0.0, 2.147483647E9, 2.147483647E9);
        }
        if (!(clip instanceof Rectangle2D)) {
            throw new IllegalArgumentException("\u6682\u672a\u652f\u6301\u9664\u77e9\u5f62\u4e4b\u5916\u7684\u53ef\u7ed8\u5236\u533a\u57df");
        }
        int ox = (int)Math.ceil(area.getArea().getMinX());
        int oy = (int)Math.ceil(area.getArea().getMinY());
        int nx = ox;
        int ny = oy;
        Iterator iter = area.getSects().iterator();
        while (iter.hasNext() && (grid = (sect = (BasicGridPageArea.PageSect)iter.next()).getGrid()) != null) {
            this.sectTop = sect.getTop();
            this.sectBottom = sect.getBottom();
            this.sectLeft = sect.getLeft();
            this.sectRight = sect.getRight();
            int[] xps = new int[this.sectRight - this.sectLeft + 1];
            int[] yps = new int[this.sectBottom - this.sectTop + 1];
            int xPos = nx;
            int yPos = ny;
            xps[0] = xPos;
            yps[0] = yPos;
            for (int j = this.sectLeft; j < this.sectRight; ++j) {
                xps[j - this.sectLeft + 1] = xPos += grid.getColumnWidth(j);
            }
            for (int i = this.sectTop; i < this.sectBottom; ++i) {
                yps[i - this.sectTop + 1] = yPos += grid.getRowHeight(i);
            }
            Shape oldClip = this.g2d.getClip();
            this.g2d.setClip(xps[0], yps[0], xPos - nx + 1, yPos - ny + 1);
            for (int i = this.sectTop; i < this.sectBottom; ++i) {
                for (int j = this.sectLeft; j < this.sectRight; ++j) {
                    IContentBlock block = grid.getMergeBlock(i, j);
                    if (block == null) {
                        double pxCellWidth = xps[j - this.sectLeft + 1] - xps[j - this.sectLeft];
                        double pxCellHeight = yps[i - this.sectTop + 1] - yps[i - this.sectTop];
                        Rectangle2D.Double rectCell = new Rectangle2D.Double(xps[j - this.sectLeft], yps[i - this.sectTop], pxCellWidth, pxCellHeight);
                        this.paintCellContent(rectCell, sect, i, j);
                        continue;
                    }
                    this.paintMerge(sect, block, i, j, xps, yps);
                }
            }
            this.paintBorders(xps, yps, sect);
            if (grid.isGridLineVisible()) {
                Rectangle rect = new Rectangle();
                rect.x = xps[0];
                rect.y = yps[0];
                rect.width = xps[this.sectRight - this.sectLeft];
                rect.height = yps[this.sectBottom - this.sectTop];
                Color oldColor = this.g2d.getColor();
                this.g2d.setColor(grid.getGridLine(Styles.Position.RIGHT).getColor());
                this.g2d.drawLine(rect.x, rect.y, rect.width, rect.y);
                this.g2d.drawLine(rect.x, rect.y, rect.x, rect.height);
                this.g2d.setColor(oldColor);
            }
            this.g2d.setClip(oldClip);
            if (area.getSectsAlign() == 0) {
                ny = yps[yps.length - 1] + area.getSectSpace();
                continue;
            }
            if (area.getSectsAlign() != 1) continue;
            nx = xPos;
        }
    }

    protected void paintMerge(BasicGridPageArea.PageSect pb, IContentBlock block, int row, int col, int[] xes, int[] yes) {
        IContentGrid grid = pb.getGrid();
        Rectangle rOuter = new Rectangle();
        int top = block.getTop() < this.sectTop ? this.sectTop : block.getTop();
        int left = block.getLeft() < this.sectLeft ? this.sectLeft : block.getLeft();
        int bottom = block.getBottom();
        int right = block.getRight();
        if (left == col && top == row) {
            rOuter.y = this.getRowsHeight(grid, block.getTop(), row);
            rOuter.x = this.getColumnsWidth(grid, block.getLeft(), col);
            rOuter.height = rOuter.y + this.getRowsHeight(grid, row, bottom);
            rOuter.width = rOuter.x + this.getColumnsWidth(grid, col, right);
            rOuter.y = yes[row - this.sectTop] - rOuter.y;
            rOuter.x = xes[col - this.sectLeft] - rOuter.x;
            this.paintCellContent(rOuter, pb, block.getTop(), block.getLeft());
        }
    }

    protected boolean isFirstCellOfBlockInPage(IContentBlock block, BasicGridPageArea.PageSect sect, int row, int col) {
        if (!block.contains(row, col)) {
            return false;
        }
        return !(col != sect.getLeft() && col != block.getLeft() || row != sect.getTop() && row != block.getTop());
    }

    protected int getBlockHeight(IContentBlock block, IContentGrid grid) {
        int lastRow = block.getBottom() - 1;
        int size = 0;
        for (int i = block.getTop(); i <= lastRow; ++i) {
            size += grid.getRowHeight(i);
        }
        return size;
    }

    protected int getBlockWidth(IContentBlock block, IContentGrid grid) {
        return this.getColumnsWidth(grid, block.getLeft(), block.getRight());
    }

    protected int getColumnsWidth(IContentGrid grid, int beginCol, int endCol) {
        if (beginCol < 0) {
            beginCol = 0;
        }
        if (endCol > grid.getColumnCount()) {
            endCol = grid.getColumnCount();
        }
        int size = 0;
        for (int i = beginCol; i < endCol; ++i) {
            size += grid.getColumnWidth(i);
        }
        return size;
    }

    protected int getRowsHeight(IContentGrid grid, int beginRow, int endRow) {
        if (beginRow < 0) {
            beginRow = 0;
        }
        if (endRow > grid.getRowCount()) {
            endRow = grid.getRowCount();
        }
        int size = 0;
        for (int i = beginRow; i < endRow; ++i) {
            size += grid.getRowHeight(i);
        }
        return size;
    }

    protected void paintBorders(int[] xps, int[] yps, BasicGridPageArea.PageSect sect) {
        for (int i = this.sectTop; i < this.sectBottom; ++i) {
            for (int j = this.sectLeft; j < this.sectRight; ++j) {
                Rectangle2D.Double rectCell = new Rectangle2D.Double(xps[j - this.sectLeft], yps[i - this.sectTop], xps[j - this.sectLeft + 1] - xps[j - this.sectLeft], yps[i - this.sectTop + 1] - yps[i - this.sectTop]);
                this.paintCellBorder(rectCell, sect, i, j);
            }
        }
    }

    protected void paintCellBorder(Rectangle2D rectCell, BasicGridPageArea.PageSect sect, int row, int col) {
        if (!sect.getGrid().isCellExist(row, col)) {
            return;
        }
        Style style = sect.getGrid().getCellStyle(row, col);
        if (style == null) {
            return;
        }
        this.getBorderRender().setLeftActive(this.isLeftSide(sect, col) || this.leftCellIsNull(sect, row, col));
        this.getBorderRender().setTopActive(this.isTopSide(sect, row) || this.topCellIsNull(sect, row, col));
        this.bordersa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.NULL_LINE);
        this.bordersa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.NULL_LINE);
        this.bordersa.setBorderLineStyle(Styles.Position.TOP, LineStyle.NULL_LINE);
        this.bordersa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.NULL_LINE);
        this.bordersa.setBorderLineStyle(Styles.Position.DIAGONALLEFT, LineStyle.NULL_LINE);
        this.bordersa.setBorderLineStyle(Styles.Position.DIAGONALRIGHT, LineStyle.NULL_LINE);
        Border border = this.getLeftBorder(style, sect, row, col);
        if (border != null) {
            this.bordersa.setBorderPenStyle(Styles.Position.LEFT, border.getPenStyle());
            this.bordersa.setBorderColor(Styles.Position.LEFT, border.getColor());
            this.bordersa.setBorderLineStyle(Styles.Position.LEFT, border.getLineStyle());
        }
        if ((border = this.getRightBorder(style, sect, row, col)) != null) {
            this.bordersa.setBorderPenStyle(Styles.Position.RIGHT, border.getPenStyle());
            this.bordersa.setBorderColor(Styles.Position.RIGHT, border.getColor());
            this.bordersa.setBorderLineStyle(Styles.Position.RIGHT, border.getLineStyle());
        }
        if ((border = this.getTopBorder(style, sect, row, col)) != null) {
            this.bordersa.setBorderPenStyle(Styles.Position.TOP, border.getPenStyle());
            this.bordersa.setBorderColor(Styles.Position.TOP, border.getColor());
            this.bordersa.setBorderLineStyle(Styles.Position.TOP, border.getLineStyle());
        }
        if ((border = this.getBottomBorder(style, sect, row, col)) != null) {
            this.bordersa.setBorderPenStyle(Styles.Position.BOTTOM, border.getPenStyle());
            this.bordersa.setBorderColor(Styles.Position.BOTTOM, border.getColor());
            this.bordersa.setBorderLineStyle(Styles.Position.BOTTOM, border.getLineStyle());
        }
        this.getBorderRender().draw((Graphics)this.g2d, rectCell, this.bordersa);
    }

    protected Border getTopBorder(Style thisStyle, BasicGridPageArea.PageSect sect, int row, int col) {
        IContentBlock block = sect.getGrid().getMergeBlock(row, col);
        if (block != null) {
            if (this.isTopSide(sect, col) && this.isMergeTopSide(block, row, col)) {
                Border border = sect.getGrid().getCellStyle(row, col).getBorder(Styles.Position.TOP);
                return border.isNull() ? null : border;
            }
            return null;
        }
        if (this.isTopSide(sect, row)) {
            Border border = thisStyle.getBorder(Styles.Position.TOP);
            return border.isNull() ? null : border;
        }
        return this.getBottomBorder(sect.getGrid().getCellStyle(row - 1, col), sect, row - 1, col);
    }

    protected boolean isMergeTopSide(IContentBlock block, int row, int col) {
        if (col < block.getLeft() || col >= block.getRight()) {
            return false;
        }
        return row == block.getTop();
    }

    protected Border getBottomBorder(Style thisStyle, BasicGridPageArea.PageSect sect, int row, int col) {
        IContentGrid grid = sect.getGrid();
        IContentBlock block = grid.getMergeBlock(row, col);
        Border border = null;
        if (block != null) {
            if (this.isMergeBottomSide(block, row, col)) {
                if (grid.isCellExist(row + 1, col) && (border = grid.getCellStyle(row + 1, col).getBorder(Styles.Position.TOP)).isNull()) {
                    border = null;
                }
                if (null == border || this.isBottomSide(sect, row)) {
                    if (grid.isCellExist(block.getTop(), block.getLeft())) {
                        border = grid.getCellStyle(block.getTop(), block.getLeft()).getBorder(Styles.Position.BOTTOM);
                        if (border.isNull()) {
                            border = null;
                        }
                    } else {
                        border = null;
                    }
                    if (null == border && (border = thisStyle.getBorder(Styles.Position.BOTTOM)).isNull()) {
                        border = null;
                    }
                    if ((null == border || border.isNull()) && grid.isGridLineVisible()) {
                        border = grid.getGridLine(Styles.Position.BOTTOM);
                    }
                }
            }
        } else {
            border = thisStyle.getBorder(Styles.Position.BOTTOM);
            if (border.isNull() && !this.isBottomSide(sect, row)) {
                IContentBlock blockNext = grid.getMergeBlock(row + 1, col);
                if (blockNext == null) {
                    if (grid.isCellExist(row + 1, col) && (border = grid.getCellStyle(row + 1, col).getBorder(Styles.Position.TOP)).isNull()) {
                        border = null;
                    }
                } else {
                    border = grid.getCellStyle(blockNext.getTop(), blockNext.getLeft()).getBorder(Styles.Position.TOP);
                    if (border.isNull()) {
                        border = null;
                    }
                }
            }
            if ((null == border || border.isNull()) && grid.isGridLineVisible()) {
                border = grid.getGridLine(Styles.Position.BOTTOM);
            }
        }
        return border;
    }

    protected Border getLeftBorder(Style style, BasicGridPageArea.PageSect sect, int row, int col) {
        IContentBlock block = sect.getGrid().getMergeBlock(row, col);
        if (block != null) {
            if (this.isLeftSide(sect, col) && this.isMergeLeftSide(block, row, col)) {
                Border border = sect.getGrid().getCellStyle(row, col).getBorder(Styles.Position.LEFT);
                return border.isNull() ? null : border;
            }
            return null;
        }
        if (this.isLeftSide(sect, col)) {
            Border border = style.getBorder(Styles.Position.LEFT);
            return border.isNull() ? null : border;
        }
        return this.getRightBorder(sect.getGrid().getCellStyle(row, col - 1), sect, row, col - 1);
    }

    protected Border getRightBorder(Style thisStyle, BasicGridPageArea.PageSect sect, int row, int col) {
        IContentGrid grid = sect.getGrid();
        IContentBlock block = grid.getMergeBlock(row, col);
        Border border = null;
        if (block != null) {
            if (this.isMergeRightSide(block, row, col)) {
                if (grid.isCellExist(row, col + 1) && (border = grid.getCellStyle(row, col + 1).getBorder(Styles.Position.LEFT)).isNull()) {
                    border = null;
                }
                if (null == border || this.isRightSide(sect, col)) {
                    if (grid.isCellExist(block.getTop(), block.getLeft())) {
                        border = grid.getCellStyle(block.getTop(), block.getLeft()).getBorder(Styles.Position.RIGHT);
                        if (border.isNull()) {
                            border = null;
                        }
                    } else {
                        border = null;
                    }
                    if (null == border && (border = thisStyle.getBorder(Styles.Position.RIGHT)).isNull()) {
                        border = null;
                    }
                    if ((null == border || border.isNull()) && grid.isGridLineVisible()) {
                        border = grid.getGridLine(Styles.Position.RIGHT);
                    }
                }
            }
        } else {
            border = thisStyle.getBorder(Styles.Position.RIGHT);
            if (border.isNull() && !this.isRightSide(sect, col)) {
                IContentBlock blockNext = grid.getMergeBlock(row, col + 1);
                if (blockNext == null) {
                    if (grid.isCellExist(row, col + 1) && (border = grid.getCellStyle(row, col + 1).getBorder(Styles.Position.LEFT)).isNull()) {
                        border = null;
                    }
                } else {
                    border = grid.getCellStyle(blockNext.getTop(), blockNext.getLeft()).getBorder(Styles.Position.LEFT);
                    if (border.isNull()) {
                        border = null;
                    }
                }
            }
            if ((null == border || border.isNull()) && grid.isGridLineVisible()) {
                border = grid.getGridLine(Styles.Position.RIGHT);
            }
        }
        return border;
    }

    protected boolean isMergeRightSide(IContentBlock block, int row, int col) {
        if (row < block.getTop() || row >= block.getBottom()) {
            return false;
        }
        return col == block.getRight() - 1;
    }

    protected boolean isMergeLeftSide(IContentBlock block, int row, int col) {
        if (row < block.getTop() || row >= block.getBottom()) {
            return false;
        }
        return col == block.getLeft();
    }

    protected boolean isMergeBottomSide(IContentBlock block, int row, int col) {
        if (col < block.getLeft() || col >= block.getRight()) {
            return false;
        }
        return row == block.getBottom() - 1;
    }

    protected boolean isLeftSide(BasicGridPageArea.PageSect sect, int col) {
        return sect.getLeft() == col;
    }

    protected boolean isRightSide(BasicGridPageArea.PageSect sect, int col) {
        return sect.getRight() == col + 1;
    }

    protected boolean leftCellIsNull(BasicGridPageArea.PageSect sect, int row, int col) {
        return !sect.getGrid().isCellExist(row, col - 1);
    }

    protected boolean topCellIsNull(BasicGridPageArea.PageSect sect, int row, int col) {
        return !sect.getGrid().isCellExist(row - 1, col);
    }

    protected boolean isTopSide(BasicGridPageArea.PageSect sect, int row) {
        return sect.getTop() == row;
    }

    protected boolean isBottomSide(BasicGridPageArea.PageSect sect, int row) {
        return sect.getBottom() == row + 1;
    }

    protected void paintCellContent(Rectangle2D rectCell, BasicGridPageArea.PageSect sect, int row, int col) {
        if (!sect.getGrid().isCellExist(row, col)) {
            return;
        }
        Style style = sect.getGrid().getCellStyle(row, col);
        double nx = rectCell.getMinX();
        double ny = rectCell.getMinY();
        double pxCellWidth = rectCell.getWidth();
        double pxCellHeight = rectCell.getHeight();
        if (pxCellWidth <= 0.0 || pxCellHeight <= 0.0) {
            return;
        }
        if (style != null) {
            this.fillInteriorRect(style, rectCell);
        }
        Rectangle2D.Double rectClip = new Rectangle2D.Double(nx + 3.0, ny + 0.0, pxCellWidth - 6.0, pxCellHeight - 0.0);
        if (rectClip.width > 0.0 && rectClip.height > 0.0) {
            this.paintText(sect.getGrid(), row, col, rectClip, style);
        }
    }

    protected void drawCellBorder(Graphics2D g, Rectangle2D rect, Style style, IContentGrid grid) {
        this.drawTopBorder(g, rect, style, grid);
        this.drawLeftBorder(g, rect, style, grid);
        this.drawBottomBorder(g, rect, style, grid);
        this.drawRightBorder(g, rect, style, grid);
    }

    protected void drawTopBorder(Graphics2D g, Rectangle2D rect, Style style, IContentGrid grid) {
        if (style.isNullBorder(Styles.Position.TOP)) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        double left = rect.getMinX();
        double top = rect.getMinY() - 1.0;
        double right = rect.getMinX() + rect.getWidth() - 1.0;
        this.line.setLine(left, top, right, top);
        g.setColor(style.getBorderColor(Styles.Position.TOP));
        g.setStroke(style.getStroke(Styles.Position.TOP));
        g.draw(this.line);
        g.setStroke(oldStroke);
    }

    protected void drawLeftBorder(Graphics2D g, Rectangle2D rect, Style style, IContentGrid grid) {
        if (style.isNullBorder(Styles.Position.LEFT)) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        double top = rect.getMinY();
        double bottom = rect.getMinY() + rect.getHeight() - 1.0;
        double left = rect.getMinX() - 1.0;
        this.line.setLine(left, top, left, bottom);
        g.setColor(style.getBorderColor(Styles.Position.LEFT));
        g.setStroke(style.getStroke(Styles.Position.LEFT));
        g.draw(this.line);
        g.setStroke(oldStroke);
    }

    protected void drawBottomBorder(Graphics2D g, Rectangle2D rect, Style style, IContentGrid grid) {
        if (style.isNullBorder(Styles.Position.BOTTOM)) {
            if (grid.isGridLineVisible()) {
                double left = rect.getMinX();
                double top = rect.getMinY() + rect.getHeight() - 1.0;
                double right = rect.getMinX() + rect.getWidth() - 1.0;
                this.line.setLine(left, top, right, top);
                g.setColor(grid.getGridLineColor());
                g.draw(this.line);
            }
            return;
        }
        Stroke oldStroke = g.getStroke();
        int weight = style.getBorderLineStyle(Styles.Position.BOTTOM).getWidth();
        if (weight > 1) {
            --weight;
        }
        double left = rect.getMinX();
        double top = rect.getMinY() + rect.getHeight() - (double)weight;
        double right = rect.getMinX() + rect.getWidth() - 1.0;
        this.line.setLine(left, top, right, top);
        g.setColor(style.getBorderColor(Styles.Position.BOTTOM));
        g.setStroke(style.getStroke(Styles.Position.BOTTOM));
        g.draw(this.line);
        g.setStroke(oldStroke);
    }

    protected void drawRightBorder(Graphics2D g, Rectangle2D rect, Style style, IContentGrid grid) {
        if (style.isNullBorder(Styles.Position.RIGHT)) {
            if (grid.isGridLineVisible()) {
                double top = rect.getMinY();
                double bottom = rect.getMinY() + rect.getHeight() - 1.0;
                double left = rect.getMinX() + rect.getHeight() - 1.0;
                this.line.setLine(left, top, left, bottom);
                g.setColor(grid.getGridLineColor());
                g.draw(this.line);
            }
            return;
        }
        Stroke oldStroke = g.getStroke();
        int weight = style.getBorderLineStyle(Styles.Position.RIGHT).getWidth();
        if (weight > 1) {
            --weight;
        }
        double top = rect.getMinY();
        double bottom = rect.getMinY() + rect.getHeight() - 1.0;
        double left = rect.getMinX() + rect.getHeight() - (double)weight;
        this.line.setLine(left, top, left, bottom);
        g.setColor(style.getBorderColor(Styles.Position.RIGHT));
        g.setStroke(style.getStroke(Styles.Position.RIGHT));
        g.draw(this.line);
        g.setStroke(oldStroke);
    }

    protected void fillInteriorRect(Style cellStyle, Rectangle2D rect) {
        Paint paintSave = this.g2d.getPaint();
        this.g2d.setPaint(cellStyle.getFillPaint());
        this.g2d.fill(rect);
        this.g2d.setPaint(paintSave);
    }

    protected void paintText(IContentGrid grid, int row, int col, Rectangle2D clip, Style style) {
        AffineTransform atSave = this.g2d.getTransform();
        String text = String.valueOf(grid.getCellValue(row, col));
        if (!StringUtil.isEmptyString((String)text)) {
            if ("GBK".equalsIgnoreCase(PrinterAttrManager.textCoding)) {
                text = STConverter.tc2sc((String)text);
            } else if ("BIG5".equalsIgnoreCase(PrinterAttrManager.textCoding)) {
                text = STConverter.sc2tc((String)text);
            }
        }
        this.getRender().draw((Graphics)this.g2d, (Shape)clip, (Object)text, style);
        this.g2d.setTransform(atSave);
    }

    public IBasicRender getRender() {
        if (null == this.render) {
            this.render = new CellTextRender();
        }
        return this.render;
    }

    public BorderRenderW getBorderRender() {
        if (this.borderRender == null) {
            this.borderRender = new BorderRenderW((Graphics)this.g2d);
        }
        return this.borderRender;
    }
}

