/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.printout;

import com.kingdee.bos.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.Tools;
import com.kingdee.bos.ctrl.kdf.util.print.BasicGridMergeBlock;
import com.kingdee.bos.ctrl.kdf.util.print.IContentBlock;
import com.kingdee.bos.ctrl.kdf.util.print.IContentGrid;
import com.kingdee.bos.ctrl.kdf.util.style.Border;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;

public class KDSSheetAdapter
implements IContentGrid {
    protected KDSSheet sheet;

    public KDSSheetAdapter(KDSSheet sheet) {
        if (sheet == null) {
            throw new IllegalArgumentException("Cannot construct an adapter for a null sheet");
        }
        this.sheet = sheet;
    }

    @Override
    public int getRowCount() {
        return this.sheet.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.sheet.getColumnCount();
    }

    @Override
    public int getRowHeight(int rowIndex) {
        return (int)Math.floor(Tools.mmToPx((double)this.sheet.getRowHeight(rowIndex)));
    }

    @Override
    public int getColumnWidth(int colIndex) {
        return (int)Math.floor(Tools.mmToPx((double)this.getColumnWidth(colIndex)));
    }

    @Override
    public Object getCellValue(int rowIndex, int colIndex) {
        return this.sheet.getCell(rowIndex, colIndex, false).getValue();
    }

    @Override
    public Style getCellStyle(int rowIndex, int colIndex) {
        return this.sheet.getCell(rowIndex, colIndex, false).getStyle();
    }

    @Override
    public StyleAttributes getCellStyleAttributes(int rowIndex, int colIndex) {
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)this.sheet.getCellShareStyleAttributes(rowIndex, colIndex));
        sa.append((ShareStyleAttributes)this.getCellStyle(rowIndex, colIndex), false);
        return sa;
    }

    @Override
    public IContentBlock getMergeBlock(int rowIndex, int colIndex) {
        BasicGridMergeBlock block = null;
        KDSMergeBlock merge = this.sheet.getMerges().getMergeBlock(rowIndex, colIndex);
        if (merge.equals(KDSMergeBlock.NULL_MERGE)) {
            return null;
        }
        block = new BasicGridMergeBlock();
        block.setTop(merge.row);
        block.setLeft(merge.col);
        block.setRight(merge.getCol2() + 1);
        block.setBottom(merge.getRow2() + 1);
        return block;
    }

    @Override
    public boolean isPageBreakColumn(int colIndex) {
        return false;
    }

    @Override
    public boolean isPageBreakRow(int rowIndex) {
        return false;
    }

    @Override
    public boolean isCellExist(int rowIndex, int colIndex) {
        return true;
    }

    @Override
    public boolean isGridLineVisible() {
        return true;
    }

    @Override
    public Color getGridLineColor() {
        return null;
    }

    @Override
    public Border getGridLine(Styles.Position pos) {
        return null;
    }
}

