/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.expans.model.data;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.IVarReferences;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtRow;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.util.ObjectCache;

public class ExtColumn
implements Comparable,
IExprNode,
IVarReferences {
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int DOUBLE = 4;
    public static final int DECIMAL = 5;
    public static final int DATE = 6;
    public static final int BOOLEAN = 7;
    public static final int OBJECT = 8;
    public static final int STRING = 9;
    public static final int TYPE_COUNT = 10;
    private ExtDataSet _ds;
    private String _name;
    private String _alias;
    private String _upperAlias;
    private Variant _varIndex;
    private Variant _varThis;
    private int _dataType;

    public ExtColumn(ExtDataSet ds, String colName, int oriIndex, int dataType) {
        this._ds = ds;
        this._name = this._alias = colName;
        this._upperAlias = this._alias.toUpperCase();
        this._varIndex = new Variant((Object)ObjectCache.getInteger((int)oriIndex), 3);
        this._varThis = new Variant((Object)this, 18);
        switch (dataType) {
            case 2: 
            case 3: {
                this._dataType = 5;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                this._dataType = 6;
                break;
            }
            case 16: {
                this._dataType = 7;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this._dataType = 4;
                break;
            }
            case 4: {
                this._dataType = 2;
                break;
            }
            case -5: {
                this._dataType = 3;
                break;
            }
            case -6: {
                this._dataType = 0;
                break;
            }
            case 5: {
                this._dataType = 1;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this._dataType = 9;
                break;
            }
            default: {
                this._dataType = 8;
            }
        }
    }

    public int compareTo(Object obj) {
        if (obj instanceof String) {
            return this._upperAlias.compareToIgnoreCase((String)obj);
        }
        return this._upperAlias.compareTo(((ExtColumn)obj)._upperAlias);
    }

    public String toString() {
        return this._name + "[" + this._dataType + "]";
    }

    public String getName() {
        return this._name;
    }

    public void setColumnName(String colName) {
        this._name = colName;
    }

    public boolean hasAlias() {
        return this._alias != null;
    }

    public String getAlias() {
        if (StringUtil.isEmptyString((String)this._alias)) {
            return this._name;
        }
        return this._alias;
    }

    public void setAlias(String alias) {
        this._alias = alias;
        this._upperAlias = this._alias.toUpperCase();
    }

    public Variant getIndex() {
        return this._varIndex;
    }

    public void setIndex(Variant index) {
        this._varIndex = index;
    }

    public int getDataType() {
        return this._dataType;
    }

    public void setDataType(int dataType) {
        this._dataType = dataType;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        ctx.getCurrentExprStack().push(this._varThis);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return this.getAlias();
    }

    @Override
    public int getExprType() {
        return 0x100000;
    }

    public Variant getValue() {
        ExtRow row = this._ds.getCurrentRow();
        return row == null || row.isNullRow() ? Variant.nullVariant : this._ds.field(row, (Integer)this._varIndex.getValue());
    }
}

