/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.expans.model.data;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtRow;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.ExprExpressionParam;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import java.util.Arrays;
import java.util.Comparator;

public class ExtGroup
implements Cloneable {
    private ExtDataSet _ds;
    private ExtRow[] _rows;
    private Variant[] _values;
    private Variant _varThis;

    public ExtGroup(ExtDataSet ds, ExtRow[] rows) {
        this._ds = ds;
        this._rows = rows;
    }

    public Object clone() {
        ExtGroup grp = new ExtGroup(this._ds, (ExtRow[])this._rows.clone());
        grp._varThis = null;
        return grp;
    }

    public String toString() {
        if (this._rows == null || this._rows.length == 0) {
            return "G[]";
        }
        StringBuffer sb = new StringBuffer("G[");
        sb.append(this._rows[0]);
        for (int i = 1; i < this._rows.length; ++i) {
            sb.append(',').append(this._rows[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public int size() {
        return this._rows.length;
    }

    public Variant getVar() {
        if (this._varThis == null) {
            this._varThis = new Variant((Object)this, 17);
        }
        return this._varThis;
    }

    public ExtDataSet getDataSet() {
        return this._ds;
    }

    public ExtRow[] getRows() {
        return this._rows;
    }

    void setValues(Variant[] values) {
        this._values = values;
    }

    public Variant[] getValues() {
        return this._values;
    }

    public boolean isNullGroup() {
        return this._rows == null || this._rows.length == 0;
    }

    public void select(ExprContext ctx, Variant selExp) {
        this._ds.select(this, ctx, selExp);
    }

    public Variant first(ExprContext ctx, Variant selExp) {
        if (this._rows == null || this._rows.length == 0) {
            return Variant.nullVariant;
        }
        return this._ds.field(ctx, selExp, this._rows[0]);
    }

    public Variant last(ExprContext ctx, Variant selExp) {
        if (this._rows == null || this._rows.length == 0) {
            return Variant.nullVariant;
        }
        return this._ds.field(ctx, selExp, this._rows[this._rows.length - 1]);
    }

    public ExtGroup filter(ExprContext ctx, Variant filterExp, ExtGroup out) throws SyntaxErrorException {
        ObjectArray al = ctx.getObjectArray(Math.max(10, this._rows.length >> 3));
        for (int i = 0; i < this._rows.length; ++i) {
            ExtRow row = this._rows[i];
            this._ds.setCurrentRow(row);
            Variant var = this._ds.calc(ctx, filterExp);
            if (!var.booleanValue()) continue;
            al.append((Object)row);
        }
        if (al.size() < this._rows.length) {
            if (out == null) {
                out = new ExtGroup(this._ds, null);
            }
            out._rows = new ExtRow[al.size()];
            al.toArray((Object[])out._rows, 0);
            out._values = null;
        } else {
            out = (ExtGroup)this.clone();
        }
        ctx.recycleArray(al);
        return out;
    }

    public ExtGroup separate(ExprContext ctx, Variant filterExp) throws SyntaxErrorException {
        ObjectArray apart = ctx.getObjectArray(Math.max(10, this._rows.length >> 3));
        ObjectArray keep = ctx.getObjectArray(this._rows.length - apart.size() + 1);
        for (int i = 0; i < this._rows.length; ++i) {
            ExtRow row = this._rows[i];
            this._ds.setCurrentRow(row);
            Variant var = this._ds.calc(ctx, filterExp);
            if (var.booleanValue()) {
                apart.append((Object)row);
                continue;
            }
            keep.append((Object)row);
        }
        ExtGroup gApart = null;
        if (keep.size() < this._rows.length) {
            this._rows = new ExtRow[keep.size()];
            keep.toArray((Object[])this._rows, 0);
            this._values = null;
            Object[] rows = new ExtRow[apart.size()];
            apart.toArray(rows, 0);
            gApart = new ExtGroup(this._ds, (ExtRow[])rows);
        }
        ctx.recycleArray(apart);
        ctx.recycleArray(keep);
        return gApart;
    }

    public final void sort(ExprContext ctx, Variant sortExp, boolean desc) throws SyntaxErrorException {
        RowComparator cmp = new RowComparator(ctx, sortExp, desc);
        Arrays.sort(this._rows, cmp);
    }

    public final void sort(ExprContext ctx, Variant[] aSort, boolean[] aDesc) throws SyntaxErrorException {
        RowComparator cmp = new RowComparator(ctx, aSort, aDesc);
        Arrays.sort(this._rows, cmp);
    }

    public Variant group(ExprContext ctx, Variant selExp) {
        this._ds.select(this, ctx, selExp);
        ObjectArray aGroups = ctx.getObjectArray(0);
        ObjectArray aRows = null;
        ObjectArray aValues = null;
        Variant var = null;
        for (int i = 0; i < this._rows.length; ++i) {
            Variant var2 = this._values[i];
            if (var != var2) {
                aRows = ctx.getObjectArray(0);
                aValues = ctx.getObjectArray(0);
                aGroups.append((Object)aRows);
                aGroups.append((Object)aValues);
            }
            if (aRows != null) {
                aRows.append((Object)this._rows[i]);
            }
            if (aValues != null) {
                aValues.append((Object)var2);
            }
            var = var2;
        }
        Variant[] groups = new Variant[aGroups.size() >> 1];
        int i = 0;
        int j = 0;
        int size = aGroups.size();
        while (i < size) {
            ObjectArray aRows2 = (ObjectArray)aGroups.get(i);
            Object[] rows = new ExtRow[aRows2.size()];
            aRows2.toArray(rows, 0);
            ctx.recycleArray(aRows2);
            ObjectArray aValues2 = (ObjectArray)aGroups.get(i + 1);
            Object[] values = new Variant[aValues2.size()];
            aValues2.toArray(values, 0);
            ctx.recycleArray(aValues2);
            ExtGroup group = new ExtGroup(this._ds, (ExtRow[])rows);
            group.setValues((Variant[])values);
            groups[j] = group.getVar();
            i += 2;
            ++j;
        }
        ctx.recycleArray(aGroups);
        Variant varRet = groups.length == 0 ? this._ds.getNullGroup().getVar() : new Variant((Object)groups, 527);
        return varRet;
    }

    private class RowComparator
    implements Comparator {
        private ExprContext _ctx;
        private ICalculable _exprOwner;
        private Expr[] _aExpr;
        private boolean[] _aDesc;
        private int[] _aColIndex;

        RowComparator(ExprContext ctx, Variant sortExp, boolean desc) {
            this._ctx = ctx;
            this._exprOwner = ctx.getExprOwner();
            this._aExpr = new Expr[1];
            this._aDesc = new boolean[1];
            this._aColIndex = new int[1];
            if (sortExp.getVt() == 3) {
                this._aColIndex[0] = (Integer)sortExp.getValue();
            } else {
                this._aExpr[0] = ((ExprExpressionParam)sortExp).getExpr();
                this._aColIndex[0] = -1;
            }
            this._aDesc[0] = desc;
        }

        RowComparator(ExprContext ctx, Variant[] aSort, boolean[] aDesc) {
            this._ctx = ctx;
            this._exprOwner = ctx.getExprOwner();
            this._aDesc = aDesc;
            this._aExpr = new Expr[aSort.length];
            this._aColIndex = new int[this._aExpr.length];
            for (int i = 0; i < aSort.length; ++i) {
                Variant sortExp = aSort[i];
                if (sortExp.getVt() == 3) {
                    this._aColIndex[i] = (Integer)sortExp.getValue();
                    continue;
                }
                this._aExpr[i] = ((ExprExpressionParam)sortExp).getExpr();
                this._aColIndex[i] = -1;
            }
        }

        public int compare(Object o1, Object o2) {
            ExtRow r1 = (ExtRow)o1;
            ExtRow r2 = (ExtRow)o2;
            int cmp = 0;
            try {
                for (int i = 0; i < this._aExpr.length; ++i) {
                    Variant var2;
                    Variant var;
                    int colIndex = this._aColIndex[i];
                    if (colIndex >= 0) {
                        ExtGroup.this._ds.setCurrentRow(r1);
                        var = ExtGroup.this._ds.field(colIndex);
                        ExtGroup.this._ds.setCurrentRow(r2);
                        var2 = ExtGroup.this._ds.field(colIndex);
                    } else {
                        Expr expr = this._aExpr[i];
                        ExtGroup.this._ds.setCurrentRow(r1);
                        var = expr.execute(this._ctx, this._exprOwner);
                        ExtGroup.this._ds.setCurrentRow(r2);
                        var2 = expr.execute(this._ctx, this._exprOwner);
                    }
                    cmp = var.compareTo(var2);
                    if (cmp == 0) continue;
                    if (this._aDesc[i]) {
                        cmp = -cmp;
                    }
                    break;
                }
            }
            catch (SyntaxErrorException e) {
                cmp = -1;
            }
            return cmp;
        }
    }
}

