/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.impl.facade.FilterPopupButton;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.bos.ctrl.swing.KDFilteredList;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class PopupListButton
extends KDWorkButton {
    private Icon originIcon;
    private Icon pressedIcon;
    private KDScrollPane sp;
    private KDPanel searchPanel;
    private KDTextField searchField;
    private JPopupMenu popup;
    private KDFilteredList list;
    private PopupListButtonHandler lbHandler;
    private Dimension parentDimension;
    private boolean isPopping;
    private ActionListener listSelectedListener;
    private ActionListener listUpdateDataListener;
    private ListListener listListener;
    private static final KeyStroke ENTER = KeyStroke.getKeyStroke(10, 0);

    public PopupListButton() {
        this.installDefaults();
        this.installListeners();
        this.layoutComponents();
    }

    private void installDefaults() {
        this.originIcon = com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager.getImageIcon("popuplistbtn_icon1.gif");
        this.pressedIcon = com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager.getImageIcon("popuplistbtn_icon2.gif");
        this.setBorder(null);
        this.setIcon(this.originIcon);
        this.list = new KDFilteredList();
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        this.list.setFocusTraversalKeys(0, set);
        this.list.setSort(true);
        this.list.setCellRenderer((ListCellRenderer)new DefaultKingdeeListCellRenderer(){

            protected String getDrawingText(Object item) {
                if ("".equals(item.toString())) {
                    return " ";
                }
                return item.toString();
            }
        });
        this.sp = new KDScrollPane((Component)this.list);
        this.sp.setBorder(KingdeeBorders.createWideEditorBorder());
        this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean b) {
                if (!b) {
                    PopupListButton.this.setIcon(PopupListButton.this.originIcon);
                }
                super.setVisible(b);
            }
        };
        this.popup.setBorder(BorderFactory.createEmptyBorder());
        this.popup.setLayout(new PopupListLayout());
        this.searchField = this.list.getFilterField();
        ImageIcon tipIcon = ResourceManager.getIcon(FilterPopupButton.class, (String)"tbtn_search.png");
        KDLabel tipLabel = new KDLabel((Icon)tipIcon);
        tipLabel.setSize(tipIcon.getIconWidth(), tipIcon.getIconHeight());
        this.searchField.setToolTipText(MultiLanguageKeys.getLocalText("search", "\u641c\u7d22"));
        this.searchPanel = new KDPanel((LayoutManager)new BorderLayout());
        this.searchPanel.setBorder(KingdeeBorders.createWideEditorBorder());
        this.searchPanel.add((Component)this.searchField, (Object)"Center");
        this.searchPanel.add((Component)tipLabel, (Object)"West");
        this.popup.add((Component)this.searchPanel);
        this.popup.add((Component)this.sp);
    }

    private void installListeners() {
        this.lbHandler = new PopupListButtonHandler();
        this.addMouseListener(this.lbHandler);
        this.listListener = new ListListener();
        this.list.addMouseListener((MouseListener)this.listListener);
        this.list.addMouseMotionListener((MouseMotionListener)this.listListener);
        this.list.addKeyListener((KeyListener)this.lbHandler);
        this.list.getInputMap().put(ENTER, ENTER);
        this.list.getActionMap().put(ENTER, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(e);
                if (!PopupListButton.this.isPopping) {
                    return;
                }
                PopupListButton.this.commitValue();
            }
        });
        this.searchField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PopupListButton.this.list.requestFocusInWindow();
                }
            }
        });
    }

    private void layoutComponents() {
        this.setLayout(null);
        this.setBounds(0, 0, this.originIcon.getIconWidth(), this.originIcon.getIconHeight());
    }

    private void popDownList() {
        if (!this.isPopping) {
            if (this.listUpdateDataListener != null) {
                this.listUpdateDataListener.actionPerformed(null);
            }
            JRootPane rp = this.getRootPane();
            Dimension rd = rp.getSize();
            Rectangle rect = this.getBounds();
            Point op = rect.getLocation();
            op = SwingUtilities.convertPoint(this.getParent(), op, rp);
            Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
            int popupHeight = this.popup.getPreferredSize().height;
            int bottomHeight = sd.height - rp.getLocationOnScreen().y - rd.height;
            if (op.y + rect.height + popupHeight < rd.height + bottomHeight - screenInsets.bottom) {
                Point p = new Point(rect.x - this.parentDimension.width, rect.y + rect.height);
                p = SwingUtilities.convertPoint(this.getParent(), p, (Component)((Object)this));
                this.popup.show((Component)((Object)this), p.x, p.y);
            } else {
                Point p = new Point(rect.x - this.parentDimension.width, rect.y + rect.height - this.parentDimension.height - popupHeight);
                p = SwingUtilities.convertPoint(this.getParent(), p, (Component)((Object)this));
                this.popup.show((Component)((Object)this), p.x, p.y);
            }
            this.isPopping = true;
            this.setIcon(this.pressedIcon);
            if (!StringUtil.isEmptyString((String)this.searchField.getText())) {
                this.list.requestFocusInWindow();
            } else {
                this.searchField.requestFocusInWindow();
                if (this.list.getSelectedIndex() == -1 && this.list.getElementCount() > 0) {
                    this.list.setSelectedIndex(0);
                }
            }
        } else {
            this.popup.setVisible(false);
            this.isPopping = false;
            this.setIcon(this.originIcon);
        }
    }

    public void removeNotify() {
        this.popup.setVisible(false);
        super.removeNotify();
    }

    public void setPopupVisible(boolean b) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isPopping != b) {
            this.popDownList();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.originIcon.getIconWidth(), this.originIcon.getIconHeight());
    }

    public void setListData(Object[] listData) {
        this.list.setListData(listData);
    }

    public void setSelectedValue(Object o) {
        this.list.setSelectedValue(o, true);
    }

    public void setParentDimension(Dimension parentDimension) {
        this.parentDimension = parentDimension;
    }

    public void setActionListener(ActionListener listSelectedListener) {
        this.listSelectedListener = listSelectedListener;
    }

    public void setUpdateDataListener(ActionListener listUpdateDataListener) {
        this.listUpdateDataListener = listUpdateDataListener;
    }

    private void commitValue() {
        Object o = this.list.getSelectedValue();
        if (o == null) {
            this.setPopupVisible(false);
            return;
        }
        if (this.listSelectedListener != null) {
            this.listSelectedListener.actionPerformed(new ActionEvent(o, 0, ""));
        }
        this.setPopupVisible(false);
    }

    private class PopupListLayout
    implements LayoutManager {
        private int columnHeight = 20;
        private int insets = 4;
        private int listCellCountPerPage = 8;

        private PopupListLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int rowCount = PopupListButton.this.list.getRealSize();
            int pageRowCount = this.listCellCountPerPage >= rowCount ? rowCount : this.listCellCountPerPage;
            int height = this.columnHeight * pageRowCount + this.columnHeight;
            int width = ((PopupListButton)PopupListButton.this).parentDimension.width + PopupListButton.this.getBounds().width;
            return new Dimension(width, height + this.insets * 2);
        }

        @Override
        public void layoutContainer(Container parent) {
            int rowCount = PopupListButton.this.list.getRealSize();
            int pageRowCount = this.listCellCountPerPage >= rowCount ? rowCount : this.listCellCountPerPage;
            int height = this.columnHeight * pageRowCount;
            int width = ((PopupListButton)PopupListButton.this).parentDimension.width + PopupListButton.this.getBounds().width;
            int searchPanelHeight = this.columnHeight + this.insets;
            PopupListButton.this.searchPanel.setBounds(0, 0, width, searchPanelHeight);
            PopupListButton.this.sp.setBounds(0, searchPanelHeight, width, height + this.insets);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }
    }

    private class ListListener
    extends MouseAdapter
    implements MouseMotionListener {
        private ListListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PopupListButton.this.commitValue();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point location = e.getPoint();
            Rectangle r = new Rectangle();
            PopupListButton.this.list.computeVisibleRect(r);
            if (r.contains(location)) {
                PopupListButton.this.list.setSelectedIndex(PopupListButton.this.list.locationToIndex(location));
            }
        }
    }

    private class PopupListButtonHandler
    extends MouseAdapter
    implements KeyListener {
        private PopupListButtonHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PopupListButton.this.setPopupVisible(!PopupListButton.this.isPopping);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                if (!PopupListButton.this.isPopping) {
                    return;
                }
                PopupListButton.this.setPopupVisible(false);
                e.consume();
            } else if (e.isAltDown() && (e.getKeyCode() == 38 || e.getKeyCode() == 40)) {
                if (PopupListButton.this.isPopping) {
                    PopupListButton.this.commitValue();
                } else {
                    PopupListButton.this.setPopupVisible(true);
                }
                e.consume();
            } else if (e.getKeyCode() == 40) {
                if (!PopupListButton.this.isPopping) {
                    return;
                }
                int selectedIndex = -1;
                int itemCount = PopupListButton.this.list.getElementCount();
                selectedIndex = PopupListButton.this.list.getSelectedIndex();
                if (selectedIndex < itemCount - 1) {
                    ++selectedIndex;
                }
                PopupListButton.this.list.setSelectedIndex(selectedIndex);
                PopupListButton.this.list.ensureIndexIsVisible(selectedIndex);
                e.consume();
            } else if (e.getKeyCode() == 38) {
                if (!PopupListButton.this.isPopping) {
                    return;
                }
                int selectedIndex = -1;
                selectedIndex = PopupListButton.this.list.getSelectedIndex();
                if (selectedIndex > 0) {
                    PopupListButton.this.list.setSelectedIndex(--selectedIndex);
                    PopupListButton.this.list.ensureIndexIsVisible(selectedIndex);
                } else {
                    PopupListButton.this.searchField.requestFocusInWindow();
                }
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

