/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardCreateGroup;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

public class WizzardClassifiedStatistics
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private KDLabel classifiedFieldLabel = new KDLabel(MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_LABEL1", "\u5206\u7c7b\u5b57\u6bb5") + "(A)");
    private KDLabel functionLabel = new KDLabel(MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_LABEL2", "\u6c47\u603b\u65b9\u5f0f") + "(U)");
    private KDLabel sumTotalFieldLabel = new KDLabel(MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_LABEL3", "\u9009\u5b9a\u6c47\u603b\u9879") + "(D)");
    private KDComboBox classifiedFieldComboBox = new KDComboBox();
    private KDComboBox functionComboBox = new KDComboBox(new Object[]{MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_FunctionName1", "\u6c42\u548c"), MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_FunctionName2", "\u8ba1\u6570"), MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_FunctionName3", "\u5e73\u5747\u503c"), MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_FunctionName4", "\u6700\u5927\u503c"), MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_FunctionName5", "\u6700\u5c0f\u503c"), MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_FunctionName6", "\u4e58\u79ef"), MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_FunctionName7", "\u6570\u503c\u8ba1\u6570"), MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_FunctionName8", "\u6807\u51c6\u504f\u5dee"), MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_FunctionName9", "\u603b\u4f53\u6807\u51c6\u504f\u5dee"), MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_FunctionName10", "\u65b9\u5dee"), MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_FunctionName11", "\u603b\u4f53\u65b9\u5dee")});
    private JTable sumTotalFieldTable = new JTable();
    private JScrollPane sp = new JScrollPane(this.sumTotalFieldTable);
    private KDCheckBox replaceCurrentSumTotal = new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_CheckBox1", "\u66ff\u6362\u5f53\u524d\u5206\u7c7b\u6c47\u603b") + "(C)");
    private KDCheckBox isPaged = new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_CheckBox2", "\u6bcf\u7ec4\u6570\u636e\u5206\u9875") + "(P)");
    private KDCheckBox belowTheData = new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_CheckBox3", "\u6c47\u603b\u7ed3\u679c\u663e\u793a\u5728\u6570\u636e\u4e0b\u65b9") + "(S)");
    private KDButton delete = new KDButton(MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_AllDelete", "\u5168\u90e8\u5220\u9664") + "(R)");
    private KDButton submit = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK", "\u786e\u5b9a"));
    private KDButton cancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL", "\u53d6\u6d88"));
    private CellBlock cellBlock;

    public WizzardClassifiedStatistics(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComponents();
        this.initListeners();
        this.setResizable(false);
    }

    public WizzardClassifiedStatistics(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComponents();
        this.initListeners();
        this.setResizable(false);
    }

    private void initComponents() {
        this.setSize(280, 290);
        Container c = this.getContentPane();
        c.setLayout(null);
        this.sumTotalFieldTable.setTableHeader(null);
        this.sumTotalFieldTable.setRowHeight(20);
        this.classifiedFieldLabel.setBounds(10, 5, 80, 20);
        this.classifiedFieldComboBox.setBounds(10, 25, 180, 20);
        this.functionLabel.setBounds(10, 50, 80, 20);
        this.functionComboBox.setBounds(10, 70, 180, 20);
        this.sumTotalFieldLabel.setBounds(10, 95, 80, 20);
        this.sp.setBounds(10, 115, 180, 115);
        this.delete.setBounds(10, 240, 100, 20);
        this.submit.setBounds(115, 240, 60, 20);
        this.cancel.setBounds(195, 240, 60, 20);
        c.add((Component)this.classifiedFieldLabel);
        c.add((Component)this.classifiedFieldComboBox);
        c.add((Component)this.functionLabel);
        c.add((Component)this.functionComboBox);
        c.add((Component)this.sumTotalFieldLabel);
        c.add(this.sp);
        c.add((Component)this.replaceCurrentSumTotal);
        c.add((Component)this.isPaged);
        c.add((Component)this.belowTheData);
        c.add((Component)this.delete);
        c.add((Component)this.submit);
        c.add((Component)this.cancel);
        this.replaceCurrentSumTotal.setSelected(true);
        this.belowTheData.setSelected(true);
    }

    private void initListeners() {
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(65, 8), "focusClassifiedFieldComboBox");
        this.rootPane.getActionMap().put("focusClassifiedFieldComboBox", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardClassifiedStatistics.this.classifiedFieldComboBox.requestFocus();
            }
        });
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(85, 8), "focusFunctionComboBox");
        this.rootPane.getActionMap().put("focusFunctionComboBox", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardClassifiedStatistics.this.functionComboBox.requestFocus();
            }
        });
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(68, 8), "focusSumTotalFieldList");
        this.rootPane.getActionMap().put("focusSumTotalFieldList", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardClassifiedStatistics.this.sumTotalFieldTable.requestFocus();
            }
        });
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(67, 8), "selectReplaceCurrentSumTotal");
        this.rootPane.getActionMap().put("selectReplaceCurrentSumTotal", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardClassifiedStatistics.this.replaceCurrentSumTotal.setSelected(!WizzardClassifiedStatistics.this.replaceCurrentSumTotal.isSelected());
            }
        });
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(80, 8), "selectIsPaged");
        this.rootPane.getActionMap().put("selectIsPaged", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardClassifiedStatistics.this.isPaged.setSelected(!WizzardClassifiedStatistics.this.isPaged.isSelected());
            }
        });
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(83, 8), "selectBelowTheData");
        this.rootPane.getActionMap().put("selectBelowTheData", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardClassifiedStatistics.this.belowTheData.setSelected(!WizzardClassifiedStatistics.this.belowTheData.isSelected());
            }
        });
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(82, 8), "deleteAction");
        this.rootPane.getActionMap().put("deleteAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardClassifiedStatistics.this.delete.doClick();
            }
        });
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardClassifiedStatistics.this.deleteClassifiedStatistics();
                WizzardClassifiedStatistics.this.closeDialog();
            }
        });
        this.submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowCount = WizzardClassifiedStatistics.this.sumTotalFieldTable.getRowCount();
                boolean canSubmit = false;
                for (int i = 0; i < rowCount; ++i) {
                    if (!((Boolean)WizzardClassifiedStatistics.this.sumTotalFieldTable.getValueAt(i, 0)).booleanValue()) continue;
                    canSubmit = true;
                    break;
                }
                if (!canSubmit) {
                    WindowUtil.msgboxInfo((Object)MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_MSG1", "\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u5217\u4f5c\u4e3a\u6c47\u603b\u76ee\u6807\uff01"), (String)MultiLanguageKeys.getLocalText("Key_Sort_DialogTitle", "\u4fe1\u606f\u63d0\u9192"), (Component)((Object)WizzardClassifiedStatistics.this._context));
                    return;
                }
                WizzardClassifiedStatistics.this.createClassifiedStatistics();
                WizzardClassifiedStatistics.this.closeDialog();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardClassifiedStatistics.this.closeDialog();
            }
        });
    }

    private void deleteClassifiedStatistics() {
        int mark;
        int i;
        Book book = this._context.getSpread().getBook();
        Sheet sheet = book.getActiveSheet();
        ArrayList<Integer> candidateRows = new ArrayList<Integer>();
        int maxRowIndex = sheet.getMaxRowIndex();
        block0: for (int i2 = this.cellBlock.getRow(); i2 <= this.cellBlock.getRow2(); ++i2) {
            for (int j = this.cellBlock.getCol(); j <= this.cellBlock.getCol2(); ++j) {
                Cell cell = sheet.getCell(i2, j, false);
                if (cell == null || !cell.getFormula().startsWith("=SUBTOTAL")) continue;
                candidateRows.add(new Integer(i2));
                continue block0;
            }
        }
        boolean isSafe = true;
        block2: for (i = 0; i < candidateRows.size(); ++i) {
            Cell cell;
            int m;
            int rowId = (Integer)candidateRows.get(i);
            for (m = 0; m < this.cellBlock.getCol(); ++m) {
                cell = sheet.getCell(rowId, m, false);
                if (cell == null) continue;
                isSafe = false;
                break block2;
            }
            for (m = this.cellBlock.getCol2() + 1; m < maxRowIndex; ++m) {
                cell = sheet.getCell(rowId, m, false);
                if (cell == null) continue;
                isSafe = false;
                break block2;
            }
        }
        if (!isSafe && (mark = MessageDialog.show((Component)((Object)this._context), (Object)MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_MSG2", "\u5206\u7c7b\u7edf\u8ba1\u533a\u57df\u5916\u68c0\u6d4b\u5230\u66fe\u88ab\u7528\u6237\u7f16\u8f91\uff0c\u5f3a\u5236\u5220\u9664\u53ef\u80fd\u5bfc\u81f4\u6570\u636e\u4e0d\u5b89\u5168\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\u64cd\u4f5c\uff1f"), (String)MultiLanguageKeys.getLocalText("Key_Sort_DialogTitle", "\u4fe1\u606f\u63d0\u9192"), (int)2)) != 0) {
            return;
        }
        book.getUndoManager().startGroup();
        sheet.getRowRange(this.cellBlock.getRow(), this.cellBlock.getRow2()).setRowOutlineGroupLevel(0);
        for (i = candidateRows.size() - 1; i >= 0; --i) {
            int rowId = (Integer)candidateRows.get(i);
            sheet.getRowRange(rowId, rowId).delete();
        }
        book.getUndoManager().endGroup();
    }

    private void createClassifiedStatistics() {
        Book book = this._context.getSpread().getBook();
        Sheet sheet = book.getActiveSheet();
        book.getUndoManager().startGroup();
        int baseRow = this.cellBlock.getRow();
        int baseCol = this.cellBlock.getCol();
        int baseRow2 = this.cellBlock.getRow2();
        ArrayList<Integer> statCols = new ArrayList<Integer>();
        int groupCol = baseCol + this.classifiedFieldComboBox.getSelectedIndex();
        int rowCount = this.sumTotalFieldTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (!((Boolean)this.sumTotalFieldTable.getValueAt(i, 0)).booleanValue()) continue;
            statCols.add(new Integer(baseCol + i));
        }
        int tagCol = this.getTagColIndex(groupCol, statCols);
        String lastCellText = "";
        ArrayList<RowPair> rowPairs = new ArrayList<RowPair>();
        RowPair currentRP = new RowPair();
        currentRP.setRow1(baseRow + 1);
        for (int i = baseRow + 1; i <= baseRow2; ++i) {
            Cell cell = sheet.getCell(i, groupCol, false);
            if (cell == null || cell.getText().equals("")) continue;
            String nonEmptyText = cell.getText();
            if (i == baseRow + 1) {
                lastCellText = nonEmptyText;
                continue;
            }
            if (lastCellText.equalsIgnoreCase(nonEmptyText)) continue;
            currentRP.setRow2(i - 1);
            currentRP.setLabel(lastCellText);
            rowPairs.add(currentRP);
            currentRP = new RowPair();
            currentRP.setRow1(i);
            lastCellText = nonEmptyText;
        }
        currentRP.setRow2(baseRow2);
        currentRP.setLabel(lastCellText);
        rowPairs.add(currentRP);
        currentRP = null;
        sheet.getRowRange(this.cellBlock.getRow(), this.cellBlock.getRow2()).setRowOutlineGroupLevel(0);
        int functionIndex = this.mappingToSubtotalIndex(this.functionComboBox.getSelectedIndex());
        for (int i = rowPairs.size() - 1; i >= 0; --i) {
            String function;
            String blockName;
            int col;
            int m;
            RowPair rp = (RowPair)rowPairs.get(i);
            int nextRowIndex = rp.getRow2() + 1;
            Range range = sheet.getRowRange(nextRowIndex, nextRowIndex);
            if (i == rowPairs.size() - 1) {
                range.insert(true);
                for (m = 0; m < statCols.size(); ++m) {
                    col = (Integer)statCols.get(m);
                    blockName = SheetBaseMath.getBlockA1Name(baseRow + 1, col, baseRow2, col, false);
                    function = "=SUBTOTAL(" + functionIndex + "," + blockName + ")";
                    sheet.getRange(nextRowIndex, col).setFormula(function);
                }
            }
            range.insert(true);
            for (m = 0; m < statCols.size(); ++m) {
                col = (Integer)statCols.get(m);
                blockName = SheetBaseMath.getBlockA1Name(rp.getRow1(), col, rp.getRow2(), col, false);
                function = "=SUBTOTAL(" + functionIndex + "," + blockName + ")";
                sheet.getRange(nextRowIndex, col).setFormula(function);
            }
        }
        StyleAttributes cellSa = Styles.getEmptySA();
        cellSa.setBold(true);
        if (tagCol >= 0) {
            int rowId = this.cellBlock.getRow() + 1;
            for (int i = 0; i < rowPairs.size(); ++i) {
                RowPair rp = (RowPair)rowPairs.get(i);
                int temp = rowId;
                Range range = sheet.getRange(rowId += rp.getRow2() - rp.getRow1() + 1, tagCol);
                range.setValue(new Variant((Object)(rp.getLabel() + " " + this.functionComboBox.getSelectedItem())));
                range.setStyle(cellSa, Styles.getEmptySA());
                WizzardCreateGroup.createGroup(this._context, temp, rowId - 1, true);
                ++rowId;
            }
            Range range = sheet.getRange(rowId, tagCol);
            range.setValue(new Variant((Object)(MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_Total", "\u603b\u8ba1") + this.functionComboBox.getSelectedItem())));
            range.setStyle(cellSa, Styles.getEmptySA());
            WizzardCreateGroup.createGroup(this._context, this.cellBlock.getRow() + 1, rowId - 1, true);
        } else {
            int col = this.cellBlock.getCol();
            Range range = sheet.getColRange(col, col);
            range.insert(false);
            int rowId = this.cellBlock.getRow() + 1;
            for (int i = 0; i < rowPairs.size(); ++i) {
                RowPair rp = (RowPair)rowPairs.get(i);
                range = sheet.getRange(rowId += rp.getRow2() - rp.getRow1() + 1, col);
                range.setValue(new Variant((Object)(rp.getLabel() + " " + this.functionComboBox.getSelectedItem())));
                range.setStyle(cellSa, Styles.getEmptySA());
                ++rowId;
            }
            range = sheet.getRange(rowId, col);
            range.setValue(new Variant((Object)(MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_Total", "\u603b\u8ba1") + this.functionComboBox.getSelectedItem())));
            range.setStyle(cellSa, Styles.getEmptySA());
        }
        book.getUndoManager().endGroup();
    }

    private int mappingToSubtotalIndex(int comboBoxIndex) {
        switch (comboBoxIndex) {
            case 0: {
                return 9;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 11;
            }
        }
        return -1;
    }

    private int getTagColIndex(int groupCol, ArrayList statCols) {
        int baseCol = this.cellBlock.getCol();
        block0: while (groupCol >= baseCol) {
            for (int i = 0; i < statCols.size(); ++i) {
                if ((Integer)statCols.get(i) != groupCol) continue;
                --groupCol;
                continue block0;
            }
            return groupCol;
        }
        return -1;
    }

    private void closeDialog() {
        this.cellBlock = null;
        this.setVisible(false);
        this.dispose();
    }

    private void prepareDialog() {
        ArrayList<DisplayItem> uniqueNames = new ArrayList<DisplayItem>();
        this.classifiedFieldComboBox.removeAllItems();
        Sheet sheet = this._context.getSpread().getBook().getActiveSheet();
        int cbRow = this.cellBlock.getRow();
        int cbCol = this.cellBlock.getCol();
        int cbCol2 = this.cellBlock.getCol2();
        for (int i = cbCol; i <= cbCol2; ++i) {
            Cell cell = sheet.getCell(cbRow, i, false);
            if (SheetBaseMath.getCellValueType(cell) == SheetBaseMath.DataType_Empty) {
                uniqueNames.add(new DisplayItem(MultiLanguageKeys.getLocalText("Key_Col", "\u5217") + " " + SheetBaseMath.getColumnName(i, 0, true, false)));
                continue;
            }
            String v = cell.getText();
            int m = 1;
            for (int j = 0; j < uniqueNames.size(); ++j) {
                DisplayItem o = (DisplayItem)uniqueNames.get(j);
                if (!o.getValue().equals(v)) continue;
                o.setText("(" + m + ") " + v);
                ++m;
            }
            if (m != 1) {
                DisplayItem di = new DisplayItem(v);
                di.setText("(" + m + ") " + v);
                uniqueNames.add(di);
                continue;
            }
            uniqueNames.add(new DisplayItem(v));
        }
        this.classifiedFieldComboBox.addItems(uniqueNames.toArray());
        this.sumTotalFieldTable.setModel(new DisplayTableModel(uniqueNames));
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        Sheet sheet = this._context.getSpread().getBook().getActiveSheet();
        Range range = sheet.getSelectionRange();
        if (range.size() > 1) {
            WindowUtil.msgboxInfo((Object)MultiLanguageKeys.getLocalText("KEY_GROUP_DELETE_MSG", "\u4e0d\u80fd\u5bf9\u591a\u91cd\u9009\u5b9a\u533a\u57df\u4f7f\u7528\u6b64\u547d\u4ee4\u3002"), (String)MultiLanguageKeys.getLocalText("Key_Sort_DialogTitle", "\u4fe1\u606f\u63d0\u9192"), (Component)((Object)this._context));
            return false;
        }
        CellBlock cb = range.getBlock(0);
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        int cbRow = cb.getRow();
        int cbCol = cb.getCol();
        int cbRow2 = cb.getRow2();
        int cbCol2 = cb.getCol2();
        boolean recreate = false;
        if (cbRow2 > maxRow) {
            cbRow2 = maxRow;
            recreate = true;
        }
        if (cbCol2 > maxCol) {
            cbCol2 = maxCol;
            recreate = true;
        }
        if (recreate && cbRow2 >= cbRow && cbCol2 >= cbCol) {
            cb.setRowCol(cbRow, cbCol, cbRow2, cbCol2);
            this._context.getSpread().repaint();
        }
        if (cbRow > maxRow || cbCol > maxCol || cbRow == cbRow2) {
            WindowUtil.msgboxInfo((Object)MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_MSG3", "\u4f7f\u7528\u6307\u5b9a\u7684\u533a\u57df\u65e0\u6cd5\u5b8c\u6210\u8be5\u547d\u4ee4\u3002\u8bf7\u5728\u533a\u57df\u5185\u9009\u62e9\u67d0\u4e2a\u5355\u5143\u683c\uff0c\u7136\u540e\u518d\u6b21\u5c1d\u8bd5\u8be5\u547d\u4ee4\u3002"), (String)MultiLanguageKeys.getLocalText("Key_Sort_DialogTitle", "\u4fe1\u606f\u63d0\u9192"), (Component)((Object)this._context));
            return false;
        }
        int detectStatus = SheetBaseMath.detectRangeTitle(this._context);
        if (detectStatus == -1) {
            int mark = MessageDialog.show((Component)((Object)this._context), (Object)MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_MSG4", "\u65e0\u6cd5\u63a2\u6d4b\u5230\u5217\u5934\u4f4d\u7f6e\uff0c\u662f\u5426\u5f3a\u5236\u9996\u884c\u4f5c\u4e3a\u5217\u5934\u3002"), (String)MultiLanguageKeys.getLocalText("Key_Sort_DialogTitle", "\u4fe1\u606f\u63d0\u9192"), (int)2);
            if (mark == 0) {
                this.cellBlock = cb;
                this.prepareDialog();
                return true;
            }
            return false;
        }
        if (detectStatus == 1) {
            int mark = WindowUtil.msgboxYesNoCancel((Component)((Object)this._context), (Object)MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_MSG5", "\u5217\u5934\u4f4d\u7f6e\u53ef\u80fd\u5728\u4e0a\u4e00\u884c\uff0c\u662f\u5426\u5305\u62ec\u8fdb\u6765\uff1f"), (String)MultiLanguageKeys.getLocalText("Key_Sort_DialogTitle", "\u4fe1\u606f\u63d0\u9192"));
            if (mark == 0) {
                cb.setRow(cb.getRow() - 1);
                this._context.getSpread().repaint();
                this.cellBlock = cb;
                this.prepareDialog();
                return true;
            }
            if (mark == 1) {
                this.cellBlock = cb;
                this.prepareDialog();
                return true;
            }
            return false;
        }
        this.cellBlock = cb;
        this.prepareDialog();
        return true;
    }

    private static class DisplayItem {
        String text;
        Object value;

        DisplayItem(Object value) {
            this.value = value;
        }

        void setText(String text) {
            this.text = text;
        }

        Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.text == null ? this.value.toString() : this.text;
        }
    }

    private static class DisplayTableModel
    extends AbstractTableModel {
        ArrayList data;
        Boolean[] rowSelected;

        DisplayTableModel(ArrayList data) {
            this.data = data;
            this.rowSelected = new Boolean[data.size()];
            for (int i = 0; i < this.rowSelected.length; ++i) {
                this.rowSelected[i] = Boolean.FALSE;
            }
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                this.rowSelected[rowIndex] = (Boolean)value;
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.rowSelected[rowIndex];
            }
            if (columnIndex == 1) {
                return this.data.get(rowIndex);
            }
            return null;
        }
    }

    private static class RowPair {
        int row1;
        int row2;
        String label;

        private RowPair() {
        }

        int getRow1() {
            return this.row1;
        }

        void setRow1(int row1) {
            this.row1 = row1;
        }

        int getRow2() {
            return this.row2;
        }

        void setRow2(int row2) {
            this.row2 = row2;
        }

        void setLabel(String label) {
            this.label = label;
        }

        String getLabel() {
            return this.label;
        }
    }
}

