/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.border.Border;
import org.jdesktop.layout.GroupLayout;

public class WizzardEmbedObjectConfig
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private EmbedObject embed;
    private ButtonPanel btnPanel;
    private PropertiesPanel propsPanel;
    private KDTabbedPane tabbedPane;

    public WizzardEmbedObjectConfig(Dialog w, SpreadContext context) {
        super(w);
        this._context = context;
        this.initComps();
    }

    public WizzardEmbedObjectConfig(Frame w, SpreadContext context) {
        super(w);
        this._context = context;
        this.initComps();
    }

    private void initComps() {
        this.setSize(450, 340);
        this.btnPanel = new ButtonPanel();
        this.tabbedPane = new KDTabbedPane();
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)this.tabbedPane, "Center");
        c.add((Component)((Object)this.btnPanel), "South");
        this.propsPanel = new PropertiesPanel();
        this.tabbedPane.addTab(MultiLanguageKeys.getLocalText("Key_EmbededObjectProperties1", "\u5c5e\u6027"), (Component)((Object)this.propsPanel));
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        EmbedhLayer elayer = this._context.getBook().getActiveSheet().getEmbedments(false);
        if (elayer == null) {
            return false;
        }
        this.embed = elayer.getActiveSelectedEmbed();
        if (this.embed == null) {
            return false;
        }
        switch (this.embed.getAnchorMode()) {
            case 0: {
                this.propsPanel.anchorTwoCell.setSelected(true);
                break;
            }
            case 1: {
                this.propsPanel.anchorOneCell.setSelected(true);
                break;
            }
            case 2: {
                this.propsPanel.anchorAbsolute.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad embed anchor mode");
            }
        }
        return true;
    }

    private class PropertiesPanel
    extends KDPanel {
        private KDRadioButton anchorTwoCell;
        private KDRadioButton anchorOneCell;
        private KDRadioButton anchorAbsolute;

        PropertiesPanel() {
            this.initComps();
            this.initListeners();
        }

        private void initComps() {
            this.setLayout(null);
            ButtonGroup btnGroup = new ButtonGroup();
            this.anchorTwoCell = new KDRadioButton(MultiLanguageKeys.getLocalText("Key_EmbededObjectLocation1", "\u5927\u5c0f\u3001\u4f4d\u7f6e\u968f\u5355\u5143\u683c\u800c\u53d8"));
            this.anchorOneCell = new KDRadioButton(MultiLanguageKeys.getLocalText("Key_EmbededObjectLocation2", "\u5927\u5c0f\u56fa\u5b9a\uff0c\u4f4d\u7f6e\u968f\u5355\u5143\u683c\u800c\u53d8"));
            this.anchorAbsolute = new KDRadioButton(MultiLanguageKeys.getLocalText("Key_EmbededObjectLocation3", "\u5927\u5c0f\u3001\u4f4d\u7f6e\u5747\u56fa\u5b9a"));
            btnGroup.add((AbstractButton)this.anchorTwoCell);
            btnGroup.add((AbstractButton)this.anchorOneCell);
            btnGroup.add((AbstractButton)this.anchorAbsolute);
            KDPanel locations = new KDPanel();
            locations.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageKeys.getLocalText("Key_EmbededObjectLocation", "\u5bf9\u8c61\u4f4d\u7f6e")));
            this.add((Component)locations);
            locations.setBounds(0, 0, 250, 150);
            locations.setLayout((LayoutManager)new BoxLayout((Container)locations, 1));
            locations.add((Component)this.anchorTwoCell);
            locations.add((Component)this.anchorOneCell);
            locations.add((Component)this.anchorAbsolute);
        }

        private void initListeners() {
        }
    }

    private class ButtonPanel
    extends KDPanel {
        private KDButton cancel;
        private KDButton ok;

        ButtonPanel() {
            this.setPreferredSize(new Dimension(500, 35));
            this.initComps();
            this.initListeners();
        }

        private void initComps() {
            this.cancel = new KDButton();
            this.ok = new KDButton();
            this.cancel.setText(MultiLanguageKeys.getLocalText("KEY_CANCEL", "\u53d6\u6d88"));
            this.ok.setText(MultiLanguageKeys.getLocalText("KEY_OK", "\u786e\u5b9a"));
            GroupLayout layout = new GroupLayout((Container)((Object)this));
            this.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(392, Short.MAX_VALUE).add((Component)this.ok).addPreferredGap(1).add((Component)this.cancel).addContainerGap()));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancel).add((Component)this.ok)).addContainerGap(-1, Short.MAX_VALUE)));
        }

        private void initListeners() {
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WizzardEmbedObjectConfig.this.setVisible(false);
                }
            });
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WizzardEmbedObjectConfig.this.propsPanel.anchorTwoCell.isSelected()) {
                        WizzardEmbedObjectConfig.this.embed.setAnchorMode(0);
                    } else if (WizzardEmbedObjectConfig.this.propsPanel.anchorOneCell.isSelected()) {
                        WizzardEmbedObjectConfig.this.embed.setAnchorMode(1);
                    } else if (WizzardEmbedObjectConfig.this.propsPanel.anchorAbsolute.isSelected()) {
                        WizzardEmbedObjectConfig.this.embed.setAnchorMode(2);
                    }
                    WizzardEmbedObjectConfig.this.setVisible(false);
                }
            });
        }
    }
}

