/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.state;

import com.kingdee.bos.ctrl.common.ClipboardProxy;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.state.DefaultState;
import com.kingdee.bos.ctrl.excel.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.excel.io.clipboard.ClipboardTransferHandler;
import com.kingdee.bos.ctrl.excel.model.struct.KDClipboard;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class CopyState
extends DefaultState {
    private ActionListener _clipLis;
    protected Sheet _srcSheet;
    protected SortedCellBlockArray _srcBlocks;
    protected boolean _forClipboardChange = false;

    CopyState(SpreadContext context, SortedCellBlockArray srcBlocks) {
        super(context);
        this.init(srcBlocks);
    }

    void init(SortedCellBlockArray srcBlocks) {
        this._clipLis = new ClipboardListener();
        this._srcBlocks = srcBlocks;
        this._srcSheet = this._context.getBook().getActiveSheet();
        this._context.getThreadManager().getTimer(150, this._clipLis).start();
    }

    public Sheet getSrcSheet() {
        return this._srcSheet;
    }

    public SortedCellBlockArray getSrcBlocks() {
        return this._srcBlocks;
    }

    @Override
    public boolean cancel(int key) {
        return this.stop(key);
    }

    @Override
    public int getKey() {
        return SpreadStateManager.Key_Copy;
    }

    @Override
    public boolean start(int preKey) {
        this._context.getRenderManager().getSparkRender().stop();
        this._context.getRenderManager().getSparkRender().setSparkBlocks((Object)this._srcBlocks);
        this._context.getRenderManager().getSparkRender().start();
        Timer timer = this._context.getThreadManager().getTimer(150, this._clipLis);
        if (!timer.isRunning()) {
            timer.start();
        }
        return true;
    }

    @Override
    public boolean stop(int key) {
        this._context.getRenderManager().getSparkRender().stop();
        if (key != SpreadStateManager.Key_Copy && key != SpreadStateManager.Key_Cut && key != SpreadStateManager.Key_Style_Brush) {
            this._context.getThreadManager().getTimer(150, this._clipLis).stop();
            this._context.getRenderManager().getSparkRender().setSparkBlocks(null);
            if (this._forClipboardChange) {
                this._forClipboardChange = false;
            } else {
                ClipboardProxy clipProxy = ClipboardProxy.getInstance();
                if (clipProxy != null) {
                    clipProxy.openClipboard(null);
                    clipProxy.emptyClipboard();
                    clipProxy.closeClipboard();
                }
                KDClipboard.clear();
            }
        }
        return true;
    }

    @Override
    public void changed(BookChangeEvent e) {
        if (e.isSheetActive()) {
            if (this._srcSheet == this._context.getBook().getActiveSheet()) {
                this._context.getRenderManager().getSparkRender().setSparkBlocks((Object)this._srcBlocks);
            } else {
                this._context.getRenderManager().getSparkRender().setSparkBlocks(null);
            }
        }
    }

    private class ClipboardListener
    implements ActionListener {
        private ClipboardListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ClipboardProxy.getInstance() != null && !KDClipboard.sameUUID(ClipboardTransferHandler.getRangeUUID())) {
                CopyState.this._forClipboardChange = true;
                CopyState.this._context.getStateManager().cancel(CopyState.this.getKey());
                return;
            }
        }
    }
}

