/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kml;

import com.kingdee.bos.ctrl.excel.io.kml.BasicElement;
import com.kingdee.bos.ctrl.excel.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.excel.io.kml.KmlUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class ColumnElement
extends BasicElement {
    ColumnElement() {
    }

    private void updateColSpans(String uri, String localName, String qName, Attributes attributes, KmlToBook.DataCache dataCache, KmlToBook ktb) {
        int colIndex;
        Sheet sheet = dataCache.getCurSheet();
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        String strColIndex = attributes.getValue(KmlUtil.getNSName("Index", NS_SHEET));
        if (strColIndex == null) {
            colIndex = 0;
            if (colSpans.size() > 0) {
                colIndex = colSpans.getSpan(colSpans.size() - 1).getEnd() + 1;
            }
        } else {
            colIndex = Integer.parseInt(strColIndex) - 1;
        }
        int span = 0;
        String strSpan = attributes.getValue(KmlUtil.getNSName("Span", NS_SHEET));
        if (strSpan != null) {
            span = Integer.parseInt(strSpan);
        }
        ShareStyleAttributes ssa = null;
        if (ktb.touchModeFlag(FLAG_STYLE)) {
            String styleID = attributes.getValue(KmlUtil.getNSName("StyleID", NS_SHEET));
            ssa = (ShareStyleAttributes)dataCache.getStyles().get(styleID);
        }
        Integer width = null;
        String strWidth = attributes.getValue(KmlUtil.getNSName("Width", NS_SHEET));
        if (strWidth != null) {
            width = new Integer(KmlUtil.toScreenValue(Float.parseFloat(strWidth)));
        }
        Boolean visible = null;
        String strHidden = attributes.getValue(KmlUtil.getNSName("Hidden", NS_SHEET));
        if (strHidden != null) {
            visible = Integer.parseInt(strHidden) > 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (ssa != null || width != null || visible != null) {
            colSpans.setSpanAttribute(new Span(colIndex, colIndex + span), ssa, width, visible, null, null, false);
        }
    }

    @Override
    boolean isCurrentElement(String uri, String localName, String qName) {
        return true;
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        this.updateColSpans(uri, localName, qName, attributes, dataCache, ktb);
    }
}

