/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;

public final class MergeBlocks
extends SortedCellBlockArray {
    private static final long serialVersionUID = -8407115264331565405L;
    private Sheet _sheet;

    public MergeBlocks(Sheet sheet) {
        this._sheet = sheet;
    }

    @Override
    public Object insert(Object obj) {
        CellBlock cb = (CellBlock)obj;
        if (!cb.isSingleCell() && !this.contains(cb)) {
            boolean checked;
            SortedCellBlockArray touchedBlocks = this.getTouchedBlocks(cb);
            if (touchedBlocks == null) {
                checked = true;
            } else {
                SortedCellBlockArray containedBlocks = this.getContainedBlocks(cb);
                boolean bl = checked = containedBlocks != null && containedBlocks.size() == touchedBlocks.size();
            }
            if (checked) {
                if (touchedBlocks != null) {
                    for (int i = touchedBlocks.size() - 1; i >= 0; --i) {
                        this.remove(touchedBlocks.getBlock(i));
                    }
                }
                Object old = super.insert(cb);
                this._sheet.getFirstCell(cb, true).setMerged(true);
                return old;
            }
        }
        return null;
    }

    @Override
    public CellBlock remove(CellBlock cb) {
        return (CellBlock)this.removeByPos(this.search(cb));
    }

    @Override
    public Object removeByPos(int pos) {
        Cell cll;
        Object obj = super.removeByPos(pos);
        if (obj != null && (cll = this._sheet.getFirstCell((CellBlock)obj, false)) != null) {
            cll.setMerged(false);
        }
        return obj;
    }

    public void remove(SortedCellBlockArray mergeBlocks) {
        if (mergeBlocks == null) {
            return;
        }
        for (int i = mergeBlocks.size() - 1; i >= 0; --i) {
            this.remove(mergeBlocks.getBlock(i));
        }
    }

    public boolean isMerged(CellBlock cb) {
        CellBlock mb = this.searchBlock(cb.getRow(), cb.getCol());
        return mb != null && mb == this.searchBlock(cb.getRow2(), cb.getCol2());
    }

    public boolean isExactMerged(CellBlock cb) {
        CellBlock mb = this.searchBlock(cb.getRow(), cb.getCol());
        return mb != null && mb.equals(cb);
    }

    public CellBlock calActualBlock(CellBlock block) {
        SortedCellBlockArray limBlocks;
        while ((limBlocks = this.getTouchedBlocks(block)) != null) {
            CellBlock bounds = limBlocks.getBounds();
            if (block.contains(bounds)) {
                return block;
            }
            block.union(bounds);
        }
        return block;
    }

    public SortedCellBlockArray insdel(CellBlock block, boolean bInsert, boolean yDir) {
        if (this.size() == 0) {
            return null;
        }
        SortedCellBlockArray breaks = new SortedCellBlockArray();
        SortedCellBlockArray changes = new SortedCellBlockArray();
        for (int i = this.size() - 1; i >= 0; --i) {
            CellBlock cb = this.getBlock(i);
            if (!block.isImpact(cb, yDir)) continue;
            breaks.insert(this.removeByPos(i));
            CellBlock changedCB = block.getImpactBlock(cb, yDir, bInsert);
            if (changedCB == null) continue;
            changes.insert(changedCB);
        }
        this.insertAll(changes);
        if (breaks.size() == 0) {
            breaks = null;
        }
        return breaks;
    }
}

