/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction;
import com.kingdee.bos.ctrl.excel.model.struct.URState;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormatList;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.Condition;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import java.util.ArrayList;
import java.util.List;

public class SheetAction_InsertConditionalFormat
extends SheetAction {
    private Condition[] conditions;
    private ShareStyleAttributes[] styles;
    private static final String STATE_KEY = "_conditionalformats";
    private RedoImpl redoImpl = new RedoImpl();

    public SheetAction_InsertConditionalFormat(Range r, Condition[] cs, ShareStyleAttributes[] ss) {
        super(r, SheetChangeEvent.Changed_Conditionalformat_Insert);
        this.conditions = cs;
        this.styles = ss;
    }

    public static String getURStateKey(Sheet sheet) {
        return sheet.getSheetName() + STATE_KEY;
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        this.redoImpl.actionBlock(state, sheet, cb);
        SortedCellBlockArray array = new SortedCellBlockArray();
        array.insert(cb);
        sheet.getConditionalFormats().insertConditionalFormat(this.conditions, this.styles, array);
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        this.redoImpl.resumeBlock(state, sheet, cb);
    }

    public class RedoImpl {
        public void actionBlock(URState state, Sheet sheet, CellBlock cb) {
            ConditionalFormatList formats = sheet.getConditionalFormats();
            ArrayList<ConditionalFormat> list = new ArrayList<ConditionalFormat>();
            for (int i = 0; i < formats.size(); ++i) {
                list.add(formats.getConditionalFormat(i).cloneSelf());
            }
            SheetAction_InsertConditionalFormat.this.URStore(state, SheetAction_InsertConditionalFormat.getURStateKey(sheet), list);
        }

        public void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
            List sheetConditionalFormats = (List)state.get(SheetAction_InsertConditionalFormat.getURStateKey(sheet));
            if (null != sheetConditionalFormats) {
                ConditionalFormatList formats = sheet.getConditionalFormats();
                formats.clearAll();
                for (int i = 0; i < sheetConditionalFormats.size(); ++i) {
                    formats.addConditionalFormat((ConditionalFormat)sheetConditionalFormats.get(i));
                }
                sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_Conditionalformat_Reset);
            }
        }
    }
}

