/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction;
import com.kingdee.bos.ctrl.excel.model.struct.URState;
import com.kingdee.bos.ctrl.excel.model.struct.borders.Borders;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.struct.undo.AbstractUndoableEdit;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.ObjectCache;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;

public class SheetAction_Merge
extends SheetAction {
    public SheetAction_Merge(Range rg) {
        super(rg, SheetChangeEvent.Changed_Merge);
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        SortedCellBlockArray mergeBlocks;
        if (cb != null && cb.isSingleCell()) {
            return;
        }
        boolean bState = state != null;
        MergeBlocks merger = sheet.getMerger(false);
        SortedCellBlockArray sortedCellBlockArray = mergeBlocks = merger == null ? null : merger.getTouchedBlocks(cb);
        if (mergeBlocks != null) {
            merger.remove(mergeBlocks);
            sheet.clearStyleCache();
            for (int i = mergeBlocks.size() - 1; i >= 0; --i) {
                CellBlock block = mergeBlocks.getBlock(i);
                Cell cllMerger = sheet.getFirstCell(block, false);
                ShareStyleAttributes mergerSSA = cllMerger.getSSA();
                this.setCellState(state, cllMerger, mergerSSA, block);
            }
        } else {
            Cell mergerCell;
            StyleAttributes saOuterBorder = Styles.getEmptySA();
            this._rg.getStyle(sheet, cb, saOuterBorder, null, true);
            int row = cb.getRow();
            int row2 = cb.getRow2();
            int col = cb.getCol();
            int col2 = cb.getCol2();
            Cell lefttopCell = null;
            Sheet.RowsIterator ri = sheet.getRowsIterator(row, row2, true);
            if (ri.hasNext()) {
                ObjectArray delCells;
                Sheet.ICellsIterator ci = sheet.getCellsIterator(cb, false, true);
                if (ci.hasNext()) {
                    CellBlockNode cbLeftTop;
                    lefttopCell = ci.next();
                    int r = lefttopCell.getRow();
                    int c = lefttopCell.getCol();
                    if ((r != row || c != col) && (cbLeftTop = sheet.getBlockDeps().searchBlock(CellBlock.getNewCellBlock(r, c))) != null) {
                        if (bState) {
                            state.setData("REF_OFFSET", new Object[]{cbLeftTop, ObjectCache.getInteger((int)cbLeftTop.getRow()), ObjectCache.getInteger((int)cbLeftTop.getCol()), cbLeftTop.getRefs()});
                        }
                        sheet.getBlockDeps().moveBlock(cbLeftTop, row, col);
                    }
                } else {
                    Cell cll;
                    ci = sheet.getCellsIterator(cb, false, false);
                    if (ci.hasNext() && (cll = ci.next()).getRow() == row && cll.getCol() == col) {
                        lefttopCell = cll;
                    }
                }
                ObjectArray objectArray = delCells = bState ? (ObjectArray)state.getData("CELL_DELETED", ObjectArray.class, null) : null;
                while (ri.hasNext()) {
                    Row rowObj = ri.next();
                    Object[] clls = rowObj.remove(col, col2, false, bState);
                    if (!bState) continue;
                    delCells.appendAll(clls);
                }
            }
            if (lefttopCell != null) {
                mergerCell = (Cell)lefttopCell.clone();
                mergerCell.setColObject(this.getStateCol(state, sheet, col));
                this.getStateRow(state, sheet, row).insert(mergerCell);
            } else {
                mergerCell = this.getStateCell(state, sheet, row, col);
            }
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)mergerCell.getSSA());
            saOuterBorder.clearAttributes(ShareStyleAttributes.getBitsExceptOuterBorder());
            sa.append((ShareStyleAttributes)saOuterBorder, false);
            StyleAttributes bubbleSA = Cell.getBubbleSA(Styles.getEmptySSA(), sheet, row, col, null);
            sa.clearAttributes(sa.sameBits((ShareStyleAttributes)bubbleSA, 0, ShareStyleAttributes.BEFORE_BORDER));
            ShareStyleAttributes oldSSA = mergerCell.getSSA();
            if (mergerCell.setSSA(Styles.getSSA((StyleAttributes)sa)) && bState) {
                state.setData("CELL_SSA", oldSSA);
            }
            sheet.getMerger(true).insert(CellBlock.getNewCellBlock(cb));
            this.URStore(state, "CELL_OBJ", mergerCell);
            if (this.URStore(state, "BDR", sheet.getBorders().clearInner(cb, bState))) {
                sheet.clearStyleCache(cb);
            }
        }
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        MergeBlocks merger = sheet.getMerger(false);
        Borders bdrs = (Borders)state.get("BDR");
        if (bdrs != null) {
            Cell mergerCell = (Cell)state.get("CELL_OBJ");
            merger.remove(mergerCell.getMerge(false));
            Object[] depInfo = (Object[])state.get("REF_OFFSET");
            if (depInfo != null) {
                CellBlockNode block = (CellBlockNode)depInfo[0];
                int row = (Integer)depInfo[1];
                int col = (Integer)depInfo[2];
                block.setRowCol(row, col, row, col);
                block.setRefs(depInfo[3]);
                block.queue(true);
            }
            sheet.getBorders().set(bdrs);
            sheet.clearStyleCache(cb);
        } else {
            ObjectArray clls = (ObjectArray)state.get("CELL_OBJ");
            if (clls != null) {
                ObjectArray SSAs = (ObjectArray)state.get("CELL_VALUE");
                ObjectArray blocks = (ObjectArray)state.get("CELL_VALUE2");
                for (int i = clls.size() - 1; i >= 0; --i) {
                    CellBlock mb = (CellBlock)blocks.get(i);
                    merger.insert(mb);
                    Cell cllMerger = sheet.getFirstCell(mb, false);
                    cllMerger.setSSA((ShareStyleAttributes)SSAs.get(i));
                }
            }
        }
    }

    @Override
    public String getPresentationName() {
        return LanguageManager.getLangMessage((String)"merge", AbstractUndoableEdit.class, (String)"\u5408\u5e76\u5355\u5143\u683c ") + super.getPresentationName();
    }
}

