/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.embed.chart;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.embed.RectEmbedment;
import com.kingdee.bos.ctrl.excel.model.struct.embed.chart.ChartDataHelper;
import com.kingdee.bos.ctrl.excel.model.struct.embed.chart.ChartDataNode;
import com.kingdee.bos.ctrl.excel.model.struct.embed.chart.ChartModel;
import com.kingdee.bos.ctrl.excel.model.struct.embed.chart.ChartRenderData;
import com.kingdee.bos.ctrl.excel.util.KDSDataInputStream;
import com.kingdee.bos.ctrl.excel.util.KDSDataOutputStream;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jfree.chart.JFreeChart;

public class Chart
extends RectEmbedment {
    static final byte ID_End = 0;
    static final byte ID_ChartType = 1;
    static final byte ID_Data = 2;
    static final byte ID_GroupKeys = 3;
    static final byte ID_ChartTitle = 5;
    static final byte ID_CategoryAxisTitle = 6;
    static final byte ID_ValueAxisTitle = 7;
    static final byte ID_Angle = 8;
    private static final byte ID_SerialKeys = 9;
    private static final byte ID_ValueFormat = 10;
    private static final byte ID_SerialByCol = 11;
    private JFreeChart chart;
    private ChartModel model;

    public Chart(Sheet sheet, ChartModel modal) {
        super(sheet);
        this.model = modal;
    }

    public Chart(Sheet sheet) {
        this(sheet, null);
    }

    public void setChartTitle(String title) {
        this.model.setChartTitle(title);
    }

    public String getChartTitle() {
        return this.model.getChartTitle();
    }

    public void setJFreeChart(JFreeChart chart) {
        this.chart = chart;
    }

    public JFreeChart getJFreeChart() {
        return this.chart;
    }

    public void setCategoryAxisTitle(String title) {
        this.model.setCategoryAxisTitle(title);
    }

    public String getCategoryAxisTitle() {
        return this.model.getCategoryAxisTitle();
    }

    public void setValueAxisTitle(String title) {
        this.model.setValueAxisTitle(title);
    }

    public String getValueAxisTitle() {
        return this.model.getValueAxisTitle();
    }

    public void setGroupsKeys(String[] keys) {
        if (keys == null) {
            this.model.setGroupsKeys(null);
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < keys.length; ++i) {
            list.add(keys[i]);
        }
        this.model.setGroupsKeys(list);
    }

    public ArrayList getGroupsKeys() {
        return this.model.getGroupsKeys();
    }

    public void setCategoryLabelPositions(int angle) {
        this.model.setAngle(angle);
    }

    public int getCategoryLabelPositions() {
        return this.model.getAngle();
    }

    public void setChartRange(ChartDataNode cr) {
        this.model.setRange(cr);
    }

    public ChartDataNode getChartRange() {
        return this.model.getDataNode();
    }

    public void setChartType(ChartType chartType) {
        this.model.setChartType(chartType);
    }

    public ChartType getChartType() {
        return this.model.getChartType();
    }

    public ChartRenderData getChartRenderData() {
        return this.model.getChartData();
    }

    @Override
    public void paintData(Graphics g) {
        if (this.model.isChange()) {
            this.chart = null;
        }
        if (this.chart == null) {
            this.chart = ChartDataHelper.createChart(this.model);
        }
        Rectangle2D.Double chartArea = new Rectangle2D.Double();
        ((Rectangle2D)chartArea).setRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.chart.draw((Graphics2D)g, (Rectangle2D)chartArea, (Point2D)new Point2D.Double(0.0, 0.0), null);
    }

    @Override
    public void paintFocus(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle bounds = this.getBounds();
        int x = (int)((RectangularShape)bounds).getX();
        int y = (int)((RectangularShape)bounds).getY();
        int w = (int)((RectangularShape)bounds).getWidth();
        int h = (int)((RectangularShape)bounds).getHeight();
        int outArc = 12;
        int innerArc = 18;
        int distance = 6;
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double();
        ((RoundRectangle2D)rr).setRoundRect(x - distance, y - distance, w + 2 * distance, h + 2 * distance, w > outArc * 2 ? (double)outArc : (double)(w / 2), h > outArc * 2 ? (double)outArc : (double)(h / 2));
        RoundRectangle2D.Double innerRR = new RoundRectangle2D.Double();
        ((RoundRectangle2D)innerRR).setRoundRect(x, y, w, h, w > innerArc * 2 ? (double)innerArc : (double)(w / 2), h > innerArc * 2 ? (double)innerArc : (double)(h / 2));
        Graphics2D g2dd = (Graphics2D)g2d.create();
        Area area = new Area(rr);
        area.subtract(new Area(innerRR));
        g2dd.setColor(Color.gray);
        g2dd.draw(rr);
        Composite cps = g2d.getComposite();
        g2dd.setComposite(AlphaComposite.getInstance(3, 0.2f));
        g2dd.setColor(Color.cyan);
        g2dd.fill(area);
        g2dd.setComposite(cps);
        g2dd.setColor(Color.black);
        int ptDistance = distance / 2;
        int ptx = x - ptDistance;
        int pty = y - ptDistance;
        int ptx2 = x + w - 1 + ptDistance;
        int pty2 = y + h - 1 + ptDistance;
        g2dd.drawOval(ptx, pty, 1, 1);
        g2dd.drawOval(ptx + ++ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx, pty + ptDistance, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 - ptDistance, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + ptDistance, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + 2 * ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx2, pty, 1, 1);
        g2dd.drawOval(ptx2 - ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx2, pty + ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 + ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 + 2 * ptDistance, 1, 1);
        g2dd.drawOval(ptx2, pty2, 1, 1);
        g2dd.drawOval(ptx2 - ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx2, pty2 - ptDistance, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 - ptDistance, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + ptDistance, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + 2 * ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx, pty2, 1, 1);
        g2dd.drawOval(ptx + ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx, pty2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 + ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 + 2 * ptDistance, 1, 1);
    }

    @Override
    protected void loadCustom(byte[] str) {
        try {
            KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
            this.model = new ChartModel();
            String ver = is.readString();
            if (ver.equals("1.0")) {
                this.model.setChartTitle(is.readString());
                this.model.setCategoryAxisTitle(is.readString());
                this.model.setValueAxisTitle(is.readString());
                this.model.setChartType(ChartType.getChartType((String)is.readString()));
                this.model.setRange(new ChartDataNode(this._sheet, Sheet.getArrayBlockNodes(this._sheet, is.readString(), true)));
            } else {
                byte id;
                block14: while ((id = is.readByte()) != 0) {
                    switch (id) {
                        case 1: {
                            this.model.setChartType(ChartType.getChartType((String)is.readString()));
                            continue block14;
                        }
                        case 2: {
                            this.model.setRange(new ChartDataNode(this._sheet, Sheet.getArrayBlockNodes(this._sheet, is.readString(), true)));
                            continue block14;
                        }
                        case 3: {
                            this.model.setGroupsKeys(new ArrayList<String>(Arrays.asList(is.readString().split(","))));
                            continue block14;
                        }
                        case 5: {
                            this.model.setChartTitle(is.readString());
                            continue block14;
                        }
                        case 6: {
                            this.model.setCategoryAxisTitle(is.readString());
                            continue block14;
                        }
                        case 7: {
                            this.model.setValueAxisTitle(is.readString());
                            continue block14;
                        }
                        case 8: {
                            this.model.setAngle(is.readInt());
                            continue block14;
                        }
                        case 10: {
                            this.model.setValueNumberFormatStr(is.readString());
                            continue block14;
                        }
                        case 9: {
                            this.model.setSerialKeys(new ArrayList<String>(Arrays.asList(is.readString().split(","))));
                            continue block14;
                        }
                        case 11: {
                            this.model.setSerialByCol(is.readBoolean());
                            continue block14;
                        }
                    }
                }
            }
            is.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    protected byte[] saveCustom() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        try {
            int i;
            AbstractStringBuilder sb;
            List<Object> list;
            out.writeString("1.1");
            String str = this.model.getChartType().getName();
            if (!StringUtil.isEmptyString((String)str)) {
                out.writeByte(1);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = Sheet.getBlocksA1Name(this.model.getDataNode().getRange(), false)))) {
                out.writeByte(2);
                out.writeString(str);
            }
            if (this.model.getGroupsKeys() != null) {
                list = this.model.getGroupsKeys();
                sb = new StringBuffer();
                for (i = 0; i < ((ArrayList)list).size(); ++i) {
                    if (i != 0) {
                        ((StringBuffer)sb).append(",");
                    }
                    ((StringBuffer)sb).append(((ArrayList)list).get(i));
                }
                out.writeByte(3);
                out.writeString(((StringBuffer)sb).toString());
            }
            if (!StringUtil.isEmptyString((String)(str = this.model.getChartTitle()))) {
                out.writeByte(5);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = this.model.getCategoryAxisTitle()))) {
                out.writeByte(6);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = this.model.getValueAxisTitle()))) {
                out.writeByte(7);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = this.model.getValueNumberFormatStr()))) {
                out.writeByte(10);
                out.writeString(str);
            }
            if (null != this.model.getSerialKeys()) {
                list = this.model.getSerialKeys();
                sb = new StringBuilder();
                for (i = 0; i < list.size(); ++i) {
                    if (i != 0) {
                        ((StringBuilder)sb).append(",");
                    }
                    ((StringBuilder)sb).append((String)list.get(i));
                }
                out.writeByte(9);
                out.writeString(((StringBuilder)sb).toString());
            }
            out.writeByte(8);
            out.writeInt(this.model.getAngle());
            out.writeByte(11);
            out.writeBoolean(this.model.isSerialByCol());
            out.writeByte(0);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bs.toByteArray();
    }

    public ChartModel getModel() {
        return this.model;
    }

    public void setSerialByCol(boolean serialByCol) {
        this.model.setSerialByCol(serialByCol);
    }

    public void setSerialKeys(List<String> keys) {
        this.model.setSerialKeys(keys);
    }

    public void setValueFormat(String str) {
        this.model.setValueNumberFormatStr(str);
    }
}

