/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.util.profile;

import com.kingdee.bos.ctrl.excel.model.util.profile.IObjectProfileNode;
import com.kingdee.bos.ctrl.excel.model.util.profile.ObjectProfileVisitors;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;

abstract class AbstractProfileNode
implements IObjectProfileNode,
Comparable {
    int m_size;
    static final IObjectProfileNode[] EMPTY_OBJECTPROFILENODE_ARRAY = new IObjectProfileNode[0];
    private final IObjectProfileNode m_parent;
    private transient IObjectProfileNode[] m_path;

    @Override
    public final int size() {
        return this.m_size;
    }

    @Override
    public final IObjectProfileNode parent() {
        return this.m_parent;
    }

    @Override
    public final IObjectProfileNode[] path() {
        IObjectProfileNode[] path = this.m_path;
        if (path != null) {
            return path;
        }
        LinkedList<AbstractProfileNode> _path = new LinkedList<AbstractProfileNode>();
        for (IObjectProfileNode node = this; node != null; node = node.parent()) {
            _path.addFirst((AbstractProfileNode)node);
        }
        path = new IObjectProfileNode[_path.size()];
        _path.toArray(path);
        this.m_path = path;
        return path;
    }

    @Override
    public final IObjectProfileNode root() {
        IObjectProfileNode node = this;
        for (IObjectProfileNode parent = this.parent(); parent != null; parent = parent.parent()) {
            node = parent;
        }
        return node;
    }

    @Override
    public final int pathlength() {
        IObjectProfileNode[] path = this.m_path;
        if (path != null) {
            return path.length;
        }
        int result = 0;
        for (IObjectProfileNode node = this; node != null; node = node.parent()) {
            ++result;
        }
        return result;
    }

    @Override
    public final String dump() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        IObjectProfileNode.INodeVisitor visitor = ObjectProfileVisitors.newDefaultNodePrinter(out, null, null, false);
        this.traverse(null, visitor);
        out.flush();
        return sw.toString();
    }

    public final int compareTo(Object obj) {
        return ((AbstractProfileNode)obj).m_size - this.m_size;
    }

    public String toString() {
        return super.toString() + ": name = " + this.name() + ", size = " + this.size();
    }

    AbstractProfileNode(IObjectProfileNode parent) {
        this.m_parent = parent;
    }
}

