/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.bim.reportimpl.table;

import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.report.forapp.bim.tabledesigner.DesignerSaveEvent;
import com.kingdee.bos.ctrl.report.forapp.bim.tabledesigner.DesignerSaveListener;
import com.kingdee.bos.ctrl.report.forapp.bim.tabledesigner.KDTDesignerFrame;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.IDataSourceFactory;
import com.kingdee.bos.ctrl.reportone.data.meta.ui.MetaClassSelectTree;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyOpenedException;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.UnsupportedStorageException;
import com.kingdee.bos.ctrl.reportone.reportframework.design.AReportDesigner;
import com.kingdee.bos.ctrl.reportone.reportimpl.ImplResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class KDTableRptDesigner
extends AReportDesigner {
    private static final Logger log = LogUtil.getPackageLogger(KDTableRptDesigner.class);
    private KDTDesignerFrame editor;

    public KDTableRptDesigner(Component owner) {
        super(owner);
    }

    public void design(boolean isNew, HashMap params) throws ReportException {
        if (this.editor != null) {
            throw new AlreadyOpenedException();
        }
        IReportStorage rptSto = this.getReportEnv().getReportStorage();
        if (!(rptSto instanceof IStreamStorage)) {
            throw new UnsupportedStorageException();
        }
        InputStream tpl = null;
        if (!isNew) {
            try {
                tpl = ((IStreamStorage)rptSto).getInputStream();
            }
            catch (ReportException ex) {
                throw ReportException.makeException((Throwable)ex);
            }
        }
        this.editor = new KDTDesignerFrame();
        this.editor.setTitle(ImplResource.getString((String)"res_30"));
        this.editor.setSize(800, 600);
        this.editor.addDesignerSaveListener(new SaveListener());
        MetaClass mc = (MetaClass)params.get(ReportUtil.ARG_META_CLASS);
        if (mc != null) {
            this.editor.setSchemes(new MetaClass[]{mc});
        } else {
            this.editor.getToolBar().add((Action)new DataWizardAction());
        }
        if (!isNew) {
            this.editor.setStream(tpl);
        } else if (mc != null) {
            this.editor.addColumns(new MetaClass[]{mc});
        }
        this.editor.setDefaultCloseOperation(2);
        this.editor.addWindowListener((WindowListener)new AReportDesigner.WindowEventHandler((AReportDesigner)this));
        this.editor.show();
    }

    public void close() throws ReportException {
        this.editor.dispose();
        this.editor = null;
    }

    public Component getComponent() throws ReportException {
        return this.editor;
    }

    private class SaveListener
    implements DesignerSaveListener {
        private SaveListener() {
        }

        @Override
        public void savePerformed(DesignerSaveEvent e) {
            log.debug((Object)"Save KDTable template ...");
            try {
                KDTableRptDesigner.this.editor.getStream(((IStreamStorage)KDTableRptDesigner.this.getReportEnv().getReportStorage()).getOutputStream());
            }
            catch (ReportException ex) {
                String msg = ImplResource.getString((String)"res_21");
                log.error((Object)msg, (Throwable)ex);
                WindowUtil.showException((String)msg, (Throwable)ex, (String)ImplResource.getString((String)"res_22"), (Component)((Object)KDTableRptDesigner.this.editor));
                return;
            }
            KDTableRptDesigner.this.fireSaveCompleted();
            WindowUtil.msgboxInfo((Object)ImplResource.getString((String)"res_23"), (String)ImplResource.getString((String)"res_22"), (Component)((Object)KDTableRptDesigner.this.editor));
        }
    }

    private class DataWizardAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public DataWizardAction() {
            this.putValue("Name", ImplResource.getString((String)"res_27"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MetaClassSelectTree xdataProvider;
            log.debug((Object)"Data Wizard ...");
            try {
                xdataProvider = ReportUtil.makeMetaClassSelectTree((IDataSourceFactory)KDTableRptDesigner.this.getReportEnv().getDSFactory());
            }
            catch (ReportException ex) {
                log.error((Object)ImplResource.getString((String)"res_28"), (Throwable)ex);
                return;
            }
            SimpleDialog dlg = (SimpleDialog)WindowUtil.createWindow(SimpleDialog.class, (Component)((Object)KDTableRptDesigner.this.editor));
            dlg.setTitle(ImplResource.getString((String)"res_29"));
            dlg.setComponent((Component)xdataProvider.getUI());
            if (dlg.showDialog()) {
                String infoText = xdataProvider.getSelectedInfo();
                MetaClass mc = (MetaClass)xdataProvider.getObject(infoText);
                MetaClass mcNew = new MetaClass();
                mcNew.copy((IDefObj)mc);
                mcNew.setExpr(infoText);
                mcNew.setFields(mc.getFields());
                MetaClass[] mcs = new MetaClass[]{mcNew};
                KDTableRptDesigner.this.editor.setSchemes(mcs);
                KDTableRptDesigner.this.editor.addColumns(mcs);
            }
        }
    }
}

