/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDefs;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.restree.ItemsHelper;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTreeCtrl;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions.superman.ActionAddDistribution;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions.superman.ActionAddRoleUse;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions.superman.ActionAddUse;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions.superman.ActionDelDistribution;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions.superman.ActionDelRoleUse;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions.superman.ActionDelUse;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IContextSupplier;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JToolBar;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class NoteManageView
extends TypicalDialog
implements TreeSelectionListener {
    static final int SUPERMAN = 0;
    static final int HUMAN = 1;
    protected NoteTreeCtrl _tree;
    protected KDToolBar _toolBar;
    private boolean _isSupermanMode = true;
    private ActionAddDistribution _actionAddDistribution;
    private ActionDelDistribution _actionDelDistribution;
    private ActionAddUse _actionAddUse;
    private ActionDelUse _actionDelUse;
    private ActionAddRoleUse _actionAddRoleUse;
    private ActionDelRoleUse _actionDelRoleUse;
    private ResTypeDefs _typeDefs;

    public NoteManageView() {
    }

    public NoteManageView(Dialog owner) {
        super(owner);
    }

    public NoteManageView(Frame owner) {
        super(owner);
    }

    public void setContext(IBizContext bizCtx, IBizContent bizContent, IBizStorage localStorage) throws KDRSException {
        this.createTreeCtrl(bizCtx, bizContent, localStorage);
    }

    protected void createTreeCtrl(final IBizContext bizCtx, IBizContent bizContent, IBizStorage localStorage) throws KDRSException {
        IContextSupplier supplier = new IContextSupplier(){

            public IBizContext getContext() {
                return bizCtx;
            }
        };
        this._tree = new NoteTreeCtrl(this._typeDefs, supplier, localStorage, true);
        this._tree.setSupermanMode(this._isSupermanMode);
        this._tree.setRelativeRoot("/EAS_Note.kdrs");
        this._tree.setShowOrgFilterStatus(true);
        TreeUI ui = this._tree.getTreeUI();
        ui.setRealtimeSelect(true);
        ui.addTreeSelectionListener((TreeSelectionListener)this);
        this._tree.getTreeUI().setSelectionPathText("/");
        this._tree.getTreeUI().expandRoot();
        if (this._isSupermanMode) {
            this._actionAddDistribution = new ActionAddDistribution();
            this._actionDelDistribution = new ActionDelDistribution();
            this._actionAddUse = new ActionAddUse();
            this._actionDelUse = new ActionDelUse();
            this._actionAddRoleUse = new ActionAddRoleUse();
            this._actionDelRoleUse = new ActionDelRoleUse();
            this._actionAddDistribution.setNoteTreeCtrl(this._tree);
            this._actionDelDistribution.setNoteTreeCtrl(this._tree);
            this._actionAddUse.setNoteTreeCtrl(this._tree);
            this._actionDelUse.setNoteTreeCtrl(this._tree);
            this._actionAddRoleUse.setNoteTreeCtrl(this._tree);
            this._actionDelRoleUse.setNoteTreeCtrl(this._tree);
            KDToolBar supermanToolBar = new KDToolBar();
            supermanToolBar.add((Component)new KDWorkButton((Action)this._actionAddDistribution));
            supermanToolBar.add((Component)new KDWorkButton((Action)this._actionDelDistribution));
            supermanToolBar.addSeparator();
            supermanToolBar.add((Component)new KDWorkButton((Action)this._actionAddUse));
            supermanToolBar.add((Component)new KDWorkButton((Action)this._actionDelUse));
            supermanToolBar.addSeparator();
            supermanToolBar.add((Component)new KDWorkButton((Action)this._actionAddRoleUse));
            supermanToolBar.add((Component)new KDWorkButton((Action)this._actionDelRoleUse));
            this.addToolBar((JToolBar)supermanToolBar);
        }
    }

    protected void todoInit() {
        this._toolBar = new KDToolBar();
        this._toolBar.setTextIconDisStyle((short)2);
        this._toolBar.setIsControlByParent(false);
        this._toolBar.setPopupMenuShowable(false);
        this.addToolBar((JToolBar)this._toolBar);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        if (this._tree == null) {
            throw new RuntimeException("Use setBizContent to create tree before show dialog.");
        }
        parent.add((Component)this._tree.getTreeUI(), thisCell);
        parent.remove((Component)this.btnCancel);
        this.btnOk.setText(MultiLanguageUtil.getMLS("client.NoteManageView.closeManager"));
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this._toolBar.removeAllToolBarComponents();
        ArrayList menuItems = this._tree.getPopMenuActions();
        Iterator i = menuItems.iterator();
        while (i.hasNext()) {
            ItemsHelper.addAction((KDToolBar)this._toolBar, i.next());
        }
        Container c = this._toolBar.getParent();
        if (c != null) {
            c.validate();
            c.repaint();
        }
    }

    void setMenuConfig(ResTypeDefs typeDefs) {
        this._typeDefs = typeDefs;
    }

    public void setSupermanMode(boolean isSupermanMode) {
        this._isSupermanMode = isSupermanMode;
    }
}

