/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.restree.AbstractResActionHandler;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.server.publishedcheck.IPublishedCheckService;
import com.kingdee.bos.ctrl.report.forapp.kdnote.server.publishedcheck.PublishedCheckService;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.SwingUtilities;

public class ActionCheckPublished
extends AbstractResActionHandler {
    protected boolean onAction() throws Exception {
        PromptUI ui = new PromptUI((Component)this.getTree());
        CheckRunnable checkRunnable = new CheckRunnable();
        checkRunnable.setAssociateUI(ui);
        new Thread(checkRunnable).start();
        ui.showDialog();
        return true;
    }

    private IPublishedCheckService createRemoteObject() throws KDRSException {
        String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
        try {
            return (IPublishedCheckService)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)PublishedCheckService.class.getName(), IPublishedCheckService.class);
        }
        catch (BOSException ex) {
            throw KDRSException.makeException((Throwable)ex);
        }
    }

    private class CheckRunnable
    implements Runnable {
        private PromptUI _ui;

        private CheckRunnable() {
        }

        public void setAssociateUI(PromptUI ui) {
            this._ui = ui;
        }

        @Override
        public void run() {
            String path = ActionCheckPublished.this.getPathText();
            path = path.substring("/EAS_Note.kdrs".length());
            IPublishedCheckService service = null;
            try {
                service = ActionCheckPublished.this.createRemoteObject();
            }
            catch (KDRSException e) {
                this._ui.setPromptResult(e.toString());
                return;
            }
            final Map result = service.check(path);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (result == null) {
                        CheckRunnable.this._ui.setPromptResult("OK!");
                    } else {
                        StringBuffer sbWarning;
                        StringBuffer sbError = (StringBuffer)result.get("error");
                        StringBuffer sb = new StringBuffer();
                        if (sbError.length() > 0) {
                            sb.append(MultiLanguageUtil.getMLS("actions.ActionCheckPublished.error"));
                            sb.append(StringUtil.RETURN);
                            sb.append(sbError.toString());
                            sb.append(StringUtil.RETURN);
                        }
                        if ((sbWarning = (StringBuffer)result.get("warning")).length() > 0) {
                            sb.append(MultiLanguageUtil.getMLS("actions.ActionCheckPublished.warning"));
                            sb.append(StringUtil.RETURN);
                            sb.append(sbWarning.toString());
                        }
                        CheckRunnable.this._ui.setPromptResult(sb.toString());
                    }
                }
            });
        }
    }

    private static class PromptUI {
        private KDTextArea _txaPrompt = new KDTextArea(MultiLanguageUtil.getMLS("actions.ActionCheckPublished.waiting"));
        private KDProgressBar _progressBar;
        private SimpleDialog _dlg;

        public PromptUI(Component owner) {
            this._txaPrompt.setEditable(false);
            this._progressBar = new KDProgressBar();
            this._progressBar.setIndeterminate(true);
            TableLayout tl = TableLayout.split((int)2, (int)1);
            tl.rowStyle(1).setMarginTop(6);
            tl.rowStyle(1).setPriY(1);
            Table row1 = tl.cell(0).splitCol(2);
            row1.colStyle(1).setMarginLeft(20);
            row1.colStyle(1).setPriX(1);
            KDPanel panAll = new KDPanel((LayoutManager)tl);
            panAll.add((Component)new KDLabel(MultiLanguageUtil.getMLS("actions.ActionCheckPublished.checkResult")), (Object)row1.cell(0));
            panAll.add((Component)this._progressBar, (Object)row1.cell(1));
            panAll.add((Component)new KDScrollPane((Component)this._txaPrompt), (Object)tl.cell(1));
            this._dlg = SimpleDialog.create((Component)owner);
            this._dlg.setComponent((Component)panAll);
            this._dlg.setTitle(MultiLanguageUtil.getMLS("actions.ActionCheckPublished.title"));
            this._dlg.hideCancelButton();
        }

        public void showDialog() {
            this._dlg.showDialog();
        }

        public void setPromptResult(String text) {
            if (this._dlg.isVisible()) {
                this._txaPrompt.setText(text);
                this._progressBar.setVisible(false);
            }
        }
    }
}

