/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions;

import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTreeCtrl;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteUserConfig;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDistributionUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.actions.ActionListContentFolder;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.listener.NoteTreeEvent;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.listener.TemplateTreeListener;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.actions.ActionListFolder;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import java.awt.Color;
import java.util.Comparator;
import java.util.HashMap;

public class ActionListContentNoteFolder
extends ActionListContentFolder {
    private boolean isNoteTemplate = false;
    protected String defaultTemplateName;
    private Comparator sortedListComparator;

    protected String getResType(String[] typeValues) {
        String type = super.getResType(typeValues);
        NoteTreeCtrl ctrl = (NoteTreeCtrl)super.getTreeController();
        if (!("folder".equals(type) || "kdrs-form".equals(type) || "r1-print".equals(type) || ctrl.isManageMode())) {
            type = null;
        }
        if (!ctrl.isShowLeaf() && !"folder".equals(type)) {
            type = null;
        }
        this.isNoteTemplate = "kdrs-form".equals(type) || "r1-print".equals(type);
        return type;
    }

    public boolean onAction() throws Exception {
        NoteTreeCtrl ctrl = (NoteTreeCtrl)super.getTreeController();
        String pathText = super.getPathText();
        this.defaultTemplateName = null;
        if (!ctrl.isManageMode() && ctrl.getLocalStorage() != null) {
            NoteUserConfig config = NoteUserConfig.load(ctrl.getLocalStorage(), pathText);
            String company = NoteUtil.getCurrentOrgUnitId();
            String user = NoteUtil.getUser();
            this.defaultTemplateName = NoteUtil.getDefaultTemplate(config, company, user);
            if (null != this.defaultTemplateName) {
                TemplateTreeListener.getListener((ResObjectNode)this.getResNode()).setDefaultTemplateName(this.defaultTemplateName);
            }
        }
        return super.onAction();
    }

    protected void processNode(TreeUINode node, HashMap attrs) {
        if (StringUtil.equals((String)node.getName(), (String)this.defaultTemplateName)) {
            node.setChecked(true);
        }
        NoteTreeEvent event = new NoteTreeEvent(this.getResNode(), (Object)node, 0);
        TemplateTreeListener.getListener((ResObjectNode)this.getResNode()).fireEvent(event);
        NoteTreeCtrl ctrl = (NoteTreeCtrl)super.getTreeController();
        String relationOrgs = (String)attrs.get("eas_template_relation_orgs");
        if (ctrl.isShowOrgFilterStatus() && this.checkOrgRelation(relationOrgs)) {
            node.setExtText(MultiLanguageUtil.getMLS("actions.ActionListContentNoteFolder.extText"));
        }
        if (!(ctrl.isSupermanMode() || NoteDistributionUtil.isDistributed(attrs) || node.getAllowsChildren())) {
            node.setTextColor(Color.LIGHT_GRAY);
        }
    }

    private boolean checkOrgRelation(String relationOrgs) {
        if (relationOrgs == null) {
            return false;
        }
        return relationOrgs.indexOf(NoteUtil.getCurrentOrgUnitId()) != -1;
    }

    protected HashMap getListAttrKeys() throws Exception {
        HashMap attrKeys = super.getListAttrKeys();
        attrKeys.put("eas_template_relation_orgs", null);
        attrKeys.put("write_enabled_users", null);
        return attrKeys;
    }

    protected boolean peek(String pathText, HashMap attrs) {
        String absPathText;
        NoteTreeCtrl ctrl = (NoteTreeCtrl)super.getTreeController();
        if (StringUtil.isEmptyString((String)ctrl.getPathTextToShow())) {
            return true;
        }
        if (this.isNoteTemplate && ctrl.isUseTemplateOrgFilter()) {
            String relationOrgs = (String)attrs.get("eas_template_relation_orgs");
            if (relationOrgs == null) {
                return false;
            }
            if (relationOrgs.indexOf(NoteUtil.getCurrentOrgUnitId()) == -1) {
                return false;
            }
        }
        if (pathText.equals(absPathText = PathUtil.makeChildPath((String)ctrl.getRelativeRoot(), (String)ctrl.getPathTextToShow()))) {
            return true;
        }
        Path pathToShow = Path.valueOf((String)absPathText);
        Path currentPath = Path.valueOf((String)pathText);
        if (currentPath.isFatherOf(pathToShow, false)) {
            return true;
        }
        return pathToShow.isFatherOf(currentPath, false);
    }

    protected Comparator getSortedListComparator() {
        if (this.sortedListComparator == null) {
            this.sortedListComparator = new CustomComparator();
        }
        return this.sortedListComparator;
    }

    private static class CustomComparator
    extends ActionListFolder.ContentComparator {
        private CustomComparator() {
            super(new Object[]{"folder", "bos-query", "note-dynquery", "r1-print", "kdrs-form"});
        }
    }
}

