/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDef;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.AbstractResActionHandler;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTreeCtrl;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.multilanguage.Language;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ActionMultiLanguageFiltrate
extends AbstractResActionHandler {
    private static final Logger log = LogUtil.getPackageLogger(ActionMultiLanguageFiltrate.class);
    private static ArrayList lang = new ArrayList();

    protected boolean onAction() throws Exception {
        NoteTreeCtrl ntc = (NoteTreeCtrl)this.getTreeController();
        ResObjectNode resNode = this.getResNode();
        CustomUI ui = new CustomUI(ntc.getMultilanguages(), resNode);
        SimpleDialog dialog = SimpleDialog.create((Component)this.getTreeUI());
        dialog.setTitle(MultiLanguageUtil.getMLS("actions.ActionMultiLanguageFiltrate.title"));
        dialog.setComponent((Component)((Object)ui));
        dialog.setSize(new Dimension(280, 210));
        if (dialog.showDialog()) {
            ntc.setMultiLanguages(lang.toArray(new Language[1]));
            this.setResNode((ResObjectNode)ntc.getTopNode());
            this.forward("list");
            TreeUINode parent = ntc.getTopNode();
            TreeNode[] tn = resNode.getPath();
            for (int i = 0; i < tn.length; ++i) {
                TreeUINode child = parent.getChildNode(((TreeUINode)tn[i]).getName());
                if (child == null) {
                    this.getTreeUI().setSelectionNode(parent);
                    log.info((Object)(tn[i].toString() + MultiLanguageUtil.getMLS("actions.ActionMultiLanguageFiltrate.childNodeNotFound")));
                    return true;
                }
                this.getTreeUI().expand(new TreePath(child.getPath()));
                parent = child;
            }
            this.getTreeUI().setSelectionNode(parent);
            return true;
        }
        return false;
    }

    private static class CustomUI
    extends KDPanel
    implements SimpleDialog.PanelOfSimpleDialog {
        private KDCheckBox _chkZhCn = new KDCheckBox(Language.zh_CN.getAlias());
        private KDCheckBox _chkZhTw = new KDCheckBox(Language.zh_TW.getAlias());
        private KDCheckBox _chkEn = new KDCheckBox(Language.EN.getAlias());
        private ResObjectNode resNode;

        public CustomUI(Language[] languages, ResObjectNode resNode) {
            this.resNode = resNode;
            TableLayout2 layout = new TableLayout2(4, 1);
            layout.setRowsSpacing(TableLayout2.ALL, 3);
            layout.setFixedHeight(TableLayout2.ALL, 20);
            layout.setRatableHeight(3, 100);
            this.setLayout((LayoutManager)layout);
            this.add((Component)this._chkZhCn, TableLayout2.param((int)0, (int)0));
            this.add((Component)this._chkZhTw, TableLayout2.param((int)1, (int)0));
            this.add((Component)this._chkEn, TableLayout2.param((int)2, (int)0));
            this._chkZhCn.setSelected(false);
            this._chkZhTw.setSelected(false);
            this._chkEn.setSelected(false);
            for (int i = 0; i < languages.length; ++i) {
                if (Language.zh_CN.equal(languages[i])) {
                    this._chkZhCn.setSelected(true);
                }
                if (Language.zh_TW.equal(languages[i])) {
                    this._chkZhTw.setSelected(true);
                }
                if (!Language.EN.equal(languages[i])) continue;
                this._chkEn.setSelected(true);
            }
        }

        public boolean verify() {
            ResTypeDef category;
            lang = new ArrayList();
            if (this._chkZhCn.isSelected()) {
                lang.add(Language.zh_CN);
            }
            if (this._chkZhTw.isSelected()) {
                lang.add(Language.zh_TW);
            }
            if (this._chkEn.isSelected()) {
                lang.add(Language.EN);
            }
            if (lang.size() == 0) {
                WindowUtil.msgboxInfo((Object)MultiLanguageUtil.getMLS("actions.ActionMultiLanguageFiltrate.info"), (String)MultiLanguageUtil.getMLS("actions.ActionMultiLanguageFiltrate.title"), (Component)((Object)this));
                return false;
            }
            boolean isTempFiltrate = false;
            if (this.resNode.isLeaf() && "r1-print".equals((category = (ResTypeDef)this.resNode.getCategory()).getName()) && !lang.contains(Language.readTempLang(this.resNode.getName()))) {
                isTempFiltrate = true;
            }
            if (isTempFiltrate) {
                return WindowUtil.msgboxYesNo((Component)((Object)this), (Object)MultiLanguageUtil.getMLS("actions.ActionMultiLanguageFiltrate.yesNo"), (String)MultiLanguageUtil.getMLS("actions.ActionMultiLanguageFiltrate.title"));
            }
            return true;
        }
    }
}

