/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.util.KDPrintUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions.DirectPrintItemUI;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.param.util.ParamClientUtil;
import com.kingdee.eas.common.client.OprtState;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DirectPrintControlUI
extends CoreUIObject {
    private static final Logger logger = CoreUIObject.getLogger(DirectPrintControlUI.class);
    protected KDTable tblMain;
    private HashMap<String, String> cachedConfigValue = new HashMap();
    private static final String BILL_TYPE = "bill_type";
    private static final String PRINTER = "printer";
    private static final String IS_DIRECT_PRINT = "is_direct_print";

    public DirectPrintControlUI() throws Exception {
        this.jbInit();
        this.initUIP();
        this.fillTable();
    }

    private void jbInit() throws Exception {
        this.setUITitle(this.getSaveDialogTitle());
        this.tblMain = new KDTable();
        this.setName("DirectPrintControl");
        this.tblMain.setName("tblMain");
    }

    private String getSaveDialogTitle() {
        return MultiLanguageUtil.getMLS("actions.ActionDirectPrintControl.title");
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 556, 359));
        this.setLayout(null);
        this.tblMain.setBounds(new Rectangle(13, 13, 530, 334));
        this.add((Component)this.tblMain, null);
    }

    public boolean isPrepareInit() {
        return false;
    }

    protected void initUIP() {
        super.initUIP();
    }

    private void fillTable() {
        this.tblMain.setEditable(false);
        this.tblMain.setAutoResize(true);
        this.constructColumns();
        this.constructTitleRow();
        KDPrintUtil.getInstance();
        this.cachedConfigValue = KDPrintUtil.getCachedConfig();
        if (this.cachedConfigValue == null || this.cachedConfigValue.size() == 0) {
            return;
        }
        ShareStyleAttributes ssa = Styles.getEmptySSA();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    int currentRow = ParamClientUtil.getSelectedRow((KDTable)DirectPrintControlUI.this.tblMain);
                    if (currentRow == -1) {
                        return;
                    }
                    this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    DirectPrintControlUI.this.handUIException(exc);
                }
            }

            private void tblMain_tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    DirectPrintControlUI.this.showDirectPrintItemEditUI(DirectPrintControlUI.this.consItemFromRow());
                }
            }
        });
        for (Map.Entry<String, String> config : this.cachedConfigValue.entrySet()) {
            IRow row = this.tblMain.addRow();
            KDTCell billTypeCell = new KDTCell();
            billTypeCell.setValue((Object)config.getKey());
            row.getKDTRow().addCell(0, billTypeCell);
            billTypeCell.setFormattedSSA(ssa);
            billTypeCell.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa}));
            KDTCell printerCell = new KDTCell();
            printerCell.setValue((Object)config.getValue());
            row.getKDTRow().addCell(1, printerCell);
            printerCell.setFormattedSSA(ssa);
            printerCell.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa}));
            KDTCell isDorectPrintCell = new KDTCell();
            isDorectPrintCell.setValue((Object)MultiLanguageUtil.getMLS("actions.DirectPrintControlUI.yes"));
            row.getKDTRow().addCell(2, isDorectPrintCell);
            isDorectPrintCell.setFormattedSSA(ssa);
            isDorectPrintCell.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa}));
        }
    }

    private void constructColumns() {
        IColumn col1 = this.tblMain.addColumn();
        col1.setKey(BILL_TYPE);
        IColumn col2 = this.tblMain.addColumn();
        col2.setKey(PRINTER);
        IColumn col3 = this.tblMain.addColumn();
        col3.setKey(IS_DIRECT_PRINT);
    }

    private void constructTitleRow() {
        IRow row = this.tblMain.addHeadRow();
        row.getCell(0).setValue((Object)MultiLanguageUtil.getMLS("actions.ActionDirectPrintControl.billType"));
        row.getCell(1).setValue((Object)MultiLanguageUtil.getMLS("actions.ActionDirectPrintControl.printer"));
        row.getCell(2).setValue((Object)MultiLanguageUtil.getMLS("actions.ActionDirectPrintControl.isDirectPrint"));
    }

    private HashMap<String, String> consItemFromRow() {
        int currentRow = ParamClientUtil.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(currentRow);
        HashMap<String, String> rowMap = new HashMap<String, String>();
        rowMap.put(BILL_TYPE, (String)row.getCell(BILL_TYPE).getValue());
        rowMap.put(PRINTER, (String)row.getCell(PRINTER).getValue());
        rowMap.put(IS_DIRECT_PRINT, (String)row.getCell(IS_DIRECT_PRINT).getValue());
        return rowMap;
    }

    private void showDirectPrintItemEditUI(HashMap<String, String> rowMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Owner", (Object)this);
        map.put("directPrintItem", rowMap);
        try {
            KDPrintUtil.getInstance();
            int configCount = KDPrintUtil.getCachedConfig().size();
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DirectPrintItemUI.class.getName(), map, null, OprtState.EDIT);
            uiWindow.show();
            KDPrintUtil.getInstance();
            if (configCount > KDPrintUtil.getCachedConfig().size()) {
                this.tblMain.repaint();
                this.tblMain.removeRow(ParamClientUtil.getSelectedRow((KDTable)this.tblMain));
            }
        }
        catch (UIException e1) {
            logger.info((Object)"\u6253\u5f00\u76f4\u63a5\u6253\u5370\u7f16\u8f91\u754c\u9762\u5f02\u5e38", (Throwable)e1);
        }
    }
}

