/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions.superman;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDef;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTreeCtrl;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteRoleUseUtil;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.TableView;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.icons.KDRSIcons;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.client.RolePromptBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ActionAddRoleUse
extends AbstractAction {
    private static final Logger log = LogUtil.getPackageLogger(ActionAddRoleUse.class);
    private NoteTreeCtrl _noteTreeCtrl;

    public ActionAddRoleUse() {
        this.putValue("Name", MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.allocatee"));
        this.putValue("SmallIcon", ResourceManager.getIcon((String)"com.kingdee.bos.ctrl.report.forapp.kdnote.client.ui.res", (String)"tbtn_used.gif"));
        this.putValue("ShortDescription", MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.allocatee"));
    }

    public void setNoteTreeCtrl(NoteTreeCtrl noteTreeCtrl) {
        this._noteTreeCtrl = noteTreeCtrl;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ResObjectNode node;
        int i;
        TreePath[] ps = this._noteTreeCtrl.getTreeUI().getTree().getSelectionPaths();
        if (ps == null) {
            WindowUtil.msgboxInfo((Object)MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.noSelectSource"), (String)MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.allocatee"), (Component)this._noteTreeCtrl.getTreeUI());
            return;
        }
        boolean cantDo = false;
        for (int i2 = 0; i2 < ps.length; ++i2) {
            ResObjectNode node2 = (ResObjectNode)ps[i2].getLastPathComponent();
            ResTypeDef resDef = (ResTypeDef)node2.getCategory();
            String resName = resDef.getName();
            if (!"folder".equals(resName) && !"bos-query".equals(resName) && !"note-dynquery".equals(resName) && !"/".equals(node2.getName())) continue;
            cantDo = true;
            break;
        }
        if (cantDo) {
            WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.warning"), (String)MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.allocatee"), (Component)this._noteTreeCtrl.getTreeUI());
            return;
        }
        UI dlg = UI.create((Component)this._noteTreeCtrl.getTreeUI());
        dlg.setSize(480, 360);
        dlg.setTitle(MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.allocatee"));
        LinkedHashSet<String> originalUsers = new LinkedHashSet<String>();
        try {
            IRole iRole = RoleFactory.getRemoteInstance();
            for (i = 0; i < ps.length; ++i) {
                node = (ResObjectNode)ps[i].getLastPathComponent();
                String rolesAttrValue = NoteRoleUseUtil.getStringAttr(this._noteTreeCtrl.getBizContent(), node.getResPath());
                if (rolesAttrValue == null) continue;
                Object[] roleNumbers = rolesAttrValue.split("\\,");
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                FilterItemInfo filterItem = new FilterItemInfo("id", new HashSet(Arrays.asList((Object[])roleNumbers)), CompareType.INCLUDE);
                filter.getFilterItems().add(filterItem);
                ev.setFilter(filter);
                RoleCollection roleCollection = iRole.getRoleCollection(ev);
                for (int j = 0; j < roleCollection.size(); ++j) {
                    RoleInfo RoleInfo2 = roleCollection.get(j);
                    dlg.addRow(RoleInfo2);
                    originalUsers.add(RoleInfo2.getId().toString());
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        dlg.initOldValues(originalUsers.toArray(new String[originalUsers.size()]));
        if (dlg.showDialog()) {
            LinkedHashSet roles = new LinkedHashSet(Arrays.asList((Object[])dlg.getAddUsers()));
            for (i = 0; i < ps.length; ++i) {
                try {
                    node = (ResObjectNode)ps[i].getLastPathComponent();
                    LinkedHashSet toAddRoles = new LinkedHashSet(roles);
                    toAddRoles.removeAll(originalUsers);
                    LinkedHashSet toDelRoles = new LinkedHashSet(originalUsers);
                    toDelRoles.removeAll(roles);
                    NoteRoleUseUtil.modifyAttr(this._noteTreeCtrl, node.getResPath(), toAddRoles.toArray(new String[toAddRoles.size()]), true);
                    NoteRoleUseUtil.modifyAttr(this._noteTreeCtrl, node.getResPath(), toDelRoles.toArray(new String[toDelRoles.size()]), false);
                    log.debug((Object)("modified " + node.getResPath()));
                    continue;
                }
                catch (KDRSException ex) {
                    log.error((Object)"", (Throwable)ex);
                }
            }
        }
    }

    private static class UI
    extends TypicalDialog {
        private final int COL_NUMBER = 0;
        private final int COL_Name = 1;
        private final int COL_ID = 2;
        private TableView _tableView;
        private String[] oldValues;

        public static UI create(Component owner) {
            Window win = SwingUtilities.getWindowAncestor(owner);
            if (win instanceof Dialog) {
                return new UI((Dialog)win);
            }
            if (win instanceof Frame) {
                return new UI((Frame)win);
            }
            return new UI();
        }

        public UI() {
        }

        public UI(Dialog owner) {
            super(owner);
        }

        public UI(Frame owner) {
            super(owner);
        }

        protected void initOldValues(String[] oldValues) {
            this.oldValues = this.getAddUsers();
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            KDTextArea explainText = new KDTextArea();
            explainText.setBorder(null);
            explainText.setText(MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.explainText"));
            explainText.setEnabled(false);
            KDPanel panInfo = new KDPanel((LayoutManager)new BorderLayout());
            panInfo.add((Component)explainText, (Object)"Center");
            panInfo.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.explain")));
            panInfo.setCustomInsets(new Insets(20, 8, 8, 8));
            TableLayout2 tab = new TableLayout2(3, 1);
            tab.setRowSpacing(0, 5);
            tab.setRatableHeight(0, 25);
            tab.setRatableHeight(1, 75);
            KDPanel panel = new KDPanel();
            panel.setLayout((LayoutManager)tab);
            panel.add((Component)panInfo, (Object)TableLayout2.param((int)0, (int)0));
            panel.add((Component)this._tableView.getPanel(), (Object)TableLayout2.param((int)1, (int)0));
            parent.add((Component)panel, thisCell);
        }

        protected void todoInit() {
            this._tableView = new TableView();
            this._tableView.setTitle(MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.title"));
            this._tableView.addCustomAction((Action)new ActionAddUsers());
            this._tableView.setDefaultButton(8);
            KDTable tb = this._tableView.getTable();
            tb.getSelectManager().setSelectMode(10);
            tb.addColumns(3);
            tb.getColumn(0).setWidth(200);
            tb.getColumn(1).setWidth(200);
            tb.getColumn(2).setWidth(200);
            tb.getColumn(2).getStyleAttributes().setHided(true);
            IRow head = tb.addHeadRow();
            head.getCell(0).setValue((Object)MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.roleNumber"));
            head.getCell(1).setValue((Object)MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.roleName"));
            head.getCell(2).setValue((Object)"id");
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    this.onCancel();
                }
            });
        }

        protected void onCancel() {
            if (this.isModified()) {
                if (WindowUtil.msgboxYesNo((Component)((Object)this), (Object)MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.chooseInfo"), (String)this.getTitle())) {
                    this.onOk();
                } else {
                    super.onCancel();
                }
            } else {
                super.onCancel();
            }
        }

        private boolean isModified() {
            boolean isModified = false;
            String[] values = this.getAddUsers();
            if (this.oldValues.length != values.length) {
                isModified = true;
            } else {
                for (int i = 0; i < values.length; ++i) {
                    if (values[i].equals(this.oldValues[i])) continue;
                    isModified = true;
                    break;
                }
            }
            return isModified;
        }

        private void addRow(RoleInfo RoleInfo2) {
            IRow row = this._tableView.getTable().addRow();
            row.getCell(2).setValue((Object)RoleInfo2.getId().toString());
            row.getCell(0).setValue((Object)RoleInfo2.getNumber());
            row.getCell(1).setValue((Object)RoleInfo2.getName());
            row.setUserObject((Object)RoleInfo2);
        }

        public String[] getAddUsers() {
            ArrayList<Object> result = new ArrayList<Object>();
            KDTable table = this._tableView.getTable();
            int c = table.getRowCount();
            for (int i = 0; i < c; ++i) {
                result.add(table.getRow(i).getCell(2).getValue());
            }
            return result.toArray(new String[0]);
        }

        private class ActionAddUsers
        extends AbstractAction {
            public ActionAddUsers() {
                this.putValue("SmallIcon", ResourceManager.getIcon(KDRSIcons.class, (String)"tbtn/tbtn_addgroup.gif"));
                this.putValue("ShortDescription", MultiLanguageUtil.getMLS("superman.ActionAddRoleUse.addUser"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                KDCommonPromptDialog dlg = null;
                try {
                    Object owner = UI.this._tableView.getPanel();
                    if (owner != null) {
                        while (!(owner instanceof Frame) && (owner = owner.getParent()) != null) {
                        }
                    }
                    dlg = this.getRoleDialog((Component)owner);
                }
                catch (Exception ex) {
                    log.error((Object)"Call RolePromptBox error.", (Throwable)ex);
                    return;
                }
                dlg.setVisible(true);
                Object[] roles = (Object[])dlg.getData();
                List existRoleIds = Arrays.asList((Object[])UI.this.getAddUsers());
                if (roles != null) {
                    for (int i = 0; i < roles.length; ++i) {
                        RoleInfo RoleInfo2 = (RoleInfo)roles[i];
                        if (existRoleIds.contains(RoleInfo2.getId().toString())) continue;
                        UI.this.addRow(RoleInfo2);
                    }
                }
            }

            public KDCommonPromptDialog getRoleDialog(Component owner) throws Exception {
                RolePromptBox dlg = (RolePromptBox)WindowUtil.createWindow(RolePromptBox.class, (Component)owner);
                dlg.setEnabledMultiSelection(true);
                IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.permission.app.RoleQuery");
                QueryInfo queryInfo = metaDataLoader.getQuery((IMetaDataPK)queryPK);
                dlg.setQueryInfo(queryInfo);
                dlg.setHasCUDefaultFilter(false);
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                map.put("isSingle", false);
                dlg.setUIContext(map);
                return dlg;
            }
        }
    }
}

