/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.offline;

import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.StorageCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.fs.FSStorage;
import java.util.HashMap;

public class OfflineUtil {
    public static void downloadTemplates(IBizContent fromSto, String fromPath, String localFilePath) throws KDRSException {
        FSStorage fss = new FSStorage(localFilePath, true);
        fss.refresh(Path.ROOT, false);
        BizStorage toSto = new BizStorage((IStorage)fss);
        String absFromPath = PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)fromPath);
        String toPath = PathUtil.makeChildPath((String)fromPath);
        Creater creator = new Creater();
        creator.create((IBizStorage)fromSto, absFromPath, (IBizStorage)toSto, toPath);
        OfflineUtil.copyFolder((IBizStorage)fromSto, absFromPath, (IBizStorage)toSto, toPath, creator);
    }

    private static void copyFolder(IBizStorage fromSto, String fromPath, IBizStorage toSto, String toPath, Creater creator) throws KDRSException {
        int i;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("name", null);
        attrs.put("last-modified", null);
        HashMap fromAttrs = fromSto.list(fromPath, attrs);
        HashMap toAttrs = toSto.list(toPath, attrs);
        String[] fromNames = (String[])fromAttrs.get("name");
        String[] toNames = (String[])toAttrs.get("name");
        for (i = 0; i < toNames.length; ++i) {
            int idx = OfflineUtil.getIndex(toNames[i], fromNames);
            if (idx != -1) continue;
            String toChild = PathUtil.makeChildPath((String)toPath, (String)toNames[i]);
            toSto.delete(toChild);
        }
        for (i = 0; i < fromNames.length; ++i) {
            String toChild;
            String childName = fromNames[i];
            String fromChild = PathUtil.makeChildPath((String)fromPath, (String)childName);
            HashMap atts = creator.create(fromSto, fromChild, toSto, toChild = PathUtil.makeChildPath((String)toPath, (String)childName));
            if (atts == null) continue;
            OfflineUtil.copyFolder(fromSto, fromChild, toSto, toChild, creator);
        }
    }

    private static int getIndex(String str, String[] strs) {
        int c = strs.length;
        for (int i = 0; i < c; ++i) {
            if (!StringUtil.equals((String)str, (String)strs[i])) continue;
            return i;
        }
        return -1;
    }

    private static HashMap createTemplate(IBizStorage fromSto, String fromPath, IBizStorage toSto, String toPath, int createPolicy) throws KDRSException {
        HashMap atts = fromSto.getAttributes(fromPath, null);
        atts.put("type", StorageCategory.FILE.getName());
        atts.remove("name");
        atts.remove("size");
        atts.remove("time");
        atts.remove("creator");
        atts.remove("last-access");
        atts.remove("last-modified");
        atts.remove("eas-report-id");
        atts.remove("eas-menu-pk");
        if (1 != createPolicy) {
            atts.put("create_policy", new Integer(createPolicy));
        }
        toSto.create(toPath, atts);
        return atts;
    }

    private static class Creater
    implements BizStorageUtil.IResourceCreator {
        private Creater() {
        }

        public HashMap create(IBizStorage fromSto, String fromPath, IBizStorage toSto, String toPath) throws KDRSException {
            IBizContent fromCnt = (IBizContent)fromSto;
            HashMap attrs = fromCnt.getAttributes(fromPath, new String[]{"category"});
            String catogory = (String)attrs.get("category");
            if (StringUtil.equals((String)"kdrs-form", (String)catogory) || StringUtil.equals((String)"r1-print", (String)catogory) || StringUtil.equals((String)"note-dynquery", (String)catogory)) {
                attrs = null;
                OfflineUtil.createTemplate((IBizStorage)fromCnt, fromPath, toSto, toPath, 16);
                toSto.writeFile(toPath, -1, fromCnt.readTemplate(fromPath));
            } else {
                attrs = StringUtil.equals((String)"folder", (String)catogory) ? BizStorageUtil.create((IBizStorage)fromCnt, (String)fromPath, (IBizStorage)toSto, (String)toPath, (int)16) : null;
            }
            return attrs;
        }
    }
}

