/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.publishedcheck;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.SimpleFrame;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.server.publishedcheck.PublishedTempletChecker;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NoteTempletPublishedChecker {
    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        new NoteTempletPublishedChecker();
    }

    public NoteTempletPublishedChecker() {
        this.init();
    }

    private void init() {
        final KDWorkButton btnSelectPath = new KDWorkButton(MultiLanguageUtil.getMLS("publishedcheck.NoteTempletPublishedChecker.selectPath"));
        final KDLabel labPath = new KDLabel("path");
        final KDRadioButton radCodePath = new KDRadioButton(MultiLanguageUtil.getMLS("publishedcheck.NoteTempletPublishedChecker.radCodePath"));
        KDRadioButton radEASPath = new KDRadioButton(MultiLanguageUtil.getMLS("publishedcheck.NoteTempletPublishedChecker.radEASPath"));
        final KDTextField txtExcept = new KDTextField(".svn;.cvs");
        final KDTextArea txaInfo = new KDTextArea();
        final KDProgressBar progressBar = new KDProgressBar();
        progressBar.setIndeterminate(true);
        progressBar.setVisible(false);
        KDLabelContainer lbcExcept = CtrlSwingUtilities.createLabelContainer((JComponent)txtExcept, (String)MultiLanguageUtil.getMLS("publishedcheck.NoteTempletPublishedChecker.texExcept"), (int)30);
        KDLabelContainer lbcPath = CtrlSwingUtilities.createLabelContainer((JComponent)labPath, (String)MultiLanguageUtil.getMLS("publishedcheck.NoteTempletPublishedChecker.goalPath"), (int)60);
        lbcPath.setBoundLabelUnderline(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)radCodePath);
        bg.add((AbstractButton)radEASPath);
        radCodePath.setSelected(true);
        radCodePath.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                txtExcept.setEnabled(radCodePath.isSelected());
            }
        });
        TableLayout tl = TableLayout.split((int)3, (int)1);
        tl.getStyle().setMargin(10);
        tl.rowStyle(1).setMargin(6);
        tl.rowStyle(2).setPriY(1);
        Table row1 = tl.cell(0).splitCol(5);
        row1.colStyle(0).setWidth(160);
        row1.colStyle(0).setMarginRight(40);
        row1.colStyle(1).setWidth(120);
        row1.colStyle(2).setWidth(120);
        row1.colStyle(2).setMarginRight(30);
        row1.colStyle(3).setWidth(150);
        row1.colStyle(3).setMarginRight(20);
        row1.colStyle(4).setPriX(1);
        KDPanel panAll = new KDPanel((LayoutManager)tl);
        panAll.add((Component)btnSelectPath, (Object)row1.cell(0));
        panAll.add((Component)radCodePath, (Object)row1.cell(1));
        panAll.add((Component)lbcExcept, (Object)row1.cell(2));
        panAll.add((Component)radEASPath, (Object)row1.cell(3));
        panAll.add((Component)progressBar, (Object)row1.cell(4));
        panAll.add((Component)lbcPath, (Object)tl.cell(1));
        panAll.add((Component)new KDScrollPane((Component)txaInfo), (Object)tl.cell(2));
        final SimpleFrame frm = new SimpleFrame();
        frm.setTitle(MultiLanguageUtil.getMLS("publishedcheck.NoteTempletPublishedChecker.framTitle"));
        frm.setComponent((Component)panAll);
        frm.setSize(800, 600);
        frm.showFrame();
        btnSelectPath.addActionListener(new ActionListener(){
            private String lastPath;

            @Override
            public void actionPerformed(ActionEvent e) {
                KDFileChooser kfc = new KDFileChooser(this.lastPath);
                kfc.setFileSelectionMode(1);
                if (kfc.showOpenDialog((Component)frm) == 0) {
                    String[] excepts = new String[]{};
                    if (radCodePath.isSelected()) {
                        String strExcepts = txtExcept.getText();
                        excepts = strExcepts.split(";");
                    }
                    File file = kfc.getSelectedFile();
                    this.lastPath = file.getPath();
                    labPath.setText(this.lastPath);
                    final PublishedTempletChecker checker = new PublishedTempletChecker();
                    checker.setRootPath(file.getPath());
                    for (int i = 0; i < excepts.length; ++i) {
                        checker.addExcept(excepts[i]);
                    }
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            checker.check();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    progressBar.setVisible(false);
                                    btnSelectPath.setEnabled(true);
                                    this.showResult(checker);
                                }
                            });
                        }
                    });
                    txaInfo.setText(MultiLanguageUtil.getMLS("publishedcheck.NoteTempletPublishedChecker.txaInfo"));
                    progressBar.setVisible(true);
                    btnSelectPath.setEnabled(false);
                    thread.start();
                }
            }

            private void showResult(PublishedTempletChecker checker) {
                if (checker.isOK()) {
                    txaInfo.setText("OK!");
                } else {
                    StringBuffer sb = new StringBuffer();
                    if (checker.getErrorInfo().length() > 0) {
                        sb.append(MultiLanguageUtil.getMLS("publishedcheck.NoteTempletPublishedChecker.error"));
                        sb.append(StringUtil.RETURN);
                        sb.append(checker.getErrorInfo().toString());
                        sb.append(StringUtil.RETURN);
                    }
                    if (checker.getWarningInfo().length() > 0) {
                        sb.append(MultiLanguageUtil.getMLS("publishedcheck.NoteTempletPublishedChecker.warning"));
                        sb.append(StringUtil.RETURN);
                        sb.append(checker.getWarningInfo().toString());
                    }
                    txaInfo.setText(sb.toString());
                }
            }
        });
    }
}

