/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.util;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteUserConfig;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.fs.FSStorage;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import org.apache.log4j.Logger;

public class NoteUtil {
    private static Logger log = LogUtil.getPackageLogger(NoteUtil.class);
    private static IStorage localSto;
    private static IBizStorage localBizStorage;

    public static String getUser() {
        SysContext sysCtx = SysContext.getSysContext();
        return sysCtx.getUserName();
    }

    public static String getCurrentOrgUnitId() {
        SysContext sysCtx = SysContext.getSysContext();
        OrgUnitInfo orgInfo = sysCtx.getCurrentOrgUnit();
        if (orgInfo != null) {
            return orgInfo.getId().toString();
        }
        return null;
    }

    public static String bindCompanyAndUser(String company, String user) {
        if (StringUtil.isEmptyString((String)company)) {
            return user;
        }
        return new StringBuffer(company).append(" ").append(user).toString();
    }

    public static String getDefaultTemplate(NoteUserConfig config, String company, String user) {
        String cau = NoteUtil.bindCompanyAndUser(company, user);
        String templateName = config.getDefaultTemplateName(cau);
        if (!StringUtil.equals((String)user, (String)cau) && StringUtil.isEmptyString((String)templateName) && !StringUtil.isEmptyString((String)(templateName = config.getDefaultTemplateName(user)))) {
            config.removeDefaultTemplateName(user);
            config.putDefaultTemplateName(cau, templateName);
        }
        return templateName;
    }

    public static boolean isOrgFilter(NoteUserConfig config, String company, String user) {
        String cau = NoteUtil.bindCompanyAndUser(company, user);
        return config.isOrgFilter(cau);
    }

    public static IBizStorage getLocalBizStorage() {
        IStorage sto;
        if (localBizStorage == null && (sto = NoteUtil.getLocalSto()) != null) {
            localBizStorage = new BizStorage(sto);
        }
        return localBizStorage;
    }

    public static IStorage getLocalSto() {
        if (localSto == null) {
            String ais = "/NoteCache";
            String org = "/eas";
            String s = PathUtil.makeChildPath((String)ais, (String)org);
            s = GlobalLocator.getInstance().makeFilePath(s);
            FileUtil.createFolder((String)s);
            try {
                localSto = new FSStorage(s, true);
            }
            catch (KDRSException e) {
                log.error((Object)"Create local IStorage fail.", (Throwable)e);
            }
        }
        return localSto;
    }
}

