/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.integrate;

import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteVarListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.integrate.PreviewPanel;
import com.kingdee.bos.ctrl.report.forapp.kdnote.integrate.TemplatesTree;
import com.kingdee.bos.ctrl.report.impl.r1note.specialdata.NoteInteriorDataProviderFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.browser.R1PrintBrowser;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintVariantListener;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.RuntimeModel;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.AbstractInteriorDataProviderFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import javax.swing.JComponent;

public class PreviewArea {
    private PreviewPanel _ctrl = new PreviewPanel();
    private R1PrintBrowser _browser;
    private RuntimeModel _templateModel;
    private AbstractPrintDataProvider _dataProvider;

    public PreviewArea() {
        this.initBrowser();
    }

    private void initBrowser() {
        this._browser = new R1PrintBrowser();
        this._browser.setPrinterCtrl(new KDPrinter());
        this._browser.setVariantListener((IPrintVariantListener)new NoteVarListener.R1VarListener());
    }

    public JComponent getCtrl() {
        return this._ctrl;
    }

    public void bindTemplatesTree(TemplatesTree templatesTree) {
        templatesTree.addPropertyChangeListener(new ModelChangeHandler());
    }

    public void fireDataChange(AbstractPrintDataProvider dataProvider) {
        this._dataProvider = dataProvider;
        this.updatePreview(this._dataProvider);
    }

    private void updatePreview(AbstractPrintDataProvider dataProvider) {
        if (this._templateModel == null) {
            return;
        }
        if (dataProvider == null) {
            this._templateModel.hookDataProvider((AbstractPrintDataProvider)new DefaultDataProvider(), null);
        } else {
            this._templateModel.hookDataProvider(dataProvider, (AbstractInteriorDataProviderFactory)new NoteInteriorDataProviderFactory());
        }
        Paper paper = this._browser.getPrintPaper(this._templateModel);
        this._ctrl.setPaper(paper);
        this._ctrl.revalidate();
        this._ctrl.repaint();
    }

    private static class DefaultDataProvider
    extends AbstractPrintDataProvider {
        private DefaultDataProvider() {
        }

        public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
            try {
                DynamicRowSet drs = new DynamicRowSet(0);
                return drs;
            }
            catch (SQLException e) {
                return null;
            }
        }
    }

    private class ModelChangeHandler
    implements PropertyChangeListener {
        private ModelChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "ModelChanged") {
                PreviewArea.this._templateModel = (RuntimeModel)evt.getNewValue();
                PreviewArea.this.updatePreview(PreviewArea.this._dataProvider);
            }
        }
    }
}

