/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.note;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.kdf.fd2.KDF;
import com.kingdee.bos.ctrl.kdf.fd2.actions.DefaultMenuFile;
import com.kingdee.bos.ctrl.kdf.fd2.data.IDataManagerFactory;
import com.kingdee.bos.ctrl.kdf.fd2.data.IMetaManager;
import com.kingdee.bos.ctrl.kdf.fd2.gui.FormDesigner;
import com.kingdee.bos.ctrl.kdf.fd2.gui.FormDesignerOwnerFactory;
import com.kingdee.bos.ctrl.kdf.fd2.gui.FormDesignerOwnerFrame;
import com.kingdee.bos.ctrl.kdf.fd2.gui.IFormDesignerOwner;
import com.kingdee.bos.ctrl.kdf.fd2.gui.KDFFrame;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.InitCompletedEvent;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.InitCompletedListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.ui.NoteMetaManager;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDataUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDistributionUtil;
import com.kingdee.bos.ctrl.report.impl.note.KDFormDesigntimePreview;
import com.kingdee.bos.ctrl.report.impl.note.KDNote_DataManagerFactory;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.DataSourceException;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.IDataSource;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_ObjectSelector;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyOpenedException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportEnv;
import com.kingdee.bos.ctrl.reportone.reportframework.IStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.design.AReportDesigner;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class KDNoteRptDesigner
extends AReportDesigner {
    private static final Logger log = LogUtil.getPackageLogger(KDNoteRptDesigner.class);
    private static final String EAS_NOTE_PROJECT = "/EAS_Note.kdrs";
    private byte[] MemoryCashForNewParam = null;
    private FormDesigner formDesigner;

    public KDNoteRptDesigner(Component owner) {
        super(owner);
    }

    private MetaLibrary makeNoteMetaLibrary() throws ReportException {
        MetaLibrary ml;
        IReportEnv rptEnv = this.getReportEnv();
        IDataSource ds = rptEnv.getDSFactory().getDataSource(EAS_NOTE_PROJECT);
        if (ds == null) {
            throw new ReportException(MultiLanguageUtil.getMLS("note.KDNoteRptDesigner.cantFindDataSource") + EAS_NOTE_PROJECT);
        }
        try {
            ml = ds.getMetaLibrary();
        }
        catch (DataSourceException ex) {
            throw ReportException.makeException((String)MultiLanguageUtil.getMLS("note.KDNoteRptDesigner.addQueryFailed"), (Throwable)ex);
        }
        String objPath = rptEnv.getReportStorage().getPath();
        int last = objPath.lastIndexOf(47);
        String mpPath = objPath.substring(EAS_NOTE_PROJECT.length(), last);
        MetaPackage mp = ml.getRootPackage().findPackage(mpPath);
        if (mp == null) {
            throw new ReportException(MultiLanguageUtil.getMLS("note.KDNoteRptDesigner.cantFindeDataBag") + mpPath);
        }
        MetaLibrary mlNote = new MetaLibrary();
        mlNote.copy((IDefObj)ml);
        MetaPackage mpNote = mlNote.getRootPackage();
        for (MetaClass mc : mp.getClasses()) {
            if (!DataDefType.BOS_QUERY.getName().equals(mc.getType())) continue;
            String expr = mc.getExpr();
            if (expr != null && expr.startsWith("::")) {
                Eas_ObjectSelector selector;
                try {
                    selector = new Eas_ObjectSelector(null);
                }
                catch (KDRSException e) {
                    throw ReportException.makeException((String)MultiLanguageUtil.getMLS("note.KDNoteRptDesigner.constructFailed"), (Throwable)e);
                }
                Object data = selector.getObject(expr);
                if (data != null) {
                    mc = (MetaClass)data;
                }
            } else {
                mc.getFields();
            }
            mpNote.addClass(mc);
        }
        return mlNote;
    }

    public void design(boolean isNew, HashMap args) throws ReportException {
        boolean isReadOnly;
        boolean isDataWizard;
        if (this.formDesigner != null) {
            throw new AlreadyOpenedException();
        }
        IFormDesignerOwner frame = FormDesignerOwnerFactory.createFrame();
        this.formDesigner = frame.getDesigner();
        this.formDesigner.setConfigFile("/client/KDNoteRptDesigner.xml");
        try {
            if (this.MemoryCashForNewParam == null && KDNoteHelper.getBizContent().isExist("/KDNoteNewVariant.xml")) {
                this.MemoryCashForNewParam = BizStorageUtil.readFile((IBizStorage)KDNoteHelper.getBizContent(), (String)"/KDNoteNewVariant.xml");
            }
        }
        catch (KDRSException e) {
            String msg = MultiLanguageUtil.getMLS("note.KDNoteRptDesigner.readXmlFailed");
            log.error((Object)msg, (Throwable)e);
        }
        MetaClass mcObj = (MetaClass)args.get(ReportUtil.ARG_META_CLASS);
        if (mcObj != null) {
            KDNote_DataManagerFactory dmFactory = new KDNote_DataManagerFactory();
            dmFactory.setData(new MetaClass[]{mcObj});
            this.formDesigner.setDataManagerFactory((IDataManagerFactory)dmFactory);
            isDataWizard = false;
        } else {
            isDataWizard = true;
            MetaLibrary mlNote = this.makeNoteMetaLibrary();
            NoteMetaManager mm = new NoteMetaManager();
            mm.setMetaData(mlNote);
            this.formDesigner.setMetaManager((IMetaManager)mm);
        }
        frame.addWindowListener((WindowListener)new AReportDesigner.WindowEventHandler((AReportDesigner)this));
        this.addPreviewListener((FormDesignerOwnerFrame)frame);
        frame.show();
        String readOnly = (String)args.get("readOnly");
        boolean bl = isReadOnly = readOnly != null;
        if (isReadOnly) {
            this.formDesigner.setTitle(readOnly + this.formDesigner.getTitle());
        }
        this.formDesigner.addInitCompletedListener((InitCompletedListener)new InitListener(isNew, isDataWizard, isReadOnly));
    }

    public void close() throws ReportException {
        this.formDesigner.getOwner().dispose();
        this.formDesigner = null;
    }

    public Component getComponent() {
        return this.formDesigner;
    }

    private void addPreviewListener(FormDesignerOwnerFrame frame) {
        KeyStroke ks = KeyStroke.getKeyStroke(80, 128);
        InputMap inputMap = frame.getRootPane().getInputMap(2);
        inputMap.put(ks, "Preview");
        frame.getRootPane().getActionMap().put("Preview", new ActionPreview());
    }

    private class ActionPreview
    extends AbstractAction {
        private ActionPreview() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                KDF kdf = KDNoteRptDesigner.this.formDesigner.getKDFFrame().getReport();
                kdf.buildKDFDom();
                kdf.getKDFDom().save((OutputStream)baos);
                byte[] bytes = baos.toByteArray();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                com.kingdee.bos.ctrl.kdf.util.file.KDF kdfDom = new com.kingdee.bos.ctrl.kdf.util.file.KDF((InputStream)is);
                new KDFormDesigntimePreview(KDNoteRptDesigner.this.getComponent(), kdfDom).actionPerformed(e);
            }
            catch (Throwable ex) {
                log.error((Object)ex);
            }
        }
    }

    public static class SaveAction
    extends DefaultMenuFile.DefaultSaveAction {
        private KDNoteRptDesigner noteDesigner;
        private boolean isReadOnly;

        public void init(KDNoteRptDesigner noteDesigner, boolean isReadOnly) {
            this.noteDesigner = noteDesigner;
            this.isReadOnly = isReadOnly;
        }

        public void actionPerformed(ActionEvent e) {
            OutputStream out;
            if (this.isReadOnly) {
                NoteDistributionUtil.promptReadOnly((Component)this.designer, MultiLanguageUtil.getMLS("note.KDNoteRptDesigner.save"));
                return;
            }
            try {
                out = ((IStreamStorage)this.noteDesigner.getReportEnv().getReportStorage()).getOutputStream();
            }
            catch (ReportException ex) {
                String msg = MultiLanguageUtil.getMLS("note.KDNoteRptDesigner.saveKDFFailed");
                log.error((Object)msg, (Throwable)ex);
                WindowUtil.showException((String)msg, (Throwable)ex, null, (Component)this.designer);
                return;
            }
            KDFFrame kdfFrame = this.designer.getKDFFrame();
            if (kdfFrame != null) {
                KDF kdf = kdfFrame.getReport();
                kdf.buildKDFDom();
                kdf.getKDFDom().save(out);
                kdf.setDirty(false);
                this.noteDesigner.fireSaveCompleted();
            } else {
                WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("note.KDNoteRptDesigner.cantSave"), (String)MultiLanguageUtil.getMLS("note.KDNoteRptDesigner.save"), (Component)this.designer);
            }
        }
    }

    private class InitListener
    implements InitCompletedListener {
        boolean isNew;
        boolean isDataWizard;
        boolean isReadOnly;

        public InitListener(boolean isNew, boolean isDataWizard, boolean isReadOnly) {
            this.isNew = isNew;
            this.isDataWizard = isDataWizard;
            this.isReadOnly = isReadOnly;
        }

        public void initCompleted(InitCompletedEvent e) {
            KDNoteRptDesigner.this.formDesigner.getActionManager().getDesignerAction("dataWizard").setActionEnable(this.isDataWizard);
            if (KDNoteRptDesigner.this.MemoryCashForNewParam != null) {
                KDNoteRptDesigner.this.formDesigner.setSupplyVariant(KDNoteRptDesigner.this.MemoryCashForNewParam);
            }
            SaveAction saveAct = (SaveAction)KDNoteRptDesigner.this.formDesigner.getActionManager().getDesignerAction("save");
            saveAct.init(KDNoteRptDesigner.this, this.isReadOnly);
            try {
                if (this.isNew) {
                    String name = KDNoteRptDesigner.this.getReportEnv().getReportStorage().getName();
                    KDNoteRptDesigner.this.formDesigner.onDefaultNewDoc(name);
                    NoteDataUtil.autoCreateQuery(KDNoteRptDesigner.this.formDesigner);
                } else {
                    log.debug((Object)"Load Form template ...");
                    InputStream tpl = ((IStreamStorage)KDNoteRptDesigner.this.getReportEnv().getReportStorage()).getInputStream();
                    com.kingdee.bos.ctrl.kdf.util.file.KDF kdf = new com.kingdee.bos.ctrl.kdf.util.file.KDF(tpl, true);
                    KDNoteRptDesigner.this.formDesigner.loadDesignedKDF(kdf, "", 0);
                }
            }
            catch (Throwable ex) {
                String msg = MultiLanguageUtil.getMLS("note.KDNoteRptDesigner.addKDFFailed");
                log.error((Object)msg, ex);
                WindowUtil.showException((String)msg, (Throwable)ex, (String)KDNoteRptDesigner.this.formDesigner.getTitle(), (Component)KDNoteRptDesigner.this.formDesigner);
            }
        }
    }
}

