/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.r1note;

import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.io.Def2Xml;
import com.kingdee.bos.ctrl.data.modal.io.Xml2Def;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDataUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataParamSource;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.exception.InvalidDataException;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IDataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.print.data.SystemR1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class NoteDataXmlTrans
implements IDataXmlTrans {
    private IObjectSelector _objectSelector;

    public void setObjectSelector(IObjectSelector objectSelector) {
        this._objectSelector = objectSelector;
    }

    public void toXml(IR1DataManager dm, Element datasNode) {
        DataExtend[] allExts = dm.getDataExtends();
        for (int i = 0; i < allExts.length; ++i) {
            Element dataNode = new Element("Reference");
            datasNode.addContent((Content)dataNode);
            DataExtend ext = allExts[i];
            Def2Xml.makeDefObj((IDefObj)ext, (Element)dataNode);
            String info = ext.getInfo();
            dataNode.setAttribute("info", info);
            Object processClassName = ext.getProperty("processClassName");
            if (processClassName != null) {
                dataNode.setAttribute("processClassName", processClassName.toString());
            }
            this.paramToXml(allExts[i].getParamSources(), dataNode);
            this.sortsToXml(R1PrintModelHelper.getDataSorts((DataExtend)allExts[i]), dataNode);
        }
    }

    private void paramToXml(List paramList, Element nodeData) {
        Element nodeParams = new Element("Params");
        for (DataParamSource paramSource : paramList) {
            Element nodeParam = new Element("Param");
            nodeParams.addContent((Content)nodeParam);
            Element nodeAssociate = new Element("Associate");
            nodeParam.addContent((Content)nodeAssociate);
            nodeParam.setAttribute("name", paramSource.getParamName());
            if (paramSource.getReferenceDataName() != null) {
                nodeAssociate.setAttribute("dataSourceID", paramSource.getReferenceDataName());
            }
            nodeAssociate.setAttribute("delay", String.valueOf(paramSource.isDelay()));
            nodeAssociate.addContent(paramSource.getValue());
        }
        if (paramList.size() > 0) {
            nodeData.addContent((Content)nodeParams);
        }
    }

    private void sortsToXml(List sortsList, Element nodeData) {
        Element nodeSorts = new Element("Sorts");
        for (SystemR1PrintDataSortItem sort : sortsList) {
            Element nodeSort = new Element("Sort");
            nodeSorts.addContent((Content)nodeSort);
            nodeSort.setAttribute("field", sort.getSortField());
            if (sort.getSortType() == 1) {
                nodeSort.setAttribute("type", "descend");
            } else {
                nodeSort.setAttribute("type", "ascend");
            }
            if (sort.isSystem()) continue;
            nodeSort.setAttribute("custom", "true");
        }
        if (sortsList.size() > 0) {
            nodeData.addContent((Content)nodeSorts);
        }
    }

    public void fromXml(Element datasNode, IR1DataManager dm) throws InvalidDataException {
        StringBuffer invalidData = new StringBuffer();
        for (Element node : datasNode.getChildren("Reference")) {
            String processClassName;
            DataExtend ext = new DataExtend();
            Xml2Def.parseDefObj((IDefObj)ext, (Element)node);
            String info = node.getAttributeValue("info");
            ext.setInfo(info);
            Object dataObj = null;
            if (this._objectSelector != null && (dataObj = this._objectSelector.getObject(info)) == null) {
                invalidData.append(StringUtil.RETURN);
                invalidData.append(ext.getName());
                invalidData.append(" (");
                if (info == null) {
                    invalidData.append(MultiLanguageUtil.getMLS("r1note.NoteDataXmlTrans.noInfo"));
                } else {
                    invalidData.append(NoteDataUtil.getMetaCategoryPrompt(info));
                    invalidData.append(":");
                    invalidData.append(NoteDataUtil.cutMetaInfoPrefix(info));
                }
                invalidData.append(")");
            }
            if ((processClassName = node.getAttributeValue("processClassName")) != null) {
                ext.setProperty("processClassName", (Object)processClassName);
            }
            this.paramFromXml(ext, node);
            this.sortsFromXml(ext, node);
            dm.setListenerUseful(false);
            dm.addData(ext, dataObj);
            dm.setListenerUseful(true);
        }
        if (invalidData.length() != 0) {
            invalidData.insert(0, MultiLanguageUtil.getMLS("r1note.NoteDataXmlTrans.cantFindQuery"));
            throw new InvalidDataException(invalidData.toString());
        }
    }

    private void paramFromXml(DataExtend ext, Element nodeData) {
        Element nodeParams = nodeData.getChild("Params");
        if (nodeParams == null) {
            return;
        }
        List paramSourceList = ext.getParamSources();
        for (Element nodeParam : nodeParams.getChildren("Param")) {
            String paramName = nodeParam.getAttributeValue("name");
            if (StringUtil.isEmptyString((String)paramName)) continue;
            DataParamSource paramSource = NoteDataXmlTrans.getParamSourceFromList(paramSourceList, paramName);
            if (paramSource == null) {
                paramSource = new DataParamSource();
                paramSourceList.add(paramSource);
                paramSource.setParamName(paramName);
            }
            Element nodeAssociate = nodeParam.getChild("Associate");
            String dsName = nodeAssociate.getAttributeValue("dataSourceID");
            String delayValue = nodeAssociate.getAttributeValue("delay");
            paramSource.setReferenceDataName(dsName);
            paramSource.setValue(nodeAssociate.getText());
            boolean delay = Boolean.parseBoolean(delayValue);
            paramSource.setDelay(delay);
        }
    }

    private static DataParamSource getParamSourceFromList(List list, String name) {
        for (DataParamSource dps : list) {
            if (!StringUtil.equals((String)dps.getName(), (String)name)) continue;
            return dps;
        }
        return null;
    }

    private void sortsFromXml(DataExtend ext, Element nodeData) {
        Element nodeSorts = nodeData.getChild("Sorts");
        if (nodeSorts == null) {
            return;
        }
        for (Element nodeSort : nodeSorts.getChildren("Sort")) {
            String field = nodeSort.getAttributeValue("field");
            SystemR1PrintDataSortItem item = new SystemR1PrintDataSortItem();
            item.setSortField(field);
            String type = nodeSort.getAttributeValue("type");
            if ("descend".equalsIgnoreCase(type)) {
                item.setSortType(1);
            } else {
                item.setSortType(0);
            }
            item.setSystem(!"true".equals(nodeSort.getAttributeValue("custom")));
            List sortsList = R1PrintModelHelper.getDataSorts((DataExtend)ext);
            sortsList.add(item);
        }
    }
}

