/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.r1note;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.ThreadSafedObjectMaker;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDistributionUtil;
import com.kingdee.bos.ctrl.report.impl.r1note.NoteDataSelector;
import com.kingdee.bos.ctrl.report.impl.r1note.NoteR1Designer;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryFieldNode;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryModel;
import com.kingdee.bos.ctrl.report.impl.r1note.metaselector.QuerySelector4NoteR1Designer;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.DataSourceException;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.IDataSource;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_ObjectSelector;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyOpenedException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.owner.IR1DesignerOwner;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.owner.R1DesignerOwnerFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.ISaver;
import com.kingdee.bos.ctrl.reportone.reportframework.IContext;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportEnv;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.UnsupportedStorageException;
import com.kingdee.bos.ctrl.reportone.reportframework.design.AReportDesigner;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class NoteRptDesigner
extends AReportDesigner {
    private static final Logger log = LogUtil.getPackageLogger(NoteRptDesigner.class);
    private Container editor;

    public NoteRptDesigner(Component owner) {
        super(owner);
    }

    public void design(boolean isNew, HashMap args) throws ReportException {
        boolean isReadOnly;
        String readOnly = (String)args.get("readOnly");
        boolean bl = isReadOnly = readOnly != null;
        if (this.editor != null) {
            throw new AlreadyOpenedException();
        }
        IReportEnv rptEnv = this.getReportEnv();
        IReportStorage rptSto = rptEnv.getReportStorage();
        if (!(rptSto instanceof IStreamStorage)) {
            throw new UnsupportedStorageException();
        }
        IR1DesignerOwner frame = R1DesignerOwnerFactory.createFrame(NoteR1Designer.class);
        NoteR1Designer fd = (NoteR1Designer)frame.getDesigner();
        this.editor = frame.getContentPane();
        IContext pubEnv = this.getReportEnv().getContext();
        if (pubEnv != null) {
            MetaClass mc = pubEnv.getMeta();
            mc.setAlias(MultiLanguageUtil.getMLS("r1note.NoteRptDesigner.systemVariable"));
            fd.setSystemParams(mc);
        }
        fd.setDataSelector(this.createObjectSelector(args));
        fd.setSaver(new Saver(isReadOnly));
        fd.init();
        frame.setSize(800, 600);
        Object uiTitle = args.get(ReportUtil.ARG_UI_TITLE);
        String title = MultiLanguageUtil.getMLS("r1note.NoteRptDesigner.title") + (uiTitle != null ? (String)uiTitle : "");
        title = title + (isReadOnly ? readOnly : "");
        fd.setTitle(title);
        frame.addWindowListener((WindowListener)new AReportDesigner.WindowEventHandler((AReportDesigner)this));
        frame.show();
        Element xmlRoot = null;
        if (isNew) {
            Object argInitReport = args.get(ReportUtil.ARG_INIT_OBJECT);
            if (argInitReport instanceof ReportModel) {
                fd.loadReport((ReportModel)argInitReport);
            } else {
                fd.newReport();
            }
        } else {
            try {
                InputStream tpl = ((IStreamStorage)rptSto).getInputStream();
                xmlRoot = XmlUtil.loadXmlStream((InputStream)tpl);
            }
            catch (Exception ex) {
                throw ReportException.makeException((Throwable)ex);
            }
            try {
                fd.loadReport(xmlRoot);
            }
            catch (R1Exception e) {
                throw ReportException.makeException((Throwable)e);
            }
        }
    }

    public void close() throws ReportException {
        this.editor = null;
    }

    public Component getComponent() throws ReportException {
        return this.editor;
    }

    protected IObjectSelector createObjectSelector(HashMap args) throws ReportException {
        NoteDataSelector wrapper = new NoteDataSelector();
        ThreadSafedObjectMaker maker = ThreadSafedObjectMaker.getInstance();
        IObjectSelector syncObjectSelector = (IObjectSelector)maker.make((Object)new QuerySelector4NoteR1Designer(), new Class[]{IObjectSelector.class}, null, new String[]{"getUI"});
        wrapper.setBosQuerySelector(syncObjectSelector);
        wrapper.setNoteMetas(this.makeNoteMeta());
        return wrapper;
    }

    private HashMap makeNoteMeta() throws ReportException {
        MetaLibrary ml;
        IReportEnv rptEnv = this.getReportEnv();
        HashMap<String, MetaClass> result = new HashMap<String, MetaClass>();
        IDataSource ds = rptEnv.getDSFactory().getDataSource("/EAS_Note.kdrs");
        if (ds == null) {
            throw new ReportException(MultiLanguageUtil.getMLS("r1note.NoteRptDesigner.cantFindDatasource") + "/EAS_Note.kdrs");
        }
        try {
            ml = ds.getMetaLibrary();
        }
        catch (DataSourceException ex) {
            throw ReportException.makeException((String)MultiLanguageUtil.getMLS("r1note.NoteRptDesigner.loadFailed"), (Throwable)ex);
        }
        String objPath = rptEnv.getReportStorage().getPath();
        int last = objPath.lastIndexOf(47);
        String mpPath = objPath.substring("/EAS_Note.kdrs".length(), last);
        MetaPackage mp = ml.getRootPackage().findPackage(mpPath);
        if (mp == null) {
            throw new ReportException(MultiLanguageUtil.getMLS("r1note.NoteRptDesigner.cantFindDataBag") + mpPath);
        }
        for (MetaClass mc : mp.getClasses()) {
            if ("bos-query".equals(mc.getType())) {
                mc = this.initMetaClass_NoteMeta(mc);
                result.put(mc.getName(), mc);
                continue;
            }
            if (!"note-dynquery".equals(mc.getType())) continue;
            this.initMetaClass_NoteDynQuery(mc);
            String key = "dynquery://" + mc.getName();
            result.put(key, mc);
        }
        return result;
    }

    private void initMetaClass_NoteDynQuery(MetaClass mc) throws ReportException {
        NoteDynQueryModel model;
        String fileName = mc.getName();
        IStreamStorage rptSto = (IStreamStorage)this.getReportEnv().getReportStorage();
        String metaPath = PathUtil.makeSiblingPath((String)rptSto.getPath(), (String)fileName);
        InputStream is = rptSto.getInputStream(metaPath);
        Element root = null;
        try {
            root = XmlUtil.loadXmlStream((InputStream)is);
        }
        catch (Exception e) {
            log.error((Object)"Init note meta error.", (Throwable)e);
            return;
        }
        try {
            model = NoteDynQueryModel.fromXml(root);
        }
        catch (Exception e) {
            log.error((Object)"Init note meta error.", (Throwable)e);
            return;
        }
        NoteRptDesigner.convertMetaField(mc, model.getMainQueryFields());
        NoteRptDesigner.convertMetaField(mc, model.getDynamicFields());
    }

    private static void convertMetaField(MetaClass mc, NoteDynQueryFieldNode[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            MetaField mf = new MetaField();
            mf.setName(fields[i].getFieldName());
            mf.setAlias(fields[i].getFieldAlias());
            mf.setType(fields[i].getDataType());
            mc.addField(mf);
        }
    }

    private MetaClass initMetaClass_NoteMeta(MetaClass mc) throws ReportException {
        String name = mc.getName();
        String alias = mc.getAlias();
        String expr = mc.getExpr();
        if (expr != null && expr.startsWith("::")) {
            Eas_ObjectSelector selector;
            try {
                selector = new Eas_ObjectSelector(null);
            }
            catch (KDRSException e) {
                throw ReportException.makeException((String)MultiLanguageUtil.getMLS("r1note.NoteRptDesigner.consrtuctFailed"), (Throwable)e);
            }
            Object data = selector.getObject(expr);
            if (data == null) {
                log.error((Object)("Init note meta error. Invalid bos query:" + expr));
            } else {
                mc = (MetaClass)data;
            }
        } else {
            mc.getFields();
        }
        mc.setName(name);
        mc.setAlias(alias);
        return mc;
    }

    private class Saver
    implements ISaver {
        private boolean isReadOnly;

        public Saver(boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
        }

        private boolean isUserCancel(Exception ex) {
            for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof UserCancelException)) continue;
                return true;
            }
            return false;
        }

        public boolean save(Element root) {
            log.debug((Object)"Save R1Print template ...");
            if (this.isReadOnly) {
                NoteDistributionUtil.promptReadOnly(NoteRptDesigner.this.editor, MultiLanguageUtil.getMLS("r1note.NoteRptDesigner.save"));
                return false;
            }
            try {
                OutputStream out = ((IStreamStorage)NoteRptDesigner.this.getReportEnv().getReportStorage()).getOutputStream();
                XmlUtil.saveXmlStream((OutputStream)out, (Element)root);
            }
            catch (Exception ex) {
                if (!this.isUserCancel(ex)) {
                    String msg = MultiLanguageUtil.getMLS("r1note.NoteRptDesigner.saveFailed");
                    log.error((Object)msg, (Throwable)ex);
                    WindowUtil.showException((String)msg, (Throwable)ex, (String)MultiLanguageUtil.getMLS("r1note.NoteRptDesigner.saveTem"), (Component)NoteRptDesigner.this.editor);
                    return false;
                }
                return false;
            }
            NoteRptDesigner.this.fireSaveCompleted();
            return true;
        }
    }
}

