/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.r1note.dynquery.exec;

import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryCondition;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryEntityNode;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryFieldNode;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryModel;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryUtil;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.RTQueryJoinInfo;
import com.kingdee.bos.metadata.entity.RTQueryJoinItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;

public class NoteDynQuery2Bos {
    private NoteDynQueryModel _model;

    public NoteDynQuery2Bos(NoteDynQueryModel model) {
        this._model = model;
    }

    public void initEntityViewInfo(EntityViewInfo entityViewInfo) {
        NoteDynQuery2Bos.convert(entityViewInfo, this._model.getRootEntityNode());
        this.convertSort(entityViewInfo);
    }

    public EntityViewInfo toEntityViewInfo() {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        this.initEntityViewInfo(entityViewInfo);
        return entityViewInfo;
    }

    private void convertSort(EntityViewInfo bosEntityView) {
        NoteDynQueryFieldNode[] fields = this._model.getOrderByFields();
        for (int i = 0; i < fields.length; ++i) {
            NoteDynQueryFieldNode field = fields[i];
            SorterItemInfo item = new SorterItemInfo();
            item.setPropertyName(field.getFieldName());
            if (field.getOrderType() == 1) {
                item.setSortType(SortType.ASCEND);
            } else if (field.getOrderType() == 2) {
                item.setSortType(SortType.DESCEND);
            }
            bosEntityView.getSorter().add(item);
        }
    }

    private static void convert(EntityViewInfo bosEntityView, NoteDynQueryEntityNode noteDesignNode) {
        int i;
        int dynFieldCount;
        if (!noteDesignNode.isSystem()) {
            RTQueryJoinInfo join = new RTQueryJoinInfo();
            join.setLeftEntityName(noteDesignNode.getParent().getEntityName());
            join.setRightEntityName(noteDesignNode.getEntityName());
            EntityObjectInfo entity = NoteDynQueryUtil.getEntity(noteDesignNode.getBosObjectId());
            IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)entity.getFullName());
            join.setRightEntityPK(pk);
            join.setJoinType(noteDesignNode.getLinkType().toBOS());
            int c = noteDesignNode.getConditionsCount();
            for (int i2 = 0; i2 < c; ++i2) {
                NoteDynQueryCondition condition = noteDesignNode.getCondition(i2);
                RTQueryJoinItemInfo joinItem = new RTQueryJoinItemInfo();
                joinItem.setLeftFieldName(condition.getLeftField().getFieldName());
                joinItem.setRightFieldName(condition.getRightField().getFieldName());
                joinItem.setCompareType(condition.getCompareType());
                join.getRtQueryJoinItemInfos().add(joinItem);
            }
            bosEntityView.getRTQueryJoins().add(join);
        }
        if ((dynFieldCount = noteDesignNode.getSelectedFieldsCount()) > 0) {
            bosEntityView.setAppendSelectors(true);
        }
        for (i = 0; i < dynFieldCount; ++i) {
            NoteDynQueryFieldNode field = noteDesignNode.getSelectedField(i);
            SelectorItemInfo item = new SelectorItemInfo();
            item.setPropertyName(field.getFieldName());
            item.setDisplayName(field.getFieldAlias());
            item.getExtendedProperties().put("isDynQueryField", "true");
            bosEntityView.getSelector().add(item);
        }
        int c = noteDesignNode.getChildrenCount();
        for (i = 0; i < c; ++i) {
            NoteDynQuery2Bos.convert(bosEntityView, noteDesignNode.getChild(i));
        }
    }
}

