/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.r1note.dynquery.ui;

import com.kingdee.bos.ctrl.common.ui.ListView;
import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.ui.RenameDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.multilanguage.Language;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryEntityNode;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryFieldNode;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryModel;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.ui.EntityTabbedUI;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.ui.Icons;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.ui.NoteDynQueryEditor;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class FieldTabbedUI {
    public static String ORDER = "order";
    public static String RENAME = "rename";
    private KDPanel _panAll;
    private CustomSelector _fieldSelector;
    private KDTree _treSupply;
    private NoteDynQueryEditor.ITabbedSynchronizer _synchronizer;

    public FieldTabbedUI() {
        this.init();
    }

    private void init() {
        this._panAll = new KDPanel();
        this._fieldSelector = new CustomSelector();
        this._panAll.setLayout((LayoutManager)new BorderLayout());
        this._panAll.setCustomInsets(new Insets(8, 8, 8, 8));
        this._panAll.add((Component)((Object)this._fieldSelector), (Object)"Center");
        this.updateCtrl(null);
    }

    public JComponent getUI() {
        return this._panAll;
    }

    public void setTabbedSynchronizer(NoteDynQueryEditor.ITabbedSynchronizer synchronizer) {
        this._synchronizer = synchronizer;
    }

    public void updateCtrl(NoteDynQueryModel model) {
        this.updateCtrl_SupplyTree(model);
        this.updateCtrl_SelectedList(model);
    }

    private void updateCtrl_SelectedList(NoteDynQueryModel model) {
        this._fieldSelector.getSelectedList().removeAllElements();
        if (model == null) {
            return;
        }
        this.updateCtrl_InherentSelectedFields(model);
        this.updateCtrl_DynSelectedFields(model.getRootEntityNode());
        NoteDynQueryFieldNode[] orders = model.getOrderByFields();
        KDList listCtrl = this._fieldSelector.getSelectedList();
        block0: for (int i = orders.length - 1; i >= 0; --i) {
            NoteDynQueryFieldNode orderField = orders[i];
            for (int j = listCtrl.getElementCount() - 1; j >= 0; --j) {
                CustomListItem item = (CustomListItem)listCtrl.getElement(j);
                if (!item.fieldNode.getFieldName().equals(orderField.getFieldName())) continue;
                item.fieldNode.setOrderType(orderField.getOrderType());
                listCtrl.removeElement((Object)item);
                listCtrl.insertElement((Object)item, 0);
                continue block0;
            }
        }
        this.callSynchronizer(ORDER);
        NoteDynQueryFieldNode[] renameFileds = model.getRenameFields();
        block2: for (int i = 0; i < renameFileds.length; ++i) {
            NoteDynQueryFieldNode renameFiled = renameFileds[i];
            for (int j = listCtrl.getElementCount() - 1; j >= 0; --j) {
                CustomListItem item = (CustomListItem)listCtrl.getElement(j);
                if (!item.fieldNode.getFieldName().equals(renameFiled.getFieldName())) continue;
                item.fieldNode.setProperty(renameFiled.getProperties());
                item.fieldNode.setRenameAlias(true);
                listCtrl.setElement((Object)item, j);
                continue block2;
            }
        }
        if (listCtrl.getElementCount() > 0) {
            listCtrl.setSelectedValue(listCtrl.getElement(0), true);
        }
    }

    private void updateCtrl_InherentSelectedFields(NoteDynQueryModel model) {
        NoteDynQueryFieldNode[] fields = model.getMainQueryFields();
        for (int i = 0; i < fields.length; ++i) {
            this._fieldSelector.addListElement(fields[i], null);
        }
    }

    private void updateCtrl_DynSelectedFields(NoteDynQueryEntityNode entityNode) {
        int i;
        int c = entityNode.getSelectedFieldsCount();
        for (i = 0; i < c; ++i) {
            NoteDynQueryFieldNode fieldNode = entityNode.getSelectedField(i);
            this._fieldSelector.addListElement(fieldNode, entityNode);
        }
        c = entityNode.getChildrenCount();
        for (i = 0; i < c; ++i) {
            NoteDynQueryEntityNode childEntityNode = entityNode.getChild(i);
            this.updateCtrl_DynSelectedFields(childEntityNode);
        }
    }

    private void updateCtrl_SupplyTree(NoteDynQueryModel model) {
        if (model == null) {
            this._treSupply.setModel((TreeModel)new KingdeeTreeModel((TreeNode)new DefaultKingdeeTreeNode((Object)"Error")));
            this._treSupply.setRootVisible(false);
            return;
        }
        DefaultKingdeeTreeNode root = FieldTabbedUI.createTreeNode(model.getRootEntityNode());
        this._treSupply.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this._treSupply.setRootVisible(true);
        this._treSupply.expandPath(new TreePath(root));
        this._treSupply.setSelectionPath(new TreePath(root));
    }

    private static DefaultKingdeeTreeNode createTreeNode(NoteDynQueryEntityNode entityNode) {
        DefaultKingdeeTreeNode entityTreeNode = EntityTabbedUI.createTreeNode(entityNode);
        if (!StringUtil.isEmptyString((String)entityNode.getEntityAlias())) {
            StringBuffer sb = new StringBuffer();
            sb.append(entityNode.getEntityAlias());
            sb.append(" (");
            sb.append(entityNode.getEntityName());
            sb.append(")");
            entityTreeNode.setText(sb.toString());
        }
        int c = entityNode.getChildrenCount();
        for (int i = 0; i < c; ++i) {
            entityTreeNode.add((MutableTreeNode)FieldTabbedUI.createTreeNode(entityNode.getChild(i)));
        }
        NoteDynQueryFieldNode[] fields = entityNode.getAllFields();
        int c2 = fields.length;
        for (int i = 0; i < c2; ++i) {
            DefaultKingdeeTreeNode fieldTreeNode = new DefaultKingdeeTreeNode((Object)fields[i]);
            entityTreeNode.add((MutableTreeNode)fieldTreeNode);
        }
        return entityTreeNode;
    }

    public void updateModel_OrderBy(NoteDynQueryModel model) {
        model.removeAllOrderByFields();
        KDList listCtrl = this._fieldSelector.getSelectedList();
        int c = listCtrl.getElementCount();
        for (int i = 0; i < c; ++i) {
            CustomListItem item = (CustomListItem)listCtrl.getElement(i);
            if (!item.fieldNode.isOrderBy()) continue;
            model.addOrderByField(item.fieldNode);
        }
    }

    public void updateModel_RenameField(NoteDynQueryModel model) {
        model.removeAllRenameFields();
        KDList listCtrl = this._fieldSelector.getSelectedList();
        int c = listCtrl.getElementCount();
        for (int i = 0; i < c; ++i) {
            CustomListItem item = (CustomListItem)listCtrl.getElement(i);
            if (!item.fieldNode.isRenameAlias()) continue;
            model.addRenameField(item.fieldNode);
        }
    }

    private void callSynchronizer(String tyep) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", tyep);
        this._synchronizer.announce(params);
    }

    private static class CustomListCellRender
    extends DefaultKingdeeListCellRenderer {
        private CustomListCellRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component ctrl = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            CustomListItem item = (CustomListItem)value;
            NoteDynQueryFieldNode field = item.fieldNode;
            if (!field.isSystem()) {
                Color fc = Color.BLUE;
                Color bc = list.getBackground();
                if (isSelected) {
                    ctrl.setForeground(bc);
                    ctrl.setBackground(fc);
                } else {
                    ctrl.setForeground(fc);
                    ctrl.setBackground(bc);
                }
            }
            if (field.isOrderBy()) {
                if (field.getOrderType() == 1) {
                    this.setIcon(Icons.ItemHeader_ORDER_ASC);
                } else {
                    this.setIcon(Icons.ItemHeader_ORDER_DESC);
                }
            } else {
                this.setIcon(Icons.ItemHeader_EMPTY);
            }
            return ctrl;
        }
    }

    private static class CustomListItem {
        NoteDynQueryEntityNode entityNode;
        NoteDynQueryFieldNode fieldNode;

        private CustomListItem() {
        }

        public String toString() {
            return this.fieldNode.toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CustomListItem) {
                CustomListItem another = (CustomListItem)obj;
                return this.fieldNode.equals(another.fieldNode);
            }
            return false;
        }
    }

    private class CustomSelector
    extends NormalSelector {
        public CustomSelector() {
            FieldTabbedUI.this._treSupply = new KDTree();
            FieldTabbedUI.this._treSupply.setShowsRootHandles(true);
            this.setSupplyCtrl((JComponent)FieldTabbedUI.this._treSupply);
            this.setSupplyTitle(MultiLanguageUtil.getMLS("ui.FieldTabbedUI.fieldSupplyTitle"));
            this.setSelectedTitle(MultiLanguageUtil.getMLS("ui.FieldTabbedUI.fieldSelectedTitle"));
            this.btnSelectAll.setEnabled(false);
            this.btnDeleteAll.setEnabled(false);
            this.getSelectedList().setCellRenderer((ListCellRenderer)((Object)new CustomListCellRender()));
            this.getSelected().addButton((Action)new ChangeOrderAction(), "order");
            this.getSelected().addButton((Action)new FiledRenameAction(), "rename");
            SyncHandler syncHandler = new SyncHandler();
            this.getSelected().getButton(ListView.BUTTON_MOVE_UP).addActionListener((ActionListener)syncHandler);
            this.getSelected().getButton(ListView.BUTTON_MOVE_DOWN).addActionListener((ActionListener)syncHandler);
        }

        private void addListElement(NoteDynQueryFieldNode fieldNode, NoteDynQueryEntityNode entityNode) {
            CustomListItem item = new CustomListItem();
            item.entityNode = entityNode;
            item.fieldNode = fieldNode;
            this.getSelectedList().addElement((Object)item);
        }

        protected void syncListViewButton() {
            super.syncListViewButton();
            this.btnDeleteAll.setEnabled(false);
        }

        protected void onSelect() {
            if (FieldTabbedUI.this._treSupply.getSelectionCount() == 0) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("ui.FieldTabbedUI.nonSelectedFieldPrompt"), (String)MultiLanguageUtil.getMLS("ui.FieldTabbedUI.addField"), (Component)((Object)this));
                return;
            }
            List supplySelecteds = this.getSupplySelectedFields();
            if (supplySelecteds == null) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("ui.FieldTabbedUI.onlyFieldCanSelectedPrompt"), (String)MultiLanguageUtil.getMLS("ui.FieldTabbedUI.addField"), (Component)((Object)this));
                return;
            }
            StringBuffer sbPrompt = new StringBuffer();
            boolean isAdded = false;
            for (CustomListItem item : supplySelecteds) {
                NoteDynQueryFieldNode fieldNode = item.fieldNode;
                NoteDynQueryEntityNode entityNode = item.entityNode;
                String newFieldName = entityNode.getEntityName() + "." + fieldNode.getFieldName();
                NoteDynQueryFieldNode newFieldNode = new NoteDynQueryFieldNode(newFieldName, fieldNode.getFieldAlias());
                newFieldNode.setSystem(false);
                item.fieldNode = newFieldNode;
                if (this.getSelectedList().isContainsElement((Object)item)) {
                    if (sbPrompt.length() > 0) {
                        sbPrompt.append("\u3001");
                    }
                    sbPrompt.append(fieldNode);
                    continue;
                }
                entityNode.addSelectedField(newFieldNode);
                this.addListElement(newFieldNode, entityNode);
                isAdded = true;
            }
            if (sbPrompt.length() > 0) {
                sbPrompt.insert(0, MultiLanguageUtil.getMLS("ui.FieldTabbedUI.field"));
                sbPrompt.append(MultiLanguageUtil.getMLS("ui.FieldTabbedUI.hasSelectedFieldPrompt1"));
                if (isAdded) {
                    sbPrompt.append(MultiLanguageUtil.getMLS("ui.FieldTabbedUI.hasSelectedFieldPrompt2"));
                }
                WindowUtil.msgboxWarning((Object)sbPrompt.toString(), (String)MultiLanguageUtil.getMLS("ui.FieldTabbedUI.addField"), (Component)((Object)this));
            }
            if (isAdded) {
                int idx = this.getSelectedList().getElementCount() - 1;
                this.getSelectedList().setSelectedValue(this.getSelectedList().getElement(idx), true);
            }
        }

        private List getSupplySelectedFields() {
            ArrayList<CustomListItem> result = new ArrayList<CustomListItem>();
            TreePath[] paths = FieldTabbedUI.this._treSupply.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)paths[i].getLastPathComponent();
                if (!(treeNode.getUserObject() instanceof NoteDynQueryFieldNode)) {
                    return null;
                }
                DefaultKingdeeTreeNode parentTreeNode = (DefaultKingdeeTreeNode)treeNode.getParent();
                CustomListItem item = new CustomListItem();
                item.entityNode = (NoteDynQueryEntityNode)parentTreeNode.getUserObject();
                item.fieldNode = (NoteDynQueryFieldNode)treeNode.getUserObject();
                result.add(item);
            }
            return result;
        }

        protected boolean onDelete() {
            CustomListItem item;
            int i;
            boolean isContainsSystem = false;
            Object[] selecteds = this.getSelectedList().getSelectedValues();
            for (i = 0; i < selecteds.length; ++i) {
                item = (CustomListItem)selecteds[i];
                if (!item.fieldNode.isSystem()) continue;
                isContainsSystem = true;
                break;
            }
            if (isContainsSystem) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("ui.FieldTabbedUI.canNotDeleteFieldPrompt"), (String)MultiLanguageUtil.getMLS("ui.FieldTabbedUI.deleteField"), (Component)((Object)this));
                return false;
            }
            if (super.onDelete()) {
                for (i = 0; i < selecteds.length; ++i) {
                    item = (CustomListItem)selecteds[i];
                    item.entityNode.removeSelectedField(item.fieldNode);
                }
                return true;
            }
            return false;
        }
    }

    private class SyncHandler
    implements ActionListener {
        private SyncHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedObj = FieldTabbedUI.this._fieldSelector.getSelectedList().getSelectedValue();
            if (selectedObj != null) {
                CustomListItem item = (CustomListItem)selectedObj;
                if (item.fieldNode.isOrderBy()) {
                    FieldTabbedUI.this.callSynchronizer(ORDER);
                } else {
                    WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("ui.FieldTabbedUI.upDownPrompt"), (String)MultiLanguageUtil.getMLS("ui.FieldTabbedUI.field"), (Component)FieldTabbedUI.this._panAll);
                }
            }
        }
    }

    private class FiledRenameAction
    extends AbstractAction {
        NoteDynQueryFieldNode field;

        public FiledRenameAction() {
            this.putValue("SmallIcon", Resource.ICON_RENAME);
            this.putValue("ShortDescription", MultiLanguageUtil.getMLS("ui.FieldTabbedUI.rename"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedCount = FieldTabbedUI.this._fieldSelector.getSelectedList().getSelectedIndices().length;
            if (selectedCount != 1) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("ui.FieldTabbedUI.singleSelectFieldPrompt"), (String)MultiLanguageUtil.getMLS("ui.FieldTabbedUI.rename"), (Component)FieldTabbedUI.this._panAll);
                return;
            }
            CustomListItem item = (CustomListItem)FieldTabbedUI.this._fieldSelector.getSelectedList().getSelectedValue();
            this.field = item.fieldNode;
            FieldRenameDialog dialog = new FieldRenameDialog((Dialog)SwingUtilities.getWindowAncestor((Component)FieldTabbedUI.this._panAll));
            dialog.setOldName(this.field.getFieldName());
            dialog.setNameEnabled(false);
            HashMap aliasMap = new HashMap();
            String language = Language.locale2Language(Locale.getDefault()).getName();
            if (this.field.isRenameAlias()) {
                aliasMap = (HashMap)this.field.getProperties();
            }
            if (aliasMap.get(language) == null || aliasMap.get(language) == "") {
                aliasMap.put(language, this.field.getFieldAlias());
            }
            dialog.setOldAlias(aliasMap);
            if (dialog.showDialog()) {
                this.field.setProperty(dialog.getNewAlias());
                this.field.setRenameAlias(true);
                FieldTabbedUI.this.callSynchronizer(RENAME);
            }
            FieldTabbedUI.this._fieldSelector.getSelectedList().repaint();
        }

        private class FieldRenameDialog
        extends RenameDialog {
            public FieldRenameDialog(Dialog owner) {
                super(owner);
            }

            protected void todoInit() {
                super.todoInit();
                KDButton reduce = new KDButton(MultiLanguageUtil.getMLS("ui.FieldTabbedUI.revert"));
                reduce.setToolTipText(MultiLanguageUtil.getMLS("ui.FieldTabbedUI.revertAlias"));
                this.getExtPanel().setLayout((LayoutManager)new BorderLayout());
                this.getExtPanel().add((Component)reduce, (Object)"West");
                if (!FiledRenameAction.this.field.isRenameAlias()) {
                    reduce.setEnabled(false);
                }
                reduce.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FiledRenameAction.this.field.setRenameAlias(false);
                        FiledRenameAction.this.field.setProperty(null);
                        FieldTabbedUI.this.callSynchronizer(RENAME);
                        FieldRenameDialog.this.onCancel();
                    }
                });
            }
        }
    }

    private class ChangeOrderAction
    extends AbstractAction {
        public ChangeOrderAction() {
            this.putValue("SmallIcon", Icons.BtnIcon_ORDER);
            this.putValue("ShortDescription", MultiLanguageUtil.getMLS("ui.FieldTabbedUI.sort"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedCount = FieldTabbedUI.this._fieldSelector.getSelectedList().getSelectedIndices().length;
            if (selectedCount != 1) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("ui.FieldTabbedUI.singleSelectFieldPrompt"), (String)MultiLanguageUtil.getMLS("ui.FieldTabbedUI.sort"), (Component)FieldTabbedUI.this._panAll);
                return;
            }
            CustomListItem item = (CustomListItem)FieldTabbedUI.this._fieldSelector.getSelectedList().getSelectedValue();
            NoteDynQueryFieldNode field = item.fieldNode;
            switch (field.getOrderType()) {
                case 0: {
                    field.setOrderType(1);
                    break;
                }
                case 1: {
                    field.setOrderType(2);
                    break;
                }
                case 2: {
                    field.setOrderType(0);
                    break;
                }
            }
            FieldTabbedUI.this._fieldSelector.getSelectedList().repaint();
            FieldTabbedUI.this.callSynchronizer(ORDER);
        }
    }
}

