/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.r1note.dynquery.ui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.ExceptionUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.exception.NoteDynQuery_LoadException;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.exception.NoteDynQuery_MainQueryParseException;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.exec.NoteDynQueryExecuter;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryModel;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.ui.NoteDynQueryEditor;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyOpenedException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportEnv;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.InvalidTemplateException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.UnsupportedStorageException;
import com.kingdee.bos.ctrl.reportone.reportframework.design.AReportDesigner;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class NoteDynQueryRptDesigner
extends AReportDesigner {
    private static final Logger log = LogUtil.getPackageLogger(NoteDynQueryRptDesigner.class);
    private Container editorCtrl;

    public NoteDynQueryRptDesigner(Component owner) {
        super(owner);
    }

    public void design(boolean isNew, HashMap args) throws ReportException {
        if (this.editorCtrl != null) {
            throw new AlreadyOpenedException();
        }
        IReportEnv rptEnv = this.getReportEnv();
        IReportStorage rptSto = rptEnv.getReportStorage();
        if (!(rptSto instanceof IStreamStorage)) {
            throw new UnsupportedStorageException();
        }
        NoteDynQueryEditor editor = new NoteDynQueryEditor();
        this.editorCtrl = editor.getCtrl();
        CustomDialog dialog = CustomDialog.create(this.owner);
        dialog.setEditor(editor);
        dialog.setTitle(MultiLanguageUtil.getMLS("ui.NoteDynQueryRptDesigner.noteDynQueryDesigner"));
        if (!isNew) {
            NoteDynQueryModel model = this.loadModel();
            if (model == null) {
                return;
            }
            editor.setModel(model);
        }
        if (!dialog.showDialog()) {
            this.fireWindowClosed();
            throw new UserCancelException();
        }
        this.saveModel(editor.getModel());
        this.fireSaveCompleted();
        this.fireWindowClosed();
    }

    public void close() throws ReportException {
        this.editorCtrl = null;
    }

    public Component getComponent() throws ReportException {
        return this.editorCtrl;
    }

    private NoteDynQueryModel loadModel() throws ReportException {
        Element xml;
        IReportStorage rptSto = this.getReportEnv().getReportStorage();
        InputStream stream = ((IStreamStorage)rptSto).getInputStream();
        try {
            xml = XmlUtil.loadXmlStream((InputStream)stream);
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            StringBuffer sb = new StringBuffer();
            sb.append(MultiLanguageUtil.getMLS("ui.NoteDynQueryRptDesigner.load_FileError"));
            sb.append(StringUtil.RETURN);
            sb.append(ExceptionUtil.findMessage((Throwable)ex));
            WindowUtil.msgboxError((Object)sb.toString(), (String)MultiLanguageUtil.getMLS("ui.NoteDynQueryRptDesigner.noteDynQuery"), (Component)this.owner);
            return null;
        }
        try {
            NoteDynQueryModel model = NoteDynQueryModel.fromXml(xml);
            return model;
        }
        catch (NoteDynQuery_MainQueryParseException ex) {
            log.error((Object)"", (Throwable)ex);
            StringBuffer sb = new StringBuffer();
            sb.append(MultiLanguageUtil.getMLS("ui.NoteDynQueryRptDesigner.load_MainQueryError"));
            sb.append(StringUtil.RETURN);
            sb.append(ExceptionUtil.findMessage((Throwable)ex));
            WindowUtil.msgboxError((Object)sb.toString(), (String)MultiLanguageUtil.getMLS("ui.NoteDynQueryRptDesigner.noteDynQuery"), (Component)this.owner);
            return null;
        }
        catch (NoteDynQuery_LoadException ex) {
            log.error((Object)"", (Throwable)ex);
            NoteDynQueryModel model = ex.getInvalidModel();
            StringBuffer sb = new StringBuffer();
            sb.append(MultiLanguageUtil.getMLS("ui.NoteDynQueryRptDesigner.laod_OtherMetaError"));
            sb.append(StringUtil.RETURN);
            sb.append(MultiLanguageUtil.getMLS("ui.NoteDynQueryRptDesigner.errorDetail"));
            sb.append(StringUtil.RETURN);
            sb.append(ExceptionUtil.findMessage((Throwable)ex));
            WindowUtil.msgboxWarning((Object)sb.toString(), (String)MultiLanguageUtil.getMLS("ui.NoteDynQueryRptDesigner.noteDynQuery"), (Component)this.owner);
            return model;
        }
    }

    private void saveModel(NoteDynQueryModel model) throws ReportException {
        IReportStorage rptSto = this.getReportEnv().getReportStorage();
        OutputStream stream = ((IStreamStorage)rptSto).getOutputStream();
        try {
            Element xml = model.toXml();
            XmlUtil.saveXmlStream((OutputStream)stream, (Element)xml);
        }
        catch (Exception ex) {
            throw new InvalidTemplateException("Save is not completed.", (Throwable)ex);
        }
    }

    private static class PreviewActionHandler
    extends AbstractAction {
        private NoteDynQueryEditor editor;

        public PreviewActionHandler(NoteDynQueryEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int top = 10;
            NoteDynQueryModel model = this.editor.getModel();
            NoteDynQueryExecuter executer = new NoteDynQueryExecuter(model);
            executer.setTop(top);
            IRowSet rowSet = null;
            try {
                rowSet = executer.execute();
            }
            catch (BOSException ex) {
                log.error((Object)"", (Throwable)ex);
                return;
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                return;
            }
            KDTable table = new KDTable();
            try {
                PreviewActionHandler.bindResultSet(table, (ResultSet)rowSet);
            }
            catch (SQLException ex) {
                log.error((Object)"", (Throwable)ex);
                return;
            }
            SimpleDialog dlg = SimpleDialog.create((Component)this.editor.getCtrl());
            dlg.hideCancelButton();
            dlg.setComponent((Component)table);
            dlg.setTitle(MultiLanguageUtil.getMLS("ui.NoteDynQueryRptDesigner.previewTitle1") + top + MultiLanguageUtil.getMLS("ui.NoteDynQueryRptDesigner.previewTitle2"));
            dlg.showDialog();
        }

        private static void bindResultSet(KDTable table, ResultSet rs) throws SQLException {
            table.removeRows();
            table.removeColumns();
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            table.addColumns(cols);
            IRow headRow = table.addHeadRow();
            for (int i = 0; i < cols; ++i) {
                StringBuffer title = new StringBuffer();
                title.append(rsmd.getColumnLabel(i + 1));
                title.append("(");
                title.append(rsmd.getColumnName(i + 1));
                title.append(")");
                headRow.getCell(i).setValue((Object)title);
            }
            int row = 0;
            while (rs.next()) {
                table.addRow();
                for (int col = 0; col < cols; ++col) {
                    Object value = rs.getObject(col + 1);
                    table.getCell(row, col).setValue(value);
                }
                ++row;
            }
        }
    }

    private static class CustomDialog
    extends TypicalDialog {
        private NoteDynQueryEditor editor;

        public static CustomDialog create(Component parentCtrl) {
            Window owner = SwingUtilities.getWindowAncestor(parentCtrl);
            if (owner instanceof Dialog) {
                return new CustomDialog((Dialog)owner);
            }
            if (owner instanceof Frame) {
                return new CustomDialog((Frame)owner);
            }
            return new CustomDialog();
        }

        public CustomDialog() {
        }

        public CustomDialog(Dialog owner) {
            super(owner);
        }

        public CustomDialog(Frame owner) {
            super(owner);
        }

        public void setEditor(NoteDynQueryEditor editor) {
            this.editor = editor;
        }

        protected void todoInit() {
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            parent.add((Component)this.editor.getCtrl(), thisCell);
            this.addKeyListener();
        }

        protected boolean verify() {
            return this.editor.verify();
        }

        protected void onCancel() {
            super.onCancel();
        }

        private void addKeyListener() {
            KeyStroke ks_f5 = KeyStroke.getKeyStroke(116, 0);
            InputMap inputMap = this.getRootPane().getInputMap(2);
            inputMap.put(ks_f5, "NoteDynQuery_Preview");
            this.getRootPane().getActionMap().put("NoteDynQuery_Preview", new PreviewActionHandler(this.editor));
        }
    }
}

