/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.collection;

import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.ArrayList;
import com.kingdee.bos.olap.collection.CacheableArrayList;
import com.kingdee.bos.olap.collection.IInnerList;
import com.kingdee.bos.olap.collection.IStorageManager;
import com.kingdee.bos.olap.collection.ListSortUtil;
import com.kingdee.bos.olap.collection.Resetable;
import com.kingdee.bos.olap.collection.UnionList;
import com.kingdee.bos.olap.util.ObjectComparator;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class JoinList
implements IInnerList {
    private IInnerList list1;
    private IInnerList list2;
    private int c1 = -1;
    private int c2 = -1;
    boolean isMember = false;

    JoinList(IInnerList list1, IInnerList list2) {
        this.list1 = list1;
        this.list2 = list2;
    }

    public IInnerList getList1() {
        return this.list1;
    }

    public IInnerList getList2() {
        return this.list2;
    }

    @Override
    public IInnerList innerAdd(Object o) {
        return new UnionList(this, ArrayList.newOne(o));
    }

    @Override
    public IInnerList innerAddList(IInnerList list) {
        if (list == this) {
            throw new IllegalArgumentException("List can't addList itself.");
        }
        return new UnionList(this, list);
    }

    @Override
    public IInnerList innerAddFirst(Object o) {
        ArrayList solist = ArrayList.newOne(o);
        return solist.innerAddList(this);
    }

    @Override
    public IInnerList innerAddArray(Object[] objects) {
        IInnerList alist = new ArrayList();
        alist = alist.innerAddArray(objects);
        return new UnionList(this, alist);
    }

    @Override
    public Object get(int index) {
        this.rangeCheck(index);
        int m = index / this.list2.size();
        int n = index % this.list2.size();
        return this.get(m, n);
    }

    public Object get(int x, int y) {
        Object o1 = this.list1.get(x);
        Object o2 = this.list2.get(y);
        return this.createJoinObject(o1, o2);
    }

    protected Object createJoinObject(Object o1, Object o2) {
        if (this.c1 == -1) {
            if (o1 instanceof Object[]) {
                Object[] os1 = (Object[])o1;
                this.c1 = os1.length;
                this.isMember = os1[0] instanceof Member;
            } else {
                this.c1 = 1;
                this.isMember = o1 instanceof Member;
            }
            if (o2 instanceof Object[]) {
                Object[] os2 = (Object[])o2;
                this.c2 = os2.length;
            } else {
                this.c2 = 1;
            }
        }
        Object[] result = null;
        result = this.isMember ? new Member[this.c1 + this.c2] : new Object[this.c1 + this.c2];
        if (this.c1 == 1 && this.c2 == 1) {
            result[0] = o1;
            result[1] = o2;
        } else if (this.c1 == 1 && this.c2 > 1) {
            result[0] = o1;
            System.arraycopy(o2, 0, result, 1, this.c2);
        } else if (this.c1 > 1 && this.c2 == 1) {
            System.arraycopy(o1, 0, result, 0, this.c1);
            result[this.c1] = o2;
        } else {
            System.arraycopy(o1, 0, result, 0, this.c1);
            System.arraycopy(o2, 0, result, this.c1, this.c2);
        }
        return result;
    }

    @Override
    public Iterator iterator() {
        return new Itr();
    }

    @Override
    public int size() {
        return this.list1.size() * this.list2.size();
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IInnerList subList(int begin, int end) {
        if (begin == end) {
            return IInnerList.EMPTY;
        }
        if (begin > end) {
            throw new IllegalArgumentException("Illegal Argument subList(" + begin + "," + end + ")");
        }
        if (begin < 0 || end > this.size()) {
            throw new IndexOutOfBoundsException("subList(" + begin + "," + end + "),size=" + this.size());
        }
        int len = end - begin;
        if (len < 0) {
            ArrayList alist = new ArrayList();
            Object[] objects = new Object[len];
            for (int i = 0; i < len; ++i) {
                objects[i] = this.get(i + begin);
            }
            return alist.innerAddArray(objects);
        }
        int beginA = begin / this.list2.size();
        int beginB = begin % this.list2.size();
        int endA = end / this.list2.size();
        int endB = end % this.list2.size();
        int lenA = endA - beginA;
        if (lenA == 0 || lenA == 1 && endB == 0) {
            IInnerList listOne = null;
            listOne = new ArrayList();
            Object objectA = this.list1.get(beginA);
            if (endB == 0) {
                endB = this.list2.size();
            }
            for (int i = beginB; i < endB; ++i) {
                Object objectB = this.list2.get(i);
                listOne = listOne.innerAdd(this.createJoinObject(objectA, objectB));
            }
            return listOne;
        }
        if (beginB == 0 && endB == 0) {
            IInnerList listA = this.list1.subList(beginA, beginA + lenA);
            return new JoinList(listA, this.list2);
        }
        if (beginB == 0) {
            IInnerList listA = this.list1.subList(beginA, endA);
            JoinList listOne = new JoinList(listA, this.list2);
            Object objectA = this.list1.get(endA);
            IInnerList listTwo = new ArrayList();
            for (int i = 0; i < endB; ++i) {
                Object objectB = this.list2.get(i);
                listTwo = listTwo.innerAdd(this.createJoinObject(objectA, objectB));
            }
            return new UnionList(listOne, listTwo);
        }
        if (endB == 0) {
            Object objectA = this.list1.get(beginA);
            IInnerList listOne = new ArrayList();
            for (int i = beginB; i < this.list2.size(); ++i) {
                Object objectB = this.list2.get(i);
                listOne = listOne.innerAdd(this.createJoinObject(objectA, objectB));
            }
            IInnerList listA = this.list1.subList(beginA + 1, endA);
            JoinList listTwo = new JoinList(listA, this.list2);
            return new UnionList(new IInnerList[]{listOne, listTwo});
        }
        Object objectA = this.list1.get(beginA);
        IInnerList listOne = new ArrayList();
        for (int i = beginB; i < this.list2.size(); ++i) {
            Object objectB = this.list2.get(i);
            listOne = listOne.innerAdd(this.createJoinObject(objectA, objectB));
        }
        IInnerList listA = this.list1.subList(beginA + 1, endA);
        JoinList listTwo = new JoinList(listA, this.list2);
        objectA = this.list1.get(endA);
        IInnerList listThree = new ArrayList();
        for (int i = 0; i < endB; ++i) {
            Object objectB = this.list2.get(i);
            listThree = listThree.innerAdd(this.createJoinObject(objectA, objectB));
        }
        if (listTwo.isEmpty()) {
            return new UnionList(new IInnerList[]{listOne, listThree});
        }
        return new UnionList(new IInnerList[]{listOne, listTwo, listThree});
    }

    @Override
    public boolean contains(Object o) {
        Object[] two;
        if (this.isEmpty()) {
            return false;
        }
        if (!(o instanceof Object[])) {
            return false;
        }
        Object o1 = this.list1.getFirst();
        Object o2 = this.list2.getFirst();
        int len1 = 1;
        int len2 = 1;
        if (o1 instanceof Object[]) {
            len1 = ((Object[])o1).length;
        }
        if (o2 instanceof Object[]) {
            len2 = ((Object[])o2).length;
        }
        return this.list1.contains((two = this.decomposite((Object[])o, len1, len2))[0]) && this.list2.contains(two[1]);
    }

    private Object[] decomposite(Object[] objects, int len1, int len2) {
        boolean isMember = objects[0] instanceof Member;
        Object[] one = null;
        one = isMember ? new Member[len1] : new Object[len1];
        System.arraycopy(objects, 0, one, 0, len1);
        Object[] two = null;
        two = isMember ? new Member[len2] : new Object[len2];
        System.arraycopy(objects, len1, two, 0, len2);
        return new Object[]{one, two};
    }

    @Override
    public Object[] toArray(Object[] a) {
        a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        int index = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            a[index++] = iter.next();
        }
        return a;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.size()];
        int index = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            a[index++] = iter.next();
        }
        return a;
    }

    @Override
    public Object getFirst() {
        return this.createJoinObject(this.list1.getFirst(), this.list2.getFirst());
    }

    @Override
    public Object getLast() {
        return this.createJoinObject(this.list1.getLast(), this.list2.getLast());
    }

    @Override
    public boolean isSorted() {
        return this.list1.isSorted() && this.list2.isSorted();
    }

    @Override
    public IInnerList sort(ObjectComparator comparator) throws OLAPException {
        return new ListSortUtil(this).sort(comparator);
    }

    @Override
    public int realSize() {
        return this.list1.realSize() + this.list2.realSize();
    }

    @Override
    public void doCache(IStorageManager storageManager) {
        IInnerList[] lists = new IInnerList[]{this.list1, this.list2};
        for (int i = 0; i < 2; ++i) {
            ArrayList alist;
            IInnerList list = lists[i];
            if (list instanceof ArrayList && (alist = (ArrayList)list).size() >= 5000) {
                CacheableArrayList calist = new CacheableArrayList(storageManager, alist);
                lists[i] = calist;
            }
            lists[i].doCache(storageManager);
        }
    }

    class Itr
    implements Iterator,
    Resetable {
        private Iterator itr1;
        private Iterator itr2;
        boolean reseted = false;
        boolean itr2Reseted = false;
        boolean isEmpty = false;
        boolean passHasNext = false;
        private Object o1;

        public Itr() {
            if (JoinList.this.list1.isEmpty() || JoinList.this.list2.isEmpty()) {
                this.isEmpty = true;
            } else {
                this.itr1 = JoinList.this.list1.iterator();
                this.itr2 = JoinList.this.list2.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.isEmpty) {
                return false;
            }
            this.passHasNext = true;
            if (this.itr2.hasNext()) {
                return true;
            }
            if (this.itr1.hasNext()) {
                ((Resetable)((Object)this.itr2)).reset();
                this.itr2Reseted = true;
                return true;
            }
            return false;
        }

        public Object next() {
            try {
                if (!this.passHasNext && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.passHasNext = false;
                if (this.o1 == null) {
                    this.o1 = this.itr1.next();
                } else if (this.itr2Reseted) {
                    this.o1 = this.itr1.next();
                    this.itr2Reseted = false;
                }
                Object o2 = this.itr2.next();
                return JoinList.this.createJoinObject(this.o1, o2);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            ((Resetable)((Object)this.itr1)).reset();
            ((Resetable)((Object)this.itr2)).reset();
            this.reseted = true;
            this.o1 = null;
            this.passHasNext = false;
        }
    }
}

