/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.Lexer;
import com.kingdee.bos.olap.mdx.MdxParseException;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.parser;
import java.io.Serializable;
import java.io.StringReader;
import java_cup.runtime.Symbol;
import org.apache.log4j.Logger;

public class ParserHelp {
    private static Logger logger = CommonLogger.getLogger(ParserHelp.class);

    public static Exp parseExpression(String expression) throws OLAPException {
        try {
            StringReader reader = new StringReader(expression);
            Lexer lexer = new Lexer(reader);
            parser p = new parser(lexer);
            Symbol parse_tree = null;
            parse_tree = p.parse();
            Exp exp = (Exp)parse_tree.value;
            return exp;
        }
        catch (OLAPException e) {
            logger.info((Object)("\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519:" + expression));
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)("\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519:" + expression));
            throw new MdxParseException(e.getMessage());
        }
    }

    public static MdxQuery parseQuery(Connection connection, String mdx) throws OLAPException {
        long t1 = System.currentTimeMillis();
        try {
            StringReader reader = new StringReader(mdx);
            Lexer lexer = new Lexer(reader);
            parser p = new parser(lexer);
            Symbol parse_tree = null;
            parse_tree = p.parse();
            MdxQuery query = (MdxQuery)parse_tree.value;
            query.afterParse(connection);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parseQuery mdx cost " + (System.currentTimeMillis() - t1) + "ms.mdx is\n" + mdx));
            }
            return query;
        }
        catch (OLAPException e) {
            logger.info((Object)("mdx\u89e3\u6790\u51fa\u9519:" + mdx));
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)("mdx\u89e3\u6790\u51fa\u9519:" + mdx));
            if (e instanceof Serializable) {
                throw new MdxParseException(e);
            }
            throw new MdxParseException(e.getMessage());
        }
    }
}

