/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.Set;
import com.kingdee.bos.olap.mdx.elementexp.DimensionExpr;
import com.kingdee.bos.olap.mdx.elementexp.HierarchyExpr;
import com.kingdee.bos.olap.mdx.elementexp.LevelExpr;
import com.kingdee.bos.olap.mdx.elementexp.MemberExpr;
import com.kingdee.bos.olap.mdx.elementexp.NamedSetExpr;
import com.kingdee.bos.olap.util.Util;
import java.util.Iterator;

public class SchemaLookup {
    public static Member lookupHierarchyRootMember(SchemaReader reader, Hierarchy hierarchy, String memberName) throws OLAPException {
        Member rootMember;
        IMemberList rootMembers = reader.getHierarchyRootMembers(hierarchy);
        Iterator iter = rootMembers.iterator();
        while (iter.hasNext()) {
            Member rootMember2 = (Member)iter.next();
            if (!(rootMember2.isMeasure() ? rootMember2.getName().equalsIgnoreCase(memberName) : rootMember2.getName().equals(memberName))) continue;
            return rootMember2;
        }
        if (rootMembers.size() == 1 && (rootMember = (Member)rootMembers.getFirst()).isAll()) {
            return (Member)rootMember.lookupChild(reader, memberName);
        }
        return null;
    }

    public static Member lookupLevelMember(SchemaReader reader, Level level, String memberName) throws OLAPException {
        IMemberList ms = reader.getLevelMembers(level);
        Iterator iter = ms.iterator();
        while (iter.hasNext()) {
            Member m = (Member)iter.next();
            if (!m.getName().equals(memberName)) continue;
            return m;
        }
        return null;
    }

    public static Member lookupHierarchyLeafMember(SchemaReader reader, Hierarchy hierarchy, String memberName) throws OLAPException {
        if (!hierarchy.getDimension().isParentChildrenDimension()) {
            Level[] levels = hierarchy.getLevels();
            Level level = levels[levels.length - 1];
            IMemberList ms = reader.getLevelMembers(level);
            Iterator iter = ms.iterator();
            while (iter.hasNext()) {
                Member m = (Member)iter.next();
                if (!m.getName().equals(memberName)) continue;
                return m;
            }
        } else {
            IMemberList children = reader.getHierarchyRootMembers(hierarchy);
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                Member child = (Member)iter.next();
                if (!child.isLeaf()) {
                    Member m = SchemaLookup.lookupLeafMember(reader, child, memberName);
                    if (m == null) continue;
                    return m;
                }
                if (!child.getName().equals(memberName)) continue;
                return child;
            }
        }
        return null;
    }

    private static Member lookupLeafMember(SchemaReader reader, Member member, String memberName) throws OLAPException {
        IMemberList children = reader.getMemberChildren(member);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Member child = (Member)iter.next();
            if (!child.isLeaf()) {
                Member m = SchemaLookup.lookupLeafMember(reader, child, memberName);
                if (m == null) continue;
                return m;
            }
            if (!child.getName().equals(memberName)) continue;
            return child;
        }
        return null;
    }

    public static Member getFirstDescendantOnLevel(SchemaReader reader, Member parent, Level level) throws OLAPException {
        Member m = parent;
        while (m.getLevel() != level) {
            IMemberList children = reader.getMemberChildren(m);
            m = (Member)children.getFirst();
        }
        return m;
    }

    public static int getMemberOrdinalInParent(SchemaReader reader, Member member) throws OLAPException {
        Member parent = member.getParentMember();
        IMemberList siblings = parent == null ? reader.getHierarchyRootMembers(member.getHierarchy()) : reader.getMemberChildren(parent);
        int index = 0;
        Iterator iter = siblings.iterator();
        while (iter.hasNext()) {
            Member sibling = (Member)iter.next();
            if (sibling.equals(member)) {
                return index;
            }
            ++index;
        }
        throw new OLAPException("could not find member " + member + " amongst its siblings");
    }

    public static OLAPElement lookupCompound(SchemaReader schemaReader, OLAPElement parent, String[] names, int category) throws OLAPException {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            OLAPElement child = schemaReader.getElementChild(parent, name);
            if (child == null) {
                return null;
            }
            parent = child;
        }
        switch (category) {
            case 2: {
                if (parent instanceof Dimension) {
                    return parent;
                }
                if (parent instanceof Hierarchy) {
                    return ((Hierarchy)parent).getDimension();
                }
                return null;
            }
            case 3: {
                if (parent instanceof Hierarchy) {
                    return parent;
                }
                if (parent instanceof Dimension) {
                    return ((Dimension)parent).getHierarchy();
                }
                return null;
            }
            case 4: {
                if (parent instanceof Level) {
                    return parent;
                }
                return null;
            }
            case 6: {
                if (parent instanceof Member) {
                    return parent;
                }
                return null;
            }
            case 0: {
                return parent;
            }
        }
        throw Util.newInternal("Bad switch " + category);
    }

    public static OLAPElement lookup(MdxQuery q, String[] namesArray) throws OLAPException {
        SchemaReader schemaReader = q.getSchemaReader();
        schemaReader = q.getSchemaReader();
        OLAPElement olapElement = schemaReader.lookupCompound(q.getCube(), namesArray, 0);
        if (olapElement == null) {
            String fullName = Util.quoteMdxIdentifier(namesArray);
            throw new OLAPException("can't find " + fullName + "  in cube " + q.getCubeName());
        }
        return olapElement;
    }

    public static Level lookupHierarchyLevel(Hierarchy hierarchy, String s) {
        Level[] levels = hierarchy.getLevels();
        for (int i = 0; i < levels.length; ++i) {
            if (!levels[i].getName().equalsIgnoreCase(s)) continue;
            return levels[i];
        }
        return null;
    }

    public static Exp createExpr(OLAPElement element) {
        if (element instanceof Member) {
            Member member = (Member)element;
            return new MemberExpr(member);
        }
        if (element instanceof Level) {
            Level level = (Level)element;
            return new LevelExpr(level);
        }
        if (element instanceof Hierarchy) {
            Hierarchy hierarchy = (Hierarchy)element;
            return new HierarchyExpr(hierarchy);
        }
        if (element instanceof Dimension) {
            Dimension dimension = (Dimension)element;
            return new DimensionExpr(dimension);
        }
        if (element instanceof Set) {
            Set namedSet = (Set)element;
            return new NamedSetExpr(namedSet);
        }
        throw Util.newInternal("Unexpected element type: " + element);
    }
}

