/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.calc.impl.func;

import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.HierarchyCalc;
import com.kingdee.bos.olap.mdx.calc.IntegerCalc;
import com.kingdee.bos.olap.mdx.calc.Scope;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractMemberListCalc;
import com.kingdee.bos.olap.mdx.func.FuncUtil2;

public class HierarchyMembersAboveLevelCalc
extends AbstractMemberListCalc {
    HierarchyCalc hierarchyCalc;
    IntegerCalc integerCalc;
    Scope.NeedHierarchize needHierarchize = Scope.NeedHierarchize.Yes;
    boolean needNonEmpty = false;

    public HierarchyMembersAboveLevelCalc(Exp exp, HierarchyCalc hierarchyCalc, IntegerCalc integerCalc) {
        super(exp, new Calc[]{hierarchyCalc, integerCalc});
        this.hierarchyCalc = hierarchyCalc;
        this.integerCalc = integerCalc;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws OLAPException {
        this.needHierarchize = scope.getNeedHierarchize();
        this.needNonEmpty = scope.isNeedNonEmpty();
        return super.optimize(scope, evaluator);
    }

    @Override
    public IMemberList evaluateMemberList(Evaluator evaluator) throws OLAPException {
        Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
        int index = this.integerCalc.evaluateInteger(evaluator);
        Level level = hierarchy.getLevels()[0];
        if (index < 0) {
            index = 0;
        }
        IMemberList members = evaluator.getQuery().getListFactory().createMemberList();
        while (level != null && index > level.getDepth()) {
            members.addList(evaluator.getSchemaReader().getLevelMembers(level));
            level = level.getChildLevel();
        }
        if (this.needHierarchize != Scope.NeedHierarchize.No) {
            FuncUtil2.hierarchize(members, false);
        }
        return members;
    }
}

