/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.calc.impl.func;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.IntegerCalc;
import com.kingdee.bos.olap.mdx.calc.ListCalc;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractListCalc;

public class SubsetCalc
extends AbstractListCalc {
    ListCalc listCalc;
    IntegerCalc startCalc;
    IntegerCalc countCalc;

    public SubsetCalc(Exp exp, ListCalc listCalc, IntegerCalc startCalc, IntegerCalc countCalc) {
        super(exp, new Calc[]{listCalc, startCalc, countCalc});
        this.listCalc = listCalc;
        this.startCalc = startCalc;
        this.countCalc = countCalc;
    }

    @Override
    public IList evaluateList(Evaluator evaluator) throws OLAPException {
        int end;
        IList list = this.listCalc.evaluateList(evaluator);
        int start = this.startCalc.evaluateInteger(evaluator);
        if (this.countCalc != null) {
            int count = this.countCalc.evaluateInteger(evaluator);
            end = start + count;
        } else {
            end = list.size();
        }
        if (end > list.size()) {
            end = list.size();
        }
        if (start >= end || start < 0) {
            return IList.EMPTY;
        }
        if (start == 0 && end == list.size()) {
            return list;
        }
        return list.subList(start, end);
    }
}

