/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.elementexp;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.ExpBase;
import com.kingdee.bos.olap.mdx.ExpResolver;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.impl.ConstantCalc;
import com.kingdee.bos.olap.mdx.type.DimensionType;
import com.kingdee.bos.olap.mdx.type.Type;

public class DimensionExpr
extends ExpBase
implements Exp {
    private final Dimension dimension;

    public DimensionExpr(Dimension dimension) {
        this.dimension = dimension;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public String toString() {
        return this.dimension.getUniqueName();
    }

    @Override
    public Type getType() {
        return DimensionType.forDimension(this.dimension);
    }

    @Override
    public Object clone() {
        return new DimensionExpr(this.dimension);
    }

    @Override
    public int getCategory() {
        return 2;
    }

    @Override
    public Calc compile(ExpCompiler compiler) {
        return ConstantCalc.constantDimension(this.dimension);
    }

    @Override
    public Exp resolve(ExpResolver resolver) throws OLAPException {
        return this;
    }

    public Object evaluate(Evaluator evaluator) throws OLAPException {
        return this.dimension;
    }
}

