/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.func;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.FunDef;
import com.kingdee.bos.olap.mdx.FunDefBase;
import com.kingdee.bos.olap.mdx.FuncResolver;
import com.kingdee.bos.olap.mdx.MultiFuncResolver;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.IntegerCalc;
import com.kingdee.bos.olap.mdx.calc.ListCalc;
import com.kingdee.bos.olap.mdx.calc.impl.func.TopBottomCountCalc;

class TopBottomCountFunDef
extends FunDefBase {
    boolean top;
    static final MultiFuncResolver TopCountResolver = new MultiFuncResolver("TopCount", "TopCount(<Set>, <Count>[, <Numeric Expression>])", "Returns a specified number of items from the top of a set, optionally ordering the set first.", new String[]{"fxxnn", "fxxn"}){

        @Override
        protected FunDef createFunDef(Exp[] args, int returnCategory, int[] argCategorys) {
            return new TopBottomCountFunDef(this, returnCategory, argCategorys, true);
        }
    };
    static final MultiFuncResolver BottomCountResolver = new MultiFuncResolver("BottomCount", "BottomCount(<Set>, <Count>[, <Numeric Expression>])", "Returns a specified number of items from the bottom of a set, optionally ordering the set first.", new String[]{"fxxnn", "fxxn"}){

        @Override
        protected FunDef createFunDef(Exp[] args, int returnCategory, int[] argCategorys) {
            return new TopBottomCountFunDef(this, returnCategory, argCategorys, false);
        }
    };

    public TopBottomCountFunDef(FuncResolver funcResolver, int returnCategory, int[] argCategorys, boolean top) {
        super(funcResolver, returnCategory, argCategorys);
        this.top = top;
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OLAPException {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        IntegerCalc integerCalc = compiler.compileInteger(call.getArg(1));
        Calc orderCalc = call.getArgCount() > 2 ? compiler.compileScalar(call.getArg(2), true) : null;
        return new TopBottomCountCalc(call, listCalc, integerCalc, orderCalc, this.top);
    }
}

