/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.func;

import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.FunDefBase;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.IntegerCalc;
import com.kingdee.bos.olap.mdx.calc.MemberCalc;
import com.kingdee.bos.olap.mdx.calc.TupleCalc;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractMemberCalc;
import com.kingdee.bos.olap.mdx.type.MemberType;
import com.kingdee.bos.olap.mdx.type.TupleType;
import com.kingdee.bos.olap.mdx.type.Type;

class TupleItemFunDef
extends FunDefBase {
    static final TupleItemFunDef instance = new TupleItemFunDef();

    private TupleItemFunDef() {
        super("Item", "<Tuple>.Item(<Index>)", "Returns a member from the tuple specified in <Tuple>. The member to be returned is specified by the zero-based position of the member in the set in <Index>.", "mmtn");
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OLAPException {
        Type type = call.getArg(0).getType();
        if (type instanceof MemberType) {
            final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
            final IntegerCalc indexCalc = compiler.compileInteger(call.getArg(1));
            return new AbstractMemberCalc(call, new Calc[]{memberCalc, indexCalc}){

                @Override
                public Member evaluateMember(Evaluator evaluator) throws OLAPException {
                    Member member = memberCalc.evaluateMember(evaluator);
                    int index = indexCalc.evaluateInteger(evaluator);
                    if (index != 0) {
                        return null;
                    }
                    return member;
                }
            };
        }
        final TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
        final IntegerCalc indexCalc = compiler.compileInteger(call.getArg(1));
        return new AbstractMemberCalc(call, new Calc[]{tupleCalc, indexCalc}){
            final Member[] nullTupleMembers;
            {
                super(exp, calcs);
                this.nullTupleMembers = TupleItemFunDef.this.makeNullTuple((TupleType)tupleCalc.getType());
            }

            @Override
            public Member evaluateMember(Evaluator evaluator) throws OLAPException {
                Member[] members = tupleCalc.evaluateTuple(evaluator);
                assert (members == null || members.length == this.nullTupleMembers.length);
                int index = indexCalc.evaluateInteger(evaluator);
                if (members == null) {
                    return this.nullTupleMembers[index];
                }
                if (index >= members.length || index < 0) {
                    return null;
                }
                return members[index];
            }
        };
    }

    public Member[] makeNullTuple(TupleType tupleType) {
        Member[] members = new Member[tupleType.elementTypes.length];
        for (int i = 0; i < tupleType.elementTypes.length; ++i) {
            MemberType type = (MemberType)tupleType.elementTypes[i];
            members[i] = this.makeNullMember(type);
        }
        return members;
    }

    Member makeNullMember(MemberType memberType) {
        Hierarchy hierarchy = memberType.getHierarchy();
        if (hierarchy == null) {
            return null;
        }
        return hierarchy.getNullMember();
    }
}

