/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem;

import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.Persistable;
import com.kingdee.bos.olap.mem.Aggregator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class CubeData
implements Persistable {
    public static final int NONE = 0;
    public static final int DETAIL = 1;
    public static final int ALL = -1;
    public Cube cube;
    protected Aggregator[] aggs;
    protected Member[] measures;

    protected CubeData() {
    }

    public CubeData(Cube _cube) {
        this.cube = _cube;
    }

    public void buildData() throws OLAPException {
        this.buildData(1);
    }

    public Object getCell(Member[] point) throws OLAPException {
        return this.getCell(point, new HashMap());
    }

    public Object getCell(Member[] point, Map pinCache) throws OLAPException {
        ArrayList<Member> list = new ArrayList<Member>(point.length);
        Member measure = null;
        for (int i = 0; i < point.length; ++i) {
            if (point[i].getDimension().isMeasureDimension()) {
                measure = point[i];
                continue;
            }
            list.add(point[i]);
        }
        int measureIndex = -1;
        for (int i = 0; i < this.measures.length; ++i) {
            if (measure == null || !this.measures[i].getName().equals(measure.getName())) continue;
            measureIndex = i;
            break;
        }
        point = new Member[list.size()];
        list.toArray(point);
        Object[] values = this.getData(point, pinCache);
        if (values == null) {
            return null;
        }
        if (measureIndex > -1) {
            return values[measureIndex];
        }
        return null;
    }

    public abstract void addRecord(Member[] var1, Object[] var2) throws OLAPException;

    public abstract void finishAddRecord() throws OLAPException;

    public abstract void compact();

    public abstract void buildData(int var1) throws OLAPException;

    public abstract void finishBuildData() throws OLAPException;

    public abstract Object[] getData(Member[] var1) throws OLAPException;

    public abstract Object[] getData(Member[] var1, Map var2) throws OLAPException;

    public abstract Object[] appendAggregator(Object[] var1, Object[] var2) throws OLAPException;

    public abstract Object[] appendValue(Object[] var1, Object[] var2) throws OLAPException;

    public abstract void release();
}

