/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mem.Aggregator;
import com.kingdee.bos.olap.mem.Chunk;
import com.kingdee.bos.olap.mem.CubeData;
import com.kingdee.bos.olap.mem.Point;
import com.kingdee.bos.olap.mem.impl.ChunkImpl;
import com.kingdee.bos.olap.mem.impl.CubeImpl;
import com.kingdee.bos.olap.mem.impl.MemberImpl;
import com.kingdee.bos.olap.mem.impl.SchemaImpl;
import com.kingdee.bos.olap.mem.storage.ChunkStorageManager;
import com.kingdee.bos.olap.util.ByteArrayInputStream;
import com.kingdee.bos.olap.util.ByteArrayOutputStream;
import com.kingdee.bos.olap.util.InOutSqlUtil;
import com.kingdee.bos.olap.util.RepeatableSortedArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class ChunkedCubeData
extends CubeData {
    private static Logger logger = CommonLogger.getLogger(ChunkedCubeData.class);
    private RecordPool pool;
    int recordPoolSize = 5000;
    private ChunkStorageManager csm;
    private int records = 0;
    private Member[] cachePoint;
    private Object[] cacheData;
    LinkedList toAggChunks = new LinkedList();
    private static ChunkRecordSizeComparator chunkRecordSizeComparator = new ChunkRecordSizeComparator();

    public ChunkedCubeData() throws OLAPException {
        this.pool = new RecordPool(this);
        try {
            this.csm = ChunkStorageManager.getChunkStorageManager(this);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OLAPException("Fail in new ChunkStorageManager", e);
        }
    }

    public ChunkedCubeData(Cube cube) throws OLAPException {
        super(cube);
        this.measures = cube.getMeasures();
        this.aggs = new Aggregator[this.measures.length];
        for (int i = 0; i < this.aggs.length; ++i) {
            String aggName = (String)this.measures[i].getProperty("aggregator");
            if (aggName == null) continue;
            this.aggs[i] = Aggregator.getAggregator(aggName);
        }
        this.pool = new RecordPool(this);
        try {
            this.csm = ChunkStorageManager.getChunkStorageManager(this);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OLAPException("Fail in new ChunkStorageManager", e);
        }
    }

    @Override
    public void addRecord(Member[] members, Object[] values) throws OLAPException {
        for (int i = 0; i < members.length; ++i) {
            IMemberList children = members[i].getChildMembers();
            if (children == null || children.isEmpty()) continue;
            return;
        }
        try {
            ++this.records;
            this.pool.addRecord((MemberImpl[])members, values);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new OLAPException(ioe);
        }
    }

    @Override
    public void finishAddRecord() throws OLAPException {
        try {
            this.pool.flush(false);
            Iterator iter = this.pool.savedChunk.iterator();
            while (iter.hasNext()) {
                this.toAggChunks.add(iter.next());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new OLAPException(ioe);
        }
        logger.debug((Object)(this.records + " record(s)\t\t" + this.csm.getChunkCount() + " detail chunk(s)\t\t" + this.csm.getPointCount() + " detail points\t\t"));
    }

    @Override
    public void buildData(int level) throws OLAPException {
        try {
            this.calcAggs();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new OLAPException(ioe);
        }
    }

    private void calcAggs() throws OLAPException, IOException {
        int size;
        while ((size = this.toAggChunks.size()) != 0) {
            int i = 0;
            while (i++ < size) {
                Chunk.ChunkId chunkId = (Chunk.ChunkId)this.toAggChunks.remove(0);
                this.calcChunkAgg(chunkId);
            }
            this.pool.flush(true);
            logger.debug((Object)("pool.savedChunk.size:" + this.pool.savedChunk.size()));
            Iterator iter = this.pool.savedChunk.iterator();
            while (iter.hasNext()) {
                this.toAggChunks.add(iter.next());
            }
            this.pool.clear();
        }
        return;
    }

    private void calcChunkAgg(Chunk.ChunkId chunkId) throws OLAPException, IOException {
        Chunk chunk = this.csm.getChunk(chunkId);
        Point rootPoint = new Point(this.cube, chunkId.id);
        HashSet toCalcSet = new HashSet();
        HashMap chunkMap = new HashMap();
        Iterator entryIter = chunk.entryIterator();
        while (entryIter.hasNext()) {
            Chunk.Entry entry = (Chunk.Entry)entryIter.next();
            Point point = entry.point;
            chunkMap.put(point, entry.values);
            ArrayList parents = this.getParents(point, rootPoint);
            int count = parents.size();
            for (int i = 0; i < count; ++i) {
                toCalcSet.add(parents.get(i));
            }
        }
        while (chunkMap != null && toCalcSet != null) {
            Object[] o = this.innerCalcChunkAgg(chunk, rootPoint, chunkMap, toCalcSet);
            toCalcSet = (HashSet)o[0];
            chunkMap = (HashMap)o[1];
        }
    }

    private Object[] innerCalcChunkAgg(Chunk chunk, Point rootPoint, HashMap chunkMap, HashSet toCalcSet) throws OLAPException, IOException {
        HashSet<Point> nextToCalc = new HashSet<Point>();
        HashMap<Point, Object[]> nextChunkMap = new HashMap<Point, Object[]>();
        int size = toCalcSet.size();
        if (size == 0) {
            return new Object[]{null, null};
        }
        boolean needover = false;
        for (Point point : toCalcSet) {
            if (point.equals(rootPoint)) {
                if (size > 1) {
                    nextToCalc.add(point);
                    continue;
                }
                needover = true;
            }
            Member[] members = point.getMembers();
            boolean notnull = false;
            Object[] values = new Object[this.aggs.length];
            Member[] ms = new Member[members.length];
            System.arraycopy(members, 0, ms, 0, ms.length);
            for (int i = 0; i < members.length; ++i) {
                IMemberList list = members[i].getChildMembers();
                Member[] sms = (Member[])list.toArray(new Member[list.size()]);
                if (sms == null || sms.length <= 0) continue;
                for (int j = 0; j < sms.length; ++j) {
                    ms[i] = sms[j];
                    Object[] vs = (Object[])chunkMap.get(new Point(ms));
                    if (vs == null) continue;
                    values = this.appendAggregator(values, vs);
                    notnull = true;
                }
                break;
            }
            if (!notnull) continue;
            this.pool.addAggPoint(point, values);
            if (point.equals(rootPoint)) continue;
            ArrayList parents = this.getParents(point, rootPoint);
            int count = parents.size();
            for (int i = 0; i < count; ++i) {
                nextToCalc.add((Point)parents.get(i));
            }
            nextChunkMap.put(point, values);
        }
        chunkMap.clear();
        toCalcSet.clear();
        if (!needover) {
            return new Object[]{nextToCalc, nextChunkMap};
        }
        return new Object[]{null, null};
    }

    private ArrayList getParents(Point point, Point rootPoint) throws OLAPException {
        ArrayList<Point> ret = new ArrayList<Point>();
        Member[] ms = point.getMembers();
        Member[] ms2 = new Member[ms.length];
        Member[] rootMembers = rootPoint.getMembers();
        int likeRoot = 0;
        int len = ms.length;
        for (int i = 0; i < len; ++i) {
            if (rootPoint != null && ms[i].equals(rootMembers[i])) {
                ++likeRoot;
                continue;
            }
            Member parent = ms[i].getParentMember();
            if (len > 1 && likeRoot == len - 1 && parent.equals(rootMembers[i])) break;
            if (parent == null || parent.getParentMember() == null) continue;
            System.arraycopy(ms, 0, ms2, 0, len);
            ms2[i] = parent;
            ret.add(new Point(ms2));
        }
        return ret;
    }

    @Override
    public void compact() {
    }

    @Override
    public Object[] getData(Member[] point) throws OLAPException {
        return this.getData(point, new HashMap());
    }

    @Override
    public Object[] getData(Member[] point, Map pinCache) throws OLAPException {
        if (point.equals(this.cachePoint)) {
            return this.cacheData;
        }
        if (pinCache == null) {
            pinCache = new HashMap();
        }
        Object[] value = this.getValue(this.getData1(point, pinCache));
        return value;
    }

    private Object[] getData1(Member[] point, Map pinCache) throws OLAPException {
        for (int i = 0; i < point.length; ++i) {
            if (point[i].isInner() || point[i].hasData()) continue;
            return null;
        }
        Object[] value = null;
        Chunk.ChunkId id = ChunkImpl.calcChunkId(point);
        try {
            int minIndex = Integer.MAX_VALUE;
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < point.length; ++i) {
                int len;
                IMemberList children;
                Member parent = point[i].getParentMember();
                if (parent != null || (children = point[i].isInner() ? point[i].getHierarchy().getMembers() : point[i].getChildMembers()) == null || children.isEmpty() || (len = children.size()) >= min) continue;
                min = len;
                minIndex = i;
            }
            if (minIndex != Integer.MAX_VALUE) {
                IMemberList children = point[minIndex].isInner() ? point[minIndex].getHierarchy().getMembers() : point[minIndex].getChildMembers();
                Member[] ms = (Member[])point.clone();
                Iterator iter = children.iterator();
                while (iter.hasNext()) {
                    ms[minIndex] = (Member)iter.next();
                    value = this.appendAggregator(value, this.getData1(ms, pinCache));
                }
            } else {
                Chunk chunk = (Chunk)pinCache.get(id);
                if (chunk == null) {
                    chunk = this.csm.getChunk(id);
                    pinCache.put(id, chunk);
                }
                if (chunk != null) {
                    value = chunk.getValue(Point.calcKey(point));
                }
            }
            this.cachePoint = point;
            this.cacheData = value;
            return value;
        }
        catch (IOException ioe) {
            throw new OLAPException(ioe);
        }
    }

    private Object[] getValue(Object[] vs) throws OLAPException {
        if (vs == null) {
            return null;
        }
        Object[] vs1 = new Object[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            vs1[i] = i > this.measures.length - 1 || this.aggs[i] == null ? vs[i] : this.aggs[i].getValue(vs[i]);
        }
        return vs1;
    }

    @Override
    public void store(ObjectOutputStream out) throws IOException {
        out.writeObject(this.cube.getName());
        out.writeObject(this.aggs);
        out.writeObject(this.measures);
        out.writeInt(this.csm.getChunkCount());
        Iterator iterChunks = this.csm.chunkIterator();
        while (iterChunks.hasNext()) {
            ChunkImpl chunk = (ChunkImpl)iterChunks.next();
            out.writeInt(chunk.getId().id);
            out.writeInt(chunk.size());
            Iterator entryIter = chunk.entryIterator();
            while (entryIter.hasNext()) {
                Chunk.Entry entry = (Chunk.Entry)entryIter.next();
                int key = entry.point.getKey();
                Object[] values = entry.values;
                ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                for (int i = 0; i < this.measures.length; ++i) {
                    boolean valueIsCompounded = this.aggs[i] != null && this.aggs[i].valueIsCompounded();
                    InOutSqlUtil.writeObject(values[i], this.measures[i].getDataType(), valueIsCompounded, this.aggs[i] == null ? null : this.aggs[i].getSerialize(), baos2);
                }
                byte[] bs = baos2.toByteArray();
                out.writeInt(key);
                out.writeInt(bs.length);
                out.write(bs);
                if (values.length > this.measures.length) {
                    out.writeBoolean(true);
                    Object[] propValues = new Object[values.length - this.measures.length];
                    System.arraycopy(values, this.measures.length, propValues, 0, propValues.length);
                    out.writeObject(propValues);
                    continue;
                }
                out.writeBoolean(false);
            }
        }
    }

    @Override
    public void restore(ObjectInputStream in, Object info) throws IOException {
        SchemaImpl schema = (SchemaImpl)info;
        CubeImpl[] cubes = schema.cubes;
        try {
            String cubeName = (String)in.readObject();
            for (int i = 0; i < cubes.length; ++i) {
                if (!cubes[i].getName().equals(cubeName)) continue;
                this.cube = cubes[i];
                break;
            }
            this.aggs = (Aggregator[])in.readObject();
            this.measures = (Member[])in.readObject();
            boolean[] valueIsCompoundeds = new boolean[this.measures.length];
            int[] dataTypes = new int[this.measures.length];
            for (int k = 0; k < this.measures.length; ++k) {
                valueIsCompoundeds[k] = this.aggs[k] != null && this.aggs[k].valueIsCompounded();
                dataTypes[k] = this.measures[k].getDataType();
            }
            int chunkCount = in.readInt();
            for (int i = 0; i < chunkCount; ++i) {
                int id = in.readInt();
                ChunkImpl chunk = new ChunkImpl(this.csm, new Chunk.ChunkId(id), this);
                int size = in.readInt();
                for (int j = 0; j < size; ++j) {
                    int key = in.readInt();
                    int len = in.readInt();
                    byte[] bs = new byte[len];
                    in.readFully(bs);
                    ByteArrayInputStream bais = new ByteArrayInputStream(bs);
                    Object[] values = new Object[this.measures.length];
                    for (int k = 0; k < this.measures.length; ++k) {
                        values[k] = InOutSqlUtil.readObject(dataTypes[k], valueIsCompoundeds[k], this.aggs[k] == null ? null : this.aggs[k].getSerialize(), bais);
                    }
                    if (in.readBoolean()) {
                        Object[] propValues = (Object[])in.readObject();
                        Object[] vs = new Object[values.length + propValues.length];
                        System.arraycopy(values, 0, vs, 0, values.length);
                        System.arraycopy(propValues, 0, vs, values.length, propValues.length);
                        values = vs;
                    }
                    chunk.add(new Point(this.cube, key), values);
                }
                chunk.save(true);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
        catch (OLAPException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public Object[] appendAggregator(Object[] v1, Object[] v2) throws OLAPException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            v1 = new Object[this.measures.length];
            for (int i = 0; i < this.measures.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendAggregator(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new OLAPException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendAggregator(v1[i], v2[i]);
        }
        return result;
    }

    @Override
    public Object[] appendValue(Object[] v1, Object[] v2) throws OLAPException {
        int i;
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v1 == null) {
            v1 = new Object[v2.length];
            for (int i2 = 0; i2 < v1.length; ++i2) {
                v1[i2] = i2 >= this.measures.length || this.aggs[i2] == null ? v2[i2] : this.aggs[i2].appendValue(v1[i2], v2[i2]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (i = 0; i < this.measures.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new OLAPException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendValue(v1[i], v2[i]);
        }
        for (i = this.measures.length; i < v1.length; ++i) {
            result[i] = v1[i] != null ? v1[i] : v2[i];
        }
        return result;
    }

    @Override
    public void finishBuildData() throws OLAPException {
        try {
            this.pool.flush(true);
            this.pool.clear();
        }
        catch (IOException ioe) {
            throw new OLAPException(ioe);
        }
        logger.debug((Object)("" + this.csm.getChunkCount() + " chunk(s)\t\t" + this.csm.getPointCount() + " points\t\t"));
    }

    @Override
    public void release() {
        this.pool.clear();
        this.csm.release();
    }

    static /* synthetic */ ChunkRecordSizeComparator access$000() {
        return chunkRecordSizeComparator;
    }

    private static class ChunkRecordSizeComparator
    implements Comparator {
        private ChunkRecordSizeComparator() {
        }

        public int compare(Object a, Object b) {
            int size2;
            ChunkRecord cr1 = (ChunkRecord)a;
            ChunkRecord cr2 = (ChunkRecord)b;
            int size1 = cr1.size();
            if (size1 < (size2 = cr2.size())) {
                return -1;
            }
            if (size1 > size2) {
                return 1;
            }
            return 0;
        }
    }

    private class ChunkRecord {
        Chunk.ChunkId id;
        HashMap records = new HashMap();
        Cube cube;
        CubeData data;

        ChunkRecord(CubeData _data, Chunk.ChunkId id) {
            this.id = id;
            this.data = _data;
            this.cube = this.data.cube;
        }

        boolean add(MemberImpl[] members, Object[] values) throws OLAPException {
            Point p = new Point(members);
            Object[] v1 = (Object[])this.records.get(p);
            values = ChunkedCubeData.this.appendValue(v1, values);
            return this.records.put(p, values) != null;
        }

        boolean addAggPoint(Point point, Object[] values) throws OLAPException {
            return this.records.put(point, values) != null;
        }

        int size() {
            return this.records.size();
        }

        void save(boolean override) throws IOException, OLAPException {
            ChunkImpl chunk = new ChunkImpl(ChunkedCubeData.this.csm, this.id, this.data);
            for (Point point : this.records.keySet()) {
                Object[] vs = (Object[])this.records.get(point);
                chunk.add(point, vs);
            }
            chunk.save(override);
        }
    }

    class RecordPool {
        RepeatableSortedArray chunkRecordSet = new RepeatableSortedArray(ChunkedCubeData.access$000(), 32);
        HashMap chunkRecordMap = new HashMap();
        HashSet savedChunk = new HashSet();
        CubeData data;
        int size = 0;

        RecordPool(CubeData d) {
            this.data = d;
        }

        private void saveOne(boolean override) throws IOException, OLAPException {
            ChunkRecord cr = (ChunkRecord)this.chunkRecordSet.removeLast();
            this.chunkRecordMap.remove(cr.id);
            cr.save(override);
            this.savedChunk.add(cr.id);
            this.size -= cr.size();
        }

        public void addRecord(MemberImpl[] members, Object[] values) throws OLAPException, IOException {
            if (this.size() == ChunkedCubeData.this.recordPoolSize) {
                this.saveOne(false);
            }
            Chunk.ChunkId id = ChunkImpl.calcChunkId(members);
            Object o = this.chunkRecordMap.get(id);
            ChunkRecord cr = null;
            if (o == null) {
                cr = new ChunkRecord(this.data, id);
                this.chunkRecordMap.put(id, cr);
                this.chunkRecordSet.add(cr);
            } else {
                cr = (ChunkRecord)o;
            }
            if (!cr.add(members, values)) {
                ++this.size;
            }
        }

        public void addAggPoint(Point point, Object[] values) throws OLAPException, IOException {
            if (this.size() == ChunkedCubeData.this.recordPoolSize) {
                this.saveOne(true);
            }
            Chunk.ChunkId chunkId = ChunkImpl.calcChunkId(point.getMembers());
            Object o = this.chunkRecordMap.get(chunkId);
            ChunkRecord cr = null;
            if (o == null) {
                cr = new ChunkRecord(this.data, chunkId);
                this.chunkRecordMap.put(chunkId, cr);
                this.chunkRecordSet.add(cr);
            } else {
                cr = (ChunkRecord)o;
            }
            if (!cr.addAggPoint(point, values)) {
                ++this.size;
            }
        }

        public void flush(boolean override) throws IOException, OLAPException {
            ChunkRecord cr;
            while ((cr = (ChunkRecord)this.chunkRecordSet.removeLast()) != null) {
                this.chunkRecordMap.remove(cr.id);
                cr.save(override);
                this.savedChunk.add(cr.id);
            }
            this.chunkRecordMap.clear();
            this.chunkRecordSet.clear();
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        public void clear() {
            this.chunkRecordSet.clear();
            this.chunkRecordMap.clear();
            this.savedChunk.clear();
            this.size = 0;
        }
    }
}

