/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.Schema;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.mdx.CellReader;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.MdxResult;
import com.kingdee.bos.olap.mdx.ParserHelp;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mem.OLAPDatabase;
import com.kingdee.bos.olap.mem.OLAPEngine;
import com.kingdee.bos.olap.mem.impl.CellReaderImpl;
import com.kingdee.bos.olap.mem.impl.CubeImpl;
import com.kingdee.bos.olap.mem.impl.MdxResultImpl;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ConnectionImpl
implements Connection,
Serializable {
    private static final long serialVersionUID = -8852145556892326649L;
    OLAPDatabase database;
    HashMap mapSqlInfo;
    Locale locale;

    public ConnectionImpl(SchemaDef schemaDef, Map param) throws OLAPException, SQLException {
        this(OLAPEngine.build(schemaDef, param));
        this.mapSqlInfo = new HashMap();
        if (schemaDef.tables != null) {
            for (int i = 0; i < schemaDef.tables.length; ++i) {
                this.mapSqlInfo.put(schemaDef.tables[i].name, schemaDef.tables[i].sql);
            }
        }
    }

    public ConnectionImpl(OLAPDatabase database) {
        if (database == null) {
            throw new NullPointerException();
        }
        this.database = database;
    }

    public Schema getSchema() throws OLAPException {
        return this.database.schema;
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.database.getSchemaReader();
    }

    @Override
    public SchemaReader getRemoteSchemaReader() {
        return this.database.getSchemaReader();
    }

    @Override
    public MdxResult executeMdxQuery(MdxQuery query) throws OLAPException {
        query.setConnection(this);
        MdxResultImpl result = new MdxResultImpl(query);
        return result;
    }

    @Override
    public MdxResult executeMdxQuery(String mdx) throws OLAPException {
        try {
            return this.executeMdxQuery(this.parseQuery(mdx));
        }
        catch (OLAPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OLAPException(e);
        }
    }

    @Override
    public MdxQuery parseQuery(String mdx) throws OLAPException {
        return ParserHelp.parseQuery(this, mdx);
    }

    @Override
    public void close() {
        if (this.database != null) {
            this.database.release();
            this.database = null;
        }
    }

    @Override
    public String getDefaultCubeName() {
        return this.database.getDefaultCubeName();
    }

    @Override
    public boolean isRolap() {
        return false;
    }

    @Override
    public Exp parseExpression(String expression) throws OLAPException {
        return ParserHelp.parseExpression(expression);
    }

    public CellReader getCellReader(CubeImpl cube) {
        return new CellReaderImpl(this.database.getCubeData(cube));
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

