/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.rel.ColumnConstraint;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.rel.Star;
import java.util.ArrayList;
import java.util.List;

public class CellRequest {
    private final Star.Column measure;
    private final List columnList = new FastHashingArrayList(5);
    private final List valueList = new ArrayList();

    public CellRequest(Star.Column measure) {
        this.measure = measure;
        this.columnList.add(measure.getStar());
    }

    public void addConstrainedColumn(Star.Column column, RelMemberImpl member) {
        if (!this.columnList.contains(column)) {
            this.columnList.add(column);
        }
        this.valueList.add(new ColumnConstraint(member));
    }

    public Star.Column getMeasure() {
        return this.measure;
    }

    public Star.Column[] getColumns() {
        Star.Column[] a = new Star.Column[this.columnList.size() - 1];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (Star.Column)this.columnList.get(i + 1);
        }
        return a;
    }

    public List getBatchKey() {
        return this.columnList;
    }

    public List getValueList() {
        return this.valueList;
    }

    public Object[] getSingleValues() {
        Object[] a = new Object[this.valueList.size()];
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            ColumnConstraint constr = (ColumnConstraint)this.valueList.get(i);
            a[i] = constr.getValue();
        }
        return a;
    }

    private static class FastHashingArrayList
    extends ArrayList {
        FastHashingArrayList(int capacity) {
            super(capacity);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof FastHashingArrayList)) {
                return false;
            }
            FastHashingArrayList that = (FastHashingArrayList)o;
            int size = this.size();
            if (size != that.size()) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                Object o2;
                Object o1 = this.get(i);
                if (o1.equals(o2 = that.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                Object obj = this.get(i);
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            return hashCode;
        }
    }
}

