/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.rel.AggregationManager;
import com.kingdee.bos.olap.rel.CellRequest;
import com.kingdee.bos.olap.rel.ColumnConstraint;
import com.kingdee.bos.olap.rel.Star;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class CellRequestBatch {
    private final Set pinnedSegments;
    final Star.Column[] columns;
    final List measuresList = new ArrayList();
    final Set[] valueSets;

    public CellRequestBatch(CellRequest request, Set pinnedSegments) {
        this.columns = request.getColumns();
        this.valueSets = new HashSet[this.columns.length];
        for (int i = 0; i < this.valueSets.length; ++i) {
            this.valueSets[i] = new HashSet();
        }
        this.pinnedSegments = pinnedSegments;
    }

    public void add(CellRequest request) {
        List values = request.getValueList();
        for (int j = 0; j < this.columns.length; ++j) {
            this.valueSets[j].add(values.get(j));
        }
        Star.Column measure = request.getMeasure();
        if (!this.measuresList.contains(measure)) {
            this.measuresList.add(measure);
        }
    }

    void loadAggregation() throws OLAPException {
        ColumnConstraint[][] constraintses = new ColumnConstraint[this.columns.length][];
        for (int j = 0; j < this.columns.length; ++j) {
            ColumnConstraint[] constraints;
            Set valueSet = this.valueSets[j];
            if (valueSet == null) {
                constraints = null;
            } else {
                constraints = new ColumnConstraint[valueSet.size()];
                valueSet.toArray(constraints);
            }
            constraintses[j] = constraints;
        }
        int measureCount = this.measuresList.size();
        if (measureCount > 0) {
            Star.Column[] measures = this.measuresList.toArray(new Star.Column[measureCount]);
            AggregationManager aggregationManager = measures[0].getStar().getAggregationManager();
            aggregationManager.loadAggregation(measures, this.columns, constraintses, this.pinnedSegments);
        }
    }
}

