/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.DefaultListFactory;
import com.kingdee.bos.olap.collection.IListFactory;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.rel.MemberCache;
import com.kingdee.bos.olap.rel.MemberReader;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.rel.RelSchemaImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.rel.SqlQuery;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;

public abstract class MemberReaderBase
implements MemberReader {
    RelSchemaImpl schema;
    RelHierarchyImpl hie;
    MemberCache cache;

    public MemberReaderBase(RelSchemaImpl schema, RelHierarchyImpl hie) {
        this.schema = schema;
        this.hie = hie;
        this.initAllLevel();
    }

    private void initAllLevel() {
        if (this.hie.hasAll()) {
            RelLevelImpl allLevel = new RelLevelImpl(null);
            allLevel.hie = this.hie;
            allLevel.depth = 0;
            allLevel.parent = null;
            allLevel.child = this.hie.levels[0];
            this.hie.levels[0].parent = allLevel;
            allLevel.levelType = (byte)-1;
            RelLevelImpl[] ls = new RelLevelImpl[this.hie.levels.length + 1];
            System.arraycopy(this.hie.levels, 0, ls, 1, this.hie.levels.length);
            ls[0] = allLevel;
            this.hie.levels = ls;
        }
    }

    @Override
    public boolean setCache(MemberCache cache) {
        this.cache = cache;
        return true;
    }

    @Override
    public RelHierarchyImpl getHierarchy() {
        return this.hie;
    }

    @Override
    public void getMemberDescendants(RelMemberImpl member, IMemberList result, RelLevelImpl level, boolean before, boolean self, boolean after) throws OLAPException {
        RelUtil.getMemberDescendants(this, member, level, result, before, self, after);
    }

    @Override
    public RelMemberImpl lookupMember(String[] uniqueNameParts) throws OLAPException {
        return RelUtil.lookupMember(this, uniqueNameParts);
    }

    @Override
    public RelMemberImpl getLeadMember(RelMemberImpl member, int n) throws OLAPException {
        return RelUtil.getLeadMember(this, member, n);
    }

    @Override
    public void getMemberRange(RelLevelImpl level, RelMemberImpl startMember, RelMemberImpl endMember, IMemberList list) throws OLAPException {
        RelUtil.getMemberRange(this, level, startMember, endMember, list);
    }

    @Override
    public void getMemberChildren(IMemberList parentMembers, IMemberList children) throws OLAPException {
        Iterator iter = parentMembers.iterator();
        while (iter.hasNext()) {
            this.getMemberChildren((RelMemberImpl)iter.next(), children);
        }
    }

    protected SqlQuery newQuery(Connection jdbcConnection, String err) throws OLAPException {
        try {
            return new SqlQuery(jdbcConnection.getMetaData());
        }
        catch (SQLException e) {
            throw new OLAPException(err, e);
        }
    }

    public String getTable() {
        return this.hie.dim.getTable();
    }

    @Override
    public IListFactory getListFactory() {
        return DefaultListFactory.instance;
    }
}

